/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.channel.RxDefaultThreadFactory;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.server.HttpConnectionHandler;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.server.ConnectionBasedServerBuilder;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerMetricsEvent;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HttpServerBuilder<I, O>
extends ConnectionBasedServerBuilder<HttpServerRequest<I>, HttpServerResponse<O>, HttpServerBuilder<I, O>> {
    private long contentSubscriptionTimeoutMs;

    public HttpServerBuilder(int port, RequestHandler<I, O> requestHandler, boolean send10ResponseFor10Request) {
        super(port, new HttpConnectionHandler<I, O>(requestHandler, send10ResponseFor10Request));
        this.pipelineConfigurator(PipelineConfigurators.httpServerConfigurator());
    }

    public HttpServerBuilder(ServerBootstrap bootstrap, int port, RequestHandler<I, O> requestHandler) {
        super(port, new HttpConnectionHandler<I, O>(requestHandler), bootstrap);
        this.pipelineConfigurator(PipelineConfigurators.httpServerConfigurator());
    }

    public HttpServerBuilder(int port, RequestHandler<I, O> requestHandler) {
        super(port, new HttpConnectionHandler<I, O>(requestHandler));
        this.pipelineConfigurator(PipelineConfigurators.httpServerConfigurator());
    }

    public HttpServerBuilder(ServerBootstrap bootstrap, int port, RequestHandler<I, O> requestHandler, boolean send10ResponseFor10Request) {
        super(port, new HttpConnectionHandler<I, O>(requestHandler, send10ResponseFor10Request), bootstrap);
        this.pipelineConfigurator(PipelineConfigurators.httpServerConfigurator());
    }

    @Override
    public HttpServerBuilder<I, O> withEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        return (HttpServerBuilder)super.withEventExecutorGroup(eventExecutorGroup);
    }

    public HttpServerBuilder<I, O> withRequestProcessingThreads(int threadCount) {
        return (HttpServerBuilder)super.withEventExecutorGroup((EventExecutorGroup)new DefaultEventExecutorGroup(threadCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rx-request-processor"))));
    }

    public HttpServerBuilder<I, O> withRequestProcessingThreads(int threadCount, ThreadFactory factory) {
        return (HttpServerBuilder)super.withEventExecutorGroup((EventExecutorGroup)new DefaultEventExecutorGroup(threadCount, factory));
    }

    public HttpServerBuilder<I, O> withRequestContentSubscriptionTimeout(long subscriptionTimeout, TimeUnit timeunit) {
        this.contentSubscriptionTimeoutMs = TimeUnit.MILLISECONDS.convert(subscriptionTimeout, timeunit);
        return this;
    }

    @Override
    public HttpServer<I, O> build() {
        return (HttpServer)super.build();
    }

    @Override
    protected HttpServer<I, O> createServer() {
        return new HttpServer((ServerBootstrap)this.serverBootstrap, this.port, this.pipelineConfigurator, (HttpConnectionHandler)this.connectionHandler, this.eventExecutorGroup, this.contentSubscriptionTimeoutMs);
    }

    @Override
    protected MetricEventsListener<ServerMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, RxServer<HttpServerRequest<I>, HttpServerResponse<O>> server) {
        return factory.forHttpServer((HttpServer)server);
    }
}

