/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.query.orderbyquery;

import com.microsoft.azure.cosmosdb.internal.query.ItemComparator;
import com.microsoft.azure.cosmosdb.internal.query.ItemType;
import com.microsoft.azure.cosmosdb.internal.query.ItemTypeHelper;
import com.microsoft.azure.cosmosdb.internal.query.QueryItem;
import com.microsoft.azure.cosmosdb.internal.query.SortOrder;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderByRowResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderbyRowComparer<T>
implements Comparator<OrderByRowResult<T>> {
    private static final Logger logger = LoggerFactory.getLogger(OrderbyRowComparer.class);
    private final List<SortOrder> sortOrders;
    private volatile List<ItemType> itemTypes;

    public OrderbyRowComparer(Collection<SortOrder> sortOrders) {
        this.sortOrders = new ArrayList<SortOrder>(sortOrders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(OrderByRowResult<T> r1, OrderByRowResult<T> r2) {
        try {
            List<QueryItem> result1 = r1.getOrderByItems();
            List<QueryItem> result2 = r2.getOrderByItems();
            if (result1.size() != result2.size()) {
                throw new IllegalStateException("OrderByItems cannot have different sizes.");
            }
            if (result1.size() != this.sortOrders.size()) {
                throw new IllegalStateException(String.format("OrderByItems cannot have a different size than sort orders.", new Object[0]));
            }
            if (this.itemTypes == null) {
                OrderbyRowComparer orderbyRowComparer = this;
                synchronized (orderbyRowComparer) {
                    if (this.itemTypes == null) {
                        this.itemTypes = new ArrayList<ItemType>(result1.size());
                        for (QueryItem item : result1) {
                            this.itemTypes.add(ItemTypeHelper.getOrderByItemType(item.getItem()));
                        }
                    }
                }
            }
            this.checkOrderByItemType(result1);
            this.checkOrderByItemType(result2);
            for (int i = 0; i < result1.size(); ++i) {
                int cmp = ItemComparator.getInstance().compare(result1.get(i).getItem(), result2.get(i).getItem());
                if (cmp == 0) continue;
                switch (this.sortOrders.get(i)) {
                    case Ascending: {
                        return cmp;
                    }
                    case Descending: {
                        return -cmp;
                    }
                }
            }
            return r1.getSourcePartitionKeyRange().getMinInclusive().compareTo(r2.getSourcePartitionKeyRange().getMinInclusive());
        }
        catch (Exception e) {
            logger.error("Orderby Row comparision failed {}, {}", new Object[]{r1.toJson(), r2.toJson(), e});
            throw e;
        }
    }

    private void checkOrderByItemType(List<QueryItem> orderByItems) {
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            ItemType type = ItemTypeHelper.getOrderByItemType(orderByItems.get(i).getItem());
            if (type == this.itemTypes.get(i)) continue;
            throw new UnsupportedOperationException(String.format("Expected %s, but got %s.", this.itemTypes.get(i).toString(), type.toString()));
        }
    }

    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }
}

