/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.logging;

import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.logging.CentralTaskLogAppender;
import org.apache.log4j.helpers.LogLog;

public class YarnCentralTaskLogAppender
extends CentralTaskLogAppender {
    private static final FsPermission DEFAULT_PERMISSIONS = new FsPermission(416);
    private static final String LOGSIZE_PROPERTY = "yarn.app.container.log.filesize";

    @Override
    protected String getFrameworkType() {
        return "yarn";
    }

    @Override
    protected FsPermission getLogFilePermission() {
        return DEFAULT_PERMISSIONS;
    }

    @Override
    protected synchronized Long getFileSizeLimit() {
        try {
            String propValue = System.getProperty(LOGSIZE_PROPERTY);
            return propValue == null ? null : Long.valueOf(Long.parseLong(propValue));
        }
        catch (NumberFormatException e) {
            LogLog.error((String)"Log size property should be a number", (Throwable)e);
            return null;
        }
    }
}

