/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestParameterParser {
    private static final String LOGICAL_NAME = "minidfs";

    @Test
    public void testDeserializeHAToken() throws IOException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        Token token = new Token();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/?namenoderpcaddress=minidfs&delegation=" + token.encodeToUrlString());
        ParameterParser testParser = new ParameterParser(decoder, conf);
        Token tok2 = testParser.delegationToken();
        Assert.assertTrue((boolean)HAUtilClient.isTokenForLogicalUri((Token)tok2));
    }

    @Test
    public void testNullToken() throws IOException {
        Configuration conf = new Configuration();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/test");
        ParameterParser testParser = new ParameterParser(decoder, conf);
        Assert.assertNull((Object)testParser.delegationToken());
    }

    @Test
    public void testDecodePath() {
        String ESCAPED_PATH = "/test%25+1%26%3Dtest?op=OPEN&foo=bar";
        String EXPECTED_PATH = "/test%+1&=test";
        Configuration conf = new Configuration();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/test%25+1%26%3Dtest?op=OPEN&foo=bar");
        ParameterParser testParser = new ParameterParser(decoder, conf);
        Assert.assertEquals((Object)"/test%+1&=test", (Object)testParser.path());
    }

    @Test
    public void testCreateFlag() {
        String path = "/test1?createflag=append,sync_block";
        Configuration conf = new Configuration();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=append,sync_block");
        ParameterParser testParser = new ParameterParser(decoder, conf);
        EnumSet actual = testParser.createFlag();
        EnumSet<CreateFlag> expected = EnumSet.of(CreateFlag.APPEND, CreateFlag.SYNC_BLOCK);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        String path1 = "/test1?createflag=append";
        decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=append");
        testParser = new ParameterParser(decoder, conf);
        actual = testParser.createFlag();
        expected = EnumSet.of(CreateFlag.APPEND);
        Assert.assertEquals(expected, (Object)actual);
        String path2 = "/test1";
        decoder = new QueryStringDecoder("/webhdfs/v1/test1");
        testParser = new ParameterParser(decoder, conf);
        actual = testParser.createFlag();
        Assert.assertEquals((long)0L, (long)actual.size());
        String path3 = "/test1?createflag=create,overwrite";
        decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=create,overwrite");
        testParser = new ParameterParser(decoder, conf);
        actual = testParser.createFlag();
        expected = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        String path4 = "/test1?createflag=";
        decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=");
        testParser = new ParameterParser(decoder, conf);
        actual = testParser.createFlag();
        Assert.assertEquals((long)0L, (long)actual.size());
        try {
            String path5 = "/test1?createflag=overwrite,";
            decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=overwrite,");
            testParser = new ParameterParser(decoder, conf);
            actual = testParser.createFlag();
            Assert.fail((String)"It should throw Illegal Argument Exception");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"No enum constant", (Throwable)e);
        }
        try {
            String path6 = "/test1?createflag=,";
            decoder = new QueryStringDecoder("/webhdfs/v1/test1?createflag=,");
            testParser = new ParameterParser(decoder, conf);
            actual = testParser.createFlag();
            Assert.fail((String)"It should throw Illegal Argument Exception");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"No enum constant", (Throwable)e);
        }
    }

    @Test
    public void testOffset() throws IOException {
        long X = 42L;
        long offset = new OffsetParam(Long.toString(42L)).getOffset();
        Assert.assertEquals((String)"OffsetParam: ", (long)42L, (long)offset);
        offset = new OffsetParam((String)null).getOffset();
        Assert.assertEquals((String)"OffsetParam with null should have defaulted to 0", (long)0L, (long)offset);
        try {
            offset = (Long)new OffsetParam("abc").getValue();
            Assert.fail((String)"OffsetParam with nondigit value should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

