/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSecretManager {
    private final String defaultAlgorithm = "HmacSHA1";
    private final int defaultLength = 64;
    private final String strongAlgorithm = "HmacSHA256";
    private final int strongLength = 256;
    private SecretManager<TokenIdentifier> secretManager;

    @Test
    public void testDefaults() {
        this.assertKey(this.secretManager.generateSecret(), "HmacSHA1", 64);
    }

    @Test
    public void testUpdate() {
        SecretManager.update((Configuration)this.createConfiguration("HmacSHA256", 256));
        this.assertKey(this.secretManager.generateSecret(), "HmacSHA256", 256);
    }

    @Test
    public void testUnknownAlgorithm() {
        SecretManager.update((Configuration)this.createConfiguration("testUnknownAlgorithm_NO_ALG", 256));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.secretManager.generateSecret());
    }

    @Test
    public void testUpdateAfterInitialisation() {
        SecretKey oldSecretKey = this.secretManager.generateSecret();
        SecretManager.update((Configuration)this.createConfiguration("HmacSHA256", 256));
        SecretKey newSecretKey = this.secretManager.generateSecret();
        this.assertKey(oldSecretKey, "HmacSHA1", 64);
        this.assertKey(newSecretKey, "HmacSHA1", 64);
    }

    @BeforeEach
    public void setUp() {
        this.secretManager = new SecretManager<TokenIdentifier>(){

            protected byte[] createPassword(TokenIdentifier identifier) {
                return new byte[0];
            }

            public byte[] retrievePassword(TokenIdentifier identifier) throws SecretManager.InvalidToken {
                return new byte[0];
            }

            public TokenIdentifier createIdentifier() {
                return null;
            }
        };
    }

    @AfterEach
    public void tearDown() {
        SecretManager.update((Configuration)this.createConfiguration("HmacSHA1", 64));
    }

    private void assertKey(SecretKey secretKey, String algorithm, int length) {
        Assertions.assertEquals((Object)algorithm, (Object)secretKey.getAlgorithm(), (String)"Algorithm of created key is not as expected.");
        Assertions.assertEquals((int)length, (int)(secretKey.getEncoded().length * 8), (String)"Length of created key is not as expected.");
    }

    private Configuration createConfiguration(String algorithm, int length) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.secret-manager.key-generator.algorithm", algorithm);
        conf.setInt("hadoop.security.secret-manager.key-length", length);
        return conf;
    }
}

