/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestBoundedByteArrayOutputStream {
    private static final int SIZE = 1024;
    private static final byte[] INPUT = new byte[1024];

    @Test
    public void testBoundedStream() throws IOException {
        BoundedByteArrayOutputStream stream = new BoundedByteArrayOutputStream(1024);
        stream.write(INPUT, 0, 1024);
        Assert.assertTrue((String)"Array Contents Mismatch", (boolean)Arrays.equals(INPUT, stream.getBuffer()));
        boolean caughtException = false;
        try {
            stream.write((int)INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((String)"Writing beyond limit did not throw an exception", (boolean)caughtException);
        stream.reset();
        Assert.assertTrue((String)"Limit did not get reset correctly", (stream.getLimit() == 1024 ? 1 : 0) != 0);
        stream.write(INPUT, 0, 1024);
        Assert.assertTrue((String)"Array Contents Mismatch", (boolean)Arrays.equals(INPUT, stream.getBuffer()));
        caughtException = false;
        try {
            stream.write((int)INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        stream.reset(1023);
        Assert.assertTrue((String)"Limit did not get reset correctly", (stream.getLimit() == 1023 ? 1 : 0) != 0);
        caughtException = false;
        try {
            stream.write(INPUT, 0, 1024);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((String)"Writing beyond limit did not throw an exception", (boolean)caughtException);
    }

    @Test
    public void testResetBuffer() throws IOException {
        ResettableBoundedByteArrayOutputStream stream = new ResettableBoundedByteArrayOutputStream(1024);
        stream.write(INPUT, 0, 1024);
        Assert.assertTrue((String)"Array Contents Mismatch", (boolean)Arrays.equals(INPUT, stream.getBuffer()));
        boolean caughtException = false;
        try {
            stream.write(INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((String)"Writing beyond limit did not throw an exception", (boolean)caughtException);
        byte[] newBuf = new byte[1024];
        stream.resetBuffer(newBuf, 0, newBuf.length);
        Assert.assertTrue((String)"Limit did not get reset correctly", (stream.getLimit() == 1024 ? 1 : 0) != 0);
        stream.write(INPUT, 0, 1024);
        Assert.assertTrue((String)"Array Contents Mismatch", (boolean)Arrays.equals(INPUT, stream.getBuffer()));
        caughtException = false;
        try {
            stream.write(INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((String)"Writing beyond limit did not throw an exception", (boolean)caughtException);
    }

    static {
        new Random().nextBytes(INPUT);
    }

    static class ResettableBoundedByteArrayOutputStream
    extends BoundedByteArrayOutputStream {
        public ResettableBoundedByteArrayOutputStream(int capacity) {
            super(capacity);
        }

        public void resetBuffer(byte[] buf, int offset, int length) {
            super.resetBuffer(buf, offset, length);
        }
    }
}

