/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.util.JsonSerialization;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMeanStatistic
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMeanStatistic.class);
    private static final int TEN = 10;
    private static final double ZEROD = 0.0;
    private static final double TEND = 10.0;
    private final MeanStatistic empty = new MeanStatistic(0L, 0L);
    private final MeanStatistic tenFromOne = new MeanStatistic(1L, 10L);
    private final MeanStatistic tenFromTen = new MeanStatistic(10L, 10L);

    @Test
    public void testEmptiness() throws Throwable {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.empty).matches(MeanStatistic::isEmpty, "is empty")).isEqualTo((Object)new MeanStatistic(0L, 10L))).isEqualTo((Object)new MeanStatistic())).isNotEqualTo((Object)this.tenFromOne);
        Assertions.assertThat((double)this.empty.mean()).isEqualTo(0.0);
        Assertions.assertThat((String)this.empty.toString()).contains(new CharSequence[]{"0.0"});
    }

    @Test
    public void testTenFromOne() throws Throwable {
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.tenFromOne).matches(p -> !p.isEmpty(), "is not empty")).isEqualTo((Object)this.tenFromOne)).isNotEqualTo((Object)this.tenFromTen);
        Assertions.assertThat((double)this.tenFromOne.mean()).isEqualTo(10.0);
    }

    @Test
    public void testNegativeSamplesAreEmpty() throws Throwable {
        MeanStatistic stat = new MeanStatistic(-10L, 1L);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)stat).describedAs("stat with negative samples", new Object[0])).matches(MeanStatistic::isEmpty, "is empty")).isEqualTo((Object)this.empty)).extracting(MeanStatistic::mean).isEqualTo((Object)0.0);
        Assertions.assertThat((String)stat.toString()).contains(new CharSequence[]{"0.0"});
    }

    @Test
    public void testCopyNonEmpty() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)stat).describedAs("copy of " + this.tenFromOne, new Object[0])).isEqualTo((Object)this.tenFromOne)).isNotSameAs((Object)this.tenFromOne);
    }

    @Test
    public void testCopyEmpty() throws Throwable {
        MeanStatistic stat = this.empty.copy();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)stat).describedAs("copy of " + this.empty, new Object[0])).isEqualTo((Object)this.empty)).isNotSameAs((Object)this.empty);
    }

    @Test
    public void testDoubleSamples() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        ((ObjectAssert)Assertions.assertThat((Object)stat.add(this.tenFromOne)).isEqualTo((Object)new MeanStatistic(2L, 20L))).extracting(MeanStatistic::mean).isEqualTo((Object)10.0);
    }

    @Test
    public void testAddEmptyR() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        Assertions.assertThat((Object)stat.add(this.empty)).isEqualTo((Object)this.tenFromOne);
    }

    @Test
    public void testAddEmptyL() throws Throwable {
        MeanStatistic stat = this.empty.copy();
        Assertions.assertThat((Object)stat.add(this.tenFromOne)).isEqualTo((Object)this.tenFromOne);
    }

    @Test
    public void testAddEmptyLR() throws Throwable {
        MeanStatistic stat = this.empty.copy();
        Assertions.assertThat((Object)stat.add(this.empty)).isEqualTo((Object)this.empty);
    }

    @Test
    public void testAddSampleToEmpty() throws Throwable {
        MeanStatistic stat = this.empty.copy();
        stat.addSample(10L);
        Assertions.assertThat((Object)stat).isEqualTo((Object)this.tenFromOne);
    }

    @Test
    public void testAddZeroValueSamples() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        for (int i = 0; i < 9; ++i) {
            stat.addSample(0L);
        }
        Assertions.assertThat((Object)stat).isEqualTo((Object)this.tenFromTen);
    }

    @Test
    public void testSetSamples() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        stat.setSamples(10L);
        Assertions.assertThat((Object)stat).isEqualTo((Object)this.tenFromTen);
    }

    @Test
    public void testSetSums() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        stat.setSum(100L);
        stat.setSamples(20L);
        ((ObjectAssert)Assertions.assertThat((Object)stat).isEqualTo((Object)new MeanStatistic(20L, 100L))).extracting(MeanStatistic::mean).isEqualTo((Object)5.0);
    }

    @Test
    public void testSetNegativeSamplesMakesEmpty() throws Throwable {
        MeanStatistic stat = this.tenFromOne.copy();
        stat.setSamples(-3L);
        Assertions.assertThat((Object)stat).isEqualTo((Object)this.empty);
    }

    @Test
    public void testJsonRoundTrip() throws Throwable {
        JsonSerialization<MeanStatistic> serializer = TestMeanStatistic.serializer();
        String json = serializer.toJson((Object)this.tenFromTen);
        LOG.info("serialized form\n{}", (Object)json);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)json).describedAs("JSON form of %s", new Object[]{this.tenFromTen})).doesNotContain(new CharSequence[]{"empty"})).doesNotContain(new CharSequence[]{"mean"});
        MeanStatistic deser = (MeanStatistic)serializer.fromJson(json);
        LOG.info("deserialized {}", (Object)deser);
        Assertions.assertThat((Object)deser).isEqualTo((Object)this.tenFromTen);
    }

    @Test
    public void testHandleMaliciousStat() throws Throwable {
        String json = "{\n  \"sum\" : 10,\n  \"samples\" : -10\n}";
        JsonSerialization<MeanStatistic> serializer = TestMeanStatistic.serializer();
        MeanStatistic deser = (MeanStatistic)serializer.fromJson(json);
        LOG.info("deserialized {}", (Object)deser);
        Assertions.assertThat((Object)deser).isEqualTo((Object)this.empty);
    }

    public static JsonSerialization<MeanStatistic> serializer() {
        return new JsonSerialization(MeanStatistic.class, true, true);
    }
}

