/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.ShuffleChannelHandlerContext;
import org.apache.hadoop.mapred.ShuffleChannelInitializer;
import org.apache.hadoop.mapred.proto.ShuffleHandlerRecoveryProtos;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleHandler
extends AuxiliaryService {
    public static final Logger LOG = LoggerFactory.getLogger(ShuffleHandler.class);
    public static final Logger AUDITLOG = LoggerFactory.getLogger((String)(ShuffleHandler.class.getName() + ".audit"));
    public static final String SHUFFLE_MANAGE_OS_CACHE = "mapreduce.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_READAHEAD_BYTES = "mapreduce.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    public static final String MAX_WEIGHT = "mapreduce.shuffle.pathcache.max-weight";
    public static final int DEFAULT_MAX_WEIGHT = 0xA00000;
    public static final String EXPIRE_AFTER_ACCESS_MINUTES = "mapreduce.shuffle.pathcache.expire-after-access-minutes";
    public static final int DEFAULT_EXPIRE_AFTER_ACCESS_MINUTES = 5;
    public static final String CONCURRENCY_LEVEL = "mapreduce.shuffle.pathcache.concurrency-level";
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    public static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private static final String STATE_DB_NAME = "mapreduce_shuffle_state";
    private static final String STATE_DB_SCHEMA_VERSION_KEY = "shuffle-schema-version";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    private static final String DATA_FILE_NAME = "file.out";
    private static final String INDEX_FILE_NAME = "file.out.index";
    public static final HttpResponseStatus TOO_MANY_REQ_STATUS = new HttpResponseStatus(429, "TOO MANY REQUESTS");
    public static final long FETCH_RETRY_DELAY = 1000L;
    public static final String RETRY_AFTER_HEADER = "Retry-After";
    private int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    protected final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private SSLFactory sslFactory;
    protected JobTokenSecretManager secretManager;
    protected Map<String, String> userRsrc;
    private DB stateDb = null;
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce_shuffle";
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 13562;
    public static final String SHUFFLE_LISTEN_QUEUE_SIZE = "mapreduce.shuffle.listen.queue.size";
    public static final int DEFAULT_SHUFFLE_LISTEN_QUEUE_SIZE = 128;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "mapreduce.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = false;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "mapreduce.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "mapreduce.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 1000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "mapreduce.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    public static final String SHUFFLE_BUFFER_SIZE = "mapreduce.shuffle.transfer.buffer.size";
    public static final int DEFAULT_SHUFFLE_BUFFER_SIZE = 131072;
    public static final String SHUFFLE_TRANSFERTO_ALLOWED = "mapreduce.shuffle.transferTo.allowed";
    public static final boolean DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = true;
    public static final boolean WINDOWS_DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = false;
    static final String TIMEOUT_HANDLER = "timeout";
    public static final String SHUFFLE_MAX_SESSION_OPEN_FILES = "mapreduce.shuffle.max.session-open-files";
    public static final int DEFAULT_SHUFFLE_MAX_SESSION_OPEN_FILES = 3;
    protected final MetricsSystem ms;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super(MAPREDUCE_SHUFFLE_SERVICEID);
        this.ms = ms;
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer portDob = new DataOutputBuffer();
        portDob.writeInt(port);
        return ByteBuffer.wrap(portDob.getData(), 0, portDob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobTokenDob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobTokenDob);
        return ByteBuffer.wrap(jobTokenDob.getData(), 0, jobTokenDob.getLength());
    }

    public static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String user = context.getUser();
        ApplicationId appId = context.getApplicationId();
        ByteBuffer secret = context.getApplicationDataForService();
        try {
            Token<JobTokenIdentifier> jt = ShuffleHandler.deserializeServiceData(secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            this.recordJobShuffleInfo(jobId, user, jt);
        }
        catch (IOException e) {
            LOG.error("Error during initApp", (Throwable)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        ApplicationId appId = context.getApplicationId();
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        try {
            this.removeJobShuffleInfo(jobId);
        }
        catch (IOException e) {
            LOG.error("Error during stopApp", (Throwable)e);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.bossGroup = new NioEventLoopGroup(1, bossFactory);
        this.workerGroup = new NioEventLoopGroup(maxShuffleThreads, workerFactory);
        super.serviceInit(new Configuration(conf));
    }

    protected ShuffleChannelHandlerContext createHandlerContext() {
        Configuration conf = this.getConfig();
        LoadingCache pathCache = CacheBuilder.newBuilder().expireAfterAccess((long)conf.getInt(EXPIRE_AFTER_ACCESS_MINUTES, 5), TimeUnit.MINUTES).softValues().concurrencyLevel(conf.getInt(CONCURRENCY_LEVEL, 16)).removalListener(notification -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PathCache Eviction: " + notification.getKey() + ", Reason=" + notification.getCause());
            }
        }).maximumWeight((long)conf.getInt(MAX_WEIGHT, 0xA00000)).weigher((key, value) -> key.jobId.length() + key.user.length() + key.attemptId.length() + value.indexPath.toString().length() + value.dataPath.toString().length()).build((CacheLoader)new CacheLoader<AttemptPathIdentifier, AttemptPathInfo>(){

            public AttemptPathInfo load(@Nonnull AttemptPathIdentifier key) throws Exception {
                String base = ShuffleHandler.getBaseLocation(key.jobId, key.user);
                String attemptBase = base + key.attemptId;
                Path indexFileName = ShuffleHandler.this.getAuxiliaryLocalPathHandler().getLocalPathForRead(attemptBase + "/" + ShuffleHandler.INDEX_FILE_NAME);
                Path mapOutputFileName = ShuffleHandler.this.getAuxiliaryLocalPathHandler().getLocalPathForRead(attemptBase + "/" + ShuffleHandler.DATA_FILE_NAME);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loaded : " + key + " via loader");
                }
                return new AttemptPathInfo(indexFileName, mapOutputFileName);
            }
        });
        return new ShuffleChannelHandlerContext(conf, this.userRsrc, this.secretManager, (LoadingCache<AttemptPathIdentifier, AttemptPathInfo>)pathCache, new IndexCache(new JobConf(conf)), this.metrics, this.allChannels);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        this.userRsrc = new ConcurrentHashMap<String, String>();
        this.secretManager = new JobTokenSecretManager();
        this.recoverState(conf);
        if (conf.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
            LOG.info("Encrypted shuffle is enabled.");
            this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
            this.sslFactory.init();
        }
        ShuffleChannelHandlerContext handlerContext = this.createHandlerContext();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)conf.getInt(SHUFFLE_LISTEN_QUEUE_SIZE, 128))).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ShuffleChannelInitializer(handlerContext, this.sslFactory));
        this.port = conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 13562);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port)).sync().channel();
        this.port = ((InetSocketAddress)ch.localAddress()).getPort();
        this.allChannels.add((Object)ch);
        conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        handlerContext.setPort(this.port);
        LOG.info(this.getName() + " listening on port " + this.port);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.allChannels.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        if (this.stateDb != null) {
            this.stateDb.close();
        }
        this.ms.unregisterSource(ShuffleMetrics.class.getSimpleName());
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        super.serviceStop();
    }

    public synchronized ByteBuffer getMetaData() {
        try {
            return ShuffleHandler.serializeMetaData(this.port);
        }
        catch (IOException e) {
            LOG.error("Error during getMeta", (Throwable)e);
            return null;
        }
    }

    private void recoverState(Configuration conf) throws IOException {
        Path recoveryRoot = this.getRecoveryPath();
        if (recoveryRoot != null) {
            this.startStore(recoveryRoot);
            Pattern jobPattern = Pattern.compile("job_[0-9]+_[0-9]+");
            try (LeveldbIterator iter = null;){
                iter = new LeveldbIterator(this.stateDb);
                iter.seek(JniDBFactory.bytes((String)"job"));
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                    if (!jobPattern.matcher(key).matches()) {
                        break;
                    }
                    this.recoverJobShuffleInfo(key, (byte[])entry.getValue());
                }
            }
        }
    }

    private void startStore(Path recoveryRoot) throws IOException {
        Options options = new Options();
        options.createIfMissing(false);
        Path dbPath = new Path(recoveryRoot, STATE_DB_NAME);
        LOG.info("Using state database at " + dbPath + " for recovery");
        File dbfile = new File(dbPath.toString());
        try {
            this.stateDb = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            LOG.warn("Can't open existing recovery database. Trying to delete the old one and create a new one");
            File rootRecoveryDir = new File(dbPath.toString());
            FileUtils.deleteDirectory((File)rootRecoveryDir);
            LOG.info("Creating state database at {}", (Object)dbfile);
            options.createIfMissing(true);
            try {
                this.stateDb = JniDBFactory.factory.open(dbfile, options);
                this.storeVersion();
            }
            catch (DBException dbExc) {
                throw new IOException("Unable to create state store", dbExc);
            }
        }
        this.checkVersion();
    }

    @VisibleForTesting
    Version loadVersion() throws IOException {
        byte[] data = this.stateDb.get(JniDBFactory.bytes((String)STATE_DB_SCHEMA_VERSION_KEY));
        if (data == null || data.length == 0) {
            return this.getCurrentVersion();
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        return version;
    }

    private void storeSchemaVersion(Version version) throws IOException {
        String key = STATE_DB_SCHEMA_VERSION_KEY;
        byte[] data = ((VersionPBImpl)version).getProto().toByteArray();
        try {
            this.stateDb.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void storeVersion() throws IOException {
        this.storeSchemaVersion(CURRENT_VERSION_INFO);
    }

    @VisibleForTesting
    void storeVersion(Version version) throws IOException {
        this.storeSchemaVersion(version);
    }

    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded state DB schema version info " + loadedVersion);
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new IOException("Incompatible version for state DB schema: expecting DB schema version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing state DB schema version info " + this.getCurrentVersion());
        this.storeVersion();
    }

    private void addJobToken(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) {
        this.userRsrc.put(jobId.toString(), user);
        this.secretManager.addTokenForJob(jobId.toString(), jobToken);
        LOG.info("Added token for " + jobId.toString());
    }

    private void recoverJobShuffleInfo(String jobIdStr, byte[] data) throws IOException {
        JobID jobId;
        try {
            jobId = JobID.forName((String)jobIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Bad job ID " + jobIdStr + " in state store", e);
        }
        ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.parseFrom(data);
        String user = proto.getUser();
        SecurityProtos.TokenProto tokenProto = proto.getJobToken();
        Token jobToken = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        this.addJobToken(jobId, user, (Token<JobTokenIdentifier>)jobToken);
    }

    private void recordJobShuffleInfo(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) throws IOException {
        if (this.stateDb != null) {
            SecurityProtos.TokenProto tokenProto = SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])jobToken.getIdentifier())).setPassword(ByteString.copyFrom((byte[])jobToken.getPassword())).setKind(jobToken.getKind().toString()).setService(jobToken.getService().toString()).build();
            ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.newBuilder().setUser(user).setJobToken(tokenProto).build();
            try {
                this.stateDb.put(JniDBFactory.bytes((String)jobId.toString()), proto.toByteArray());
            }
            catch (DBException e) {
                throw new IOException("Error storing " + jobId, e);
            }
        }
        this.addJobToken(jobId, user, jobToken);
    }

    private void removeJobShuffleInfo(JobID jobId) throws IOException {
        String jobIdStr = jobId.toString();
        this.secretManager.removeTokenForJob(jobIdStr);
        this.userRsrc.remove(jobIdStr);
        if (this.stateDb != null) {
            try {
                this.stateDb.delete(JniDBFactory.bytes((String)jobIdStr));
            }
            catch (DBException e) {
                throw new IOException("Unable to remove " + jobId + " from state store", e);
            }
        }
    }

    private static String getBaseLocation(String jobId, String user) {
        JobID jobID = JobID.forName((String)jobId);
        ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(jobID.getJtIdentifier()), (int)jobID.getId());
        return "usercache/" + user + "/" + "appcache" + "/" + appID + "/output/";
    }

    static class AttemptPathIdentifier {
        public final String jobId;
        public final String user;
        public final String attemptId;

        AttemptPathIdentifier(String jobId, String user, String attemptId) {
            this.jobId = jobId;
            this.user = user;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttemptPathIdentifier that = (AttemptPathIdentifier)o;
            if (!this.attemptId.equals(that.attemptId)) {
                return false;
            }
            return this.jobId.equals(that.jobId);
        }

        public int hashCode() {
            int result = this.jobId.hashCode();
            result = 31 * result + this.attemptId.hashCode();
            return result;
        }

        public String toString() {
            return "AttemptPathIdentifier{attemptId='" + this.attemptId + '\'' + ", jobId='" + this.jobId + '\'' + '}';
        }
    }

    static class AttemptPathInfo {
        public final Path indexPath;
        public final Path dataPath;

        AttemptPathInfo(Path indexPath, Path dataPath) {
            this.indexPath = indexPath;
            this.dataPath = dataPath;
        }
    }

    static class TimeoutHandler
    extends IdleStateHandler {
        private final int connectionKeepAliveTimeOut;
        private boolean enabledTimeout;

        TimeoutHandler(int connectionKeepAliveTimeOut) {
            super(0L, (long)connectionKeepAliveTimeOut, 0L, TimeUnit.SECONDS);
            this.connectionKeepAliveTimeOut = connectionKeepAliveTimeOut;
        }

        void setEnabledTimeout(boolean enabledTimeout) {
            this.enabledTimeout = enabledTimeout;
        }

        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            if (e.state() == IdleState.WRITER_IDLE && this.enabledTimeout) {
                LOG.debug("Closing channel as writer was idle for {} seconds", (Object)this.connectionKeepAliveTimeOut);
                ctx.channel().close();
            }
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

