/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.HomeAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.AbstractPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.WeightedRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;

public class WeightedHomePolicyManager
extends AbstractPolicyManager {
    private WeightedPolicyInfo weightedPolicyInfo;

    public WeightedHomePolicyManager() {
        this.routerFederationPolicy = WeightedRandomRouterPolicy.class;
        this.amrmProxyFederationPolicy = HomeAMRMProxyPolicy.class;
        this.weightedPolicyInfo = new WeightedPolicyInfo();
    }

    @Override
    public SubClusterPolicyConfiguration serializeConf() throws FederationPolicyInitializationException {
        ByteBuffer buf = this.weightedPolicyInfo.toByteBuffer();
        return SubClusterPolicyConfiguration.newInstance(this.getQueue(), this.getClass().getCanonicalName(), buf);
    }

    @Override
    @VisibleForTesting
    public WeightedPolicyInfo getWeightedPolicyInfo() {
        return this.weightedPolicyInfo;
    }

    @Override
    @VisibleForTesting
    public void setWeightedPolicyInfo(WeightedPolicyInfo weightedPolicyInfo) {
        this.weightedPolicyInfo = weightedPolicyInfo;
    }

    @Override
    public boolean isSupportWeightedPolicyInfo() {
        return true;
    }
}

