/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class AttributedStringBuilder
extends AttributedCharSequence
implements Appendable {
    private char[] buffer;
    private int[] style;
    private int length;
    private int tabs = 0;
    private int lastLineLength = 0;
    private AttributedStyle current = AttributedStyle.DEFAULT;

    public static AttributedString append(CharSequence ... strings) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        for (CharSequence s : strings) {
            sb.append(s);
        }
        return sb.toAttributedString();
    }

    public AttributedStringBuilder() {
        this(64);
    }

    public AttributedStringBuilder(int capacity) {
        this.buffer = new char[capacity];
        this.style = new int[capacity];
        this.length = 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public AttributedStyle styleAt(int index) {
        return new AttributedStyle(this.style[index], this.style[index]);
    }

    @Override
    int styleCodeAt(int index) {
        return this.style[index];
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return 0;
    }

    @Override
    public AttributedString subSequence(int start, int end) {
        return new AttributedString(Arrays.copyOfRange(this.buffer, start, end), Arrays.copyOfRange(this.style, start, end), 0, end - start);
    }

    @Override
    public AttributedStringBuilder append(CharSequence csq) {
        return this.append(new AttributedString(csq, this.current));
    }

    @Override
    public AttributedStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public AttributedStringBuilder append(char c) {
        return this.append(Character.toString(c));
    }

    public AttributedStringBuilder append(CharSequence csq, AttributedStyle style) {
        return this.append(new AttributedString(csq, style));
    }

    public AttributedStringBuilder style(AttributedStyle style) {
        this.current = style;
        return this;
    }

    public AttributedStringBuilder style(Function<AttributedStyle, AttributedStyle> style) {
        this.current = style.apply(this.current);
        return this;
    }

    public AttributedStringBuilder styled(Function<AttributedStyle, AttributedStyle> style, CharSequence cs) {
        return this.styled(style, (AttributedStringBuilder sb) -> sb.append(cs));
    }

    public AttributedStringBuilder styled(AttributedStyle style, CharSequence cs) {
        return this.styled((AttributedStyle s) -> style, (AttributedStringBuilder sb) -> sb.append(cs));
    }

    public AttributedStringBuilder styled(Function<AttributedStyle, AttributedStyle> style, Consumer<AttributedStringBuilder> consumer) {
        AttributedStyle prev = this.current;
        this.current = style.apply(prev);
        consumer.accept(this);
        this.current = prev;
        return this;
    }

    public AttributedStyle style() {
        return this.current;
    }

    public AttributedStringBuilder append(AttributedString str) {
        return this.append((AttributedCharSequence)str, 0, str.length());
    }

    public AttributedStringBuilder append(AttributedString str, int start, int end) {
        return this.append((AttributedCharSequence)str, start, end);
    }

    public AttributedStringBuilder append(AttributedCharSequence str) {
        return this.append(str, 0, str.length());
    }

    public AttributedStringBuilder append(AttributedCharSequence str, int start, int end) {
        this.ensureCapacity(this.length + end - start);
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            int s = str.styleCodeAt(i) & ~this.current.getMask() | this.current.getStyle();
            if (this.tabs > 0 && c == '\t') {
                this.insertTab(new AttributedStyle(s, 0));
                continue;
            }
            this.ensureCapacity(this.length + 1);
            this.buffer[this.length] = c;
            this.style[this.length] = s;
            this.lastLineLength = c == '\n' ? 0 : ++this.lastLineLength;
            ++this.length;
        }
        return this;
    }

    protected void ensureCapacity(int nl) {
        if (nl > this.buffer.length) {
            int s;
            for (s = Math.max(this.buffer.length, 1); s <= nl; s *= 2) {
            }
            this.buffer = Arrays.copyOf(this.buffer, s);
            this.style = Arrays.copyOf(this.style, s);
        }
    }

    public void appendAnsi(String ansi) {
        this.ansiAppend(ansi);
    }

    public AttributedStringBuilder ansiAppend(String ansi) {
        int ansiStart = 0;
        int ansiState = 0;
        this.ensureCapacity(this.length + ansi.length());
        for (int i = 0; i < ansi.length(); ++i) {
            char c = ansi.charAt(i);
            if (ansiState == 0 && c == '\u001b') {
                ++ansiState;
                continue;
            }
            if (ansiState == 1 && c == '[') {
                ++ansiState;
                ansiStart = i + 1;
                continue;
            }
            if (ansiState == 2) {
                if (c == 'm') {
                    String[] params = ansi.substring(ansiStart, i).split(";");
                    block26: for (int j = 0; j < params.length; ++j) {
                        int ansiParam = params[j].isEmpty() ? 0 : Integer.parseInt(params[j]);
                        switch (ansiParam) {
                            case 0: {
                                this.current = AttributedStyle.DEFAULT;
                                continue block26;
                            }
                            case 1: {
                                this.current = this.current.bold();
                                continue block26;
                            }
                            case 2: {
                                this.current = this.current.faint();
                                continue block26;
                            }
                            case 3: {
                                this.current = this.current.italic();
                                continue block26;
                            }
                            case 4: {
                                this.current = this.current.underline();
                                continue block26;
                            }
                            case 5: {
                                this.current = this.current.blink();
                                continue block26;
                            }
                            case 7: {
                                this.current = this.current.inverse();
                                continue block26;
                            }
                            case 8: {
                                this.current = this.current.conceal();
                                continue block26;
                            }
                            case 9: {
                                this.current = this.current.crossedOut();
                                continue block26;
                            }
                            case 22: {
                                this.current = this.current.boldOff().faintOff();
                                continue block26;
                            }
                            case 23: {
                                this.current = this.current.italicOff();
                                continue block26;
                            }
                            case 24: {
                                this.current = this.current.underlineOff();
                                continue block26;
                            }
                            case 25: {
                                this.current = this.current.blinkOff();
                                continue block26;
                            }
                            case 27: {
                                this.current = this.current.inverseOff();
                                continue block26;
                            }
                            case 28: {
                                this.current = this.current.concealOff();
                                continue block26;
                            }
                            case 29: {
                                this.current = this.current.crossedOutOff();
                                continue block26;
                            }
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: {
                                this.current = this.current.foreground(ansiParam - 30);
                                continue block26;
                            }
                            case 39: {
                                this.current = this.current.foregroundOff();
                                continue block26;
                            }
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: {
                                this.current = this.current.background(ansiParam - 40);
                                continue block26;
                            }
                            case 49: {
                                this.current = this.current.backgroundOff();
                                continue block26;
                            }
                            case 38: 
                            case 48: {
                                int ansiParam2;
                                if (j + 1 >= params.length) continue block26;
                                if ((ansiParam2 = Integer.parseInt(params[++j])) == 2) {
                                    if (j + 3 >= params.length) continue block26;
                                    int r = Integer.parseInt(params[++j]);
                                    int g = Integer.parseInt(params[++j]);
                                    int b = Integer.parseInt(params[++j]);
                                    int col = 16 + (r >> 3) * 36 + (g >> 3) * 6 + (b >> 3);
                                    if (ansiParam == 38) {
                                        this.current = this.current.foreground(col);
                                        continue block26;
                                    }
                                    this.current = this.current.background(col);
                                    continue block26;
                                }
                                if (ansiParam2 != 5 || j + 1 >= params.length) continue block26;
                                int col = Integer.parseInt(params[++j]);
                                if (ansiParam == 38) {
                                    this.current = this.current.foreground(col);
                                    continue block26;
                                }
                                this.current = this.current.background(col);
                                continue block26;
                            }
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: {
                                this.current = this.current.foreground(ansiParam - 90 + 8);
                                continue block26;
                            }
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: {
                                this.current = this.current.background(ansiParam - 100 + 8);
                            }
                        }
                    }
                    ansiState = 0;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == ';') continue;
                ansiState = 0;
                continue;
            }
            if (c == '\t' && this.tabs > 0) {
                this.insertTab(this.current);
                continue;
            }
            this.ensureCapacity(this.length + 1);
            this.buffer[this.length] = c;
            this.style[this.length] = this.current.getStyle();
            this.lastLineLength = c == '\n' ? 0 : ++this.lastLineLength;
            ++this.length;
        }
        return this;
    }

    protected void insertTab(AttributedStyle s) {
        int nb = this.tabs - this.lastLineLength % this.tabs;
        this.ensureCapacity(this.length + nb);
        for (int i = 0; i < nb; ++i) {
            this.buffer[this.length] = 32;
            this.style[this.length] = s.getStyle();
            ++this.length;
        }
        this.lastLineLength += nb;
    }

    public void setLength(int l) {
        this.length = l;
    }

    public AttributedStringBuilder tabs(int tabsize) {
        if (this.length > 0) {
            throw new IllegalStateException("Cannot change tab size after appending text");
        }
        if (tabsize < 0) {
            throw new IllegalArgumentException("Tab size must be non negative");
        }
        this.tabs = tabsize;
        return this;
    }

    public AttributedStringBuilder styleMatches(Pattern pattern, AttributedStyle s) {
        Matcher matcher = pattern.matcher(this);
        while (matcher.find()) {
            for (int i = matcher.start(); i < matcher.end(); ++i) {
                this.style[i] = this.style[i] & ~s.getMask() | s.getStyle();
            }
        }
        return this;
    }
}

