/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DynoInfraUtils {
    public static final String DYNO_CONF_PREFIX = "dyno.";
    public static final String DYNO_INFRA_PREFIX = "dyno.infra.";
    public static final String APACHE_DOWNLOAD_MIRROR_KEY = "dyno.apache-mirror";
    public static final String APACHE_DOWNLOAD_MIRROR_DEFAULT = "http://mirrors.ocf.berkeley.edu/apache/";
    private static final String APACHE_DOWNLOAD_MIRROR_SUFFIX_FORMAT = "hadoop/common/hadoop-%s/hadoop-%s.tar.gz";
    public static final String HADOOP_TAR_FILENAME_FORMAT = "hadoop-%s.tar.gz";
    public static final String DATANODE_LIVE_MIN_FRACTION_KEY = "dyno.infra.ready.datanode-min-fraction";
    public static final float DATANODE_LIVE_MIN_FRACTION_DEFAULT = 0.99f;
    public static final String MISSING_BLOCKS_MAX_FRACTION_KEY = "dyno.infra.ready.missing-blocks-max-fraction";
    public static final float MISSING_BLOCKS_MAX_FRACTION_DEFAULT = 1.0E-4f;
    public static final String UNDERREPLICATED_BLOCKS_MAX_FRACTION_KEY = "dyno.infra.ready.underreplicated-blocks-max-fraction";
    public static final float UNDERREPLICATED_BLOCKS_MAX_FRACTION_DEFAULT = 0.01f;
    public static final String NAMENODE_STARTUP_PROGRESS_JMX_QUERY = "Hadoop:service=NameNode,name=StartupProgress";
    public static final String FSNAMESYSTEM_JMX_QUERY = "Hadoop:service=NameNode,name=FSNamesystem";
    public static final String FSNAMESYSTEM_STATE_JMX_QUERY = "Hadoop:service=NameNode,name=FSNamesystemState";
    public static final String NAMENODE_INFO_JMX_QUERY = "Hadoop:service=NameNode,name=NameNodeInfo";
    public static final String JMX_MISSING_BLOCKS = "MissingBlocks";
    public static final String JMX_UNDER_REPLICATED_BLOCKS = "UnderReplicatedBlocks";
    public static final String JMX_BLOCKS_TOTAL = "BlocksTotal";
    public static final String JMX_LIVE_NODE_COUNT = "NumLiveDataNodes";
    public static final String JMX_LIVE_NODES_LIST = "LiveNodes";

    private DynoInfraUtils() {
    }

    public static File fetchHadoopTarball(File destinationDir, String version, Configuration conf, Logger log) throws IOException {
        log.info("Looking for Hadoop tarball for version: " + version);
        File destinationFile = new File(destinationDir, String.format(HADOOP_TAR_FILENAME_FORMAT, version));
        if (destinationFile.exists()) {
            log.info("Found tarball at: " + destinationFile.getAbsolutePath());
            return destinationFile;
        }
        String apacheMirror = conf.get(APACHE_DOWNLOAD_MIRROR_KEY);
        if (apacheMirror == null) {
            apacheMirror = System.getProperty(APACHE_DOWNLOAD_MIRROR_KEY, APACHE_DOWNLOAD_MIRROR_DEFAULT);
        }
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new IOException("Unable to create local dir: " + destinationDir);
        }
        URL downloadURL = new URL(apacheMirror + String.format(APACHE_DOWNLOAD_MIRROR_SUFFIX_FORMAT, version, version));
        log.info("Downloading tarball from: <{}> to <{}>", (Object)downloadURL, (Object)destinationFile.getAbsolutePath());
        FileUtils.copyURLToFile((URL)downloadURL, (File)destinationFile, (int)10000, (int)60000);
        log.info("Completed downloading of Hadoop tarball");
        return destinationFile;
    }

    static URI getNameNodeHdfsUri(Properties nameNodeProperties) {
        return URI.create(String.format("hdfs://%s:%s/", nameNodeProperties.getProperty("NN_HOSTNAME"), nameNodeProperties.getProperty("NN_RPC_PORT")));
    }

    static URI getNameNodeServiceRpcAddr(Properties nameNodeProperties) {
        return URI.create(String.format("hdfs://%s:%s/", nameNodeProperties.getProperty("NN_HOSTNAME"), nameNodeProperties.getProperty("NN_SERVICERPC_PORT")));
    }

    static URI getNameNodeWebUri(Properties nameNodeProperties) {
        return URI.create(String.format("http://%s:%s/", nameNodeProperties.getProperty("NN_HOSTNAME"), nameNodeProperties.getProperty("NN_HTTP_PORT")));
    }

    static URI getNameNodeTrackingUri(Properties nameNodeProperties) throws IOException {
        return URI.create(String.format("http://%s:%s/node/containerlogs/%s/%s/", nameNodeProperties.getProperty("NN_HOSTNAME"), nameNodeProperties.getProperty(ApplicationConstants.Environment.NM_HTTP_PORT.name()), nameNodeProperties.getProperty(ApplicationConstants.Environment.CONTAINER_ID.name()), UserGroupInformation.getCurrentUser().getShortUserName()));
    }

    static Optional<Properties> waitForAndGetNameNodeProperties(Supplier<Boolean> shouldExit, Configuration conf, Path nameNodeInfoPath, Logger log) throws IOException, InterruptedException {
        while (!shouldExit.get().booleanValue()) {
            Optional<Properties> optional;
            block10: {
                FSDataInputStream nnInfoInputStream = nameNodeInfoPath.getFileSystem(conf).open(nameNodeInfoPath);
                try {
                    Properties nameNodeProperties = new Properties();
                    nameNodeProperties.load((InputStream)nnInfoInputStream);
                    optional = Optional.of(nameNodeProperties);
                    if (nnInfoInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (nnInfoInputStream != null) {
                            try {
                                nnInfoInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fnfe) {
                        log.debug("NameNode host information not yet available");
                        Thread.sleep(1000L);
                    }
                    catch (IOException ioe) {
                        log.warn("Unable to fetch NameNode host information; retrying", (Throwable)ioe);
                        Thread.sleep(1000L);
                    }
                }
                nnInfoInputStream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    static void waitForNameNodeStartup(Properties nameNodeProperties, Supplier<Boolean> shouldExit, Logger log) throws IOException, InterruptedException {
        if (shouldExit.get().booleanValue()) {
            return;
        }
        log.info("Waiting for NameNode to finish starting up...");
        DynoInfraUtils.waitForNameNodeJMXValue("Startup progress", NAMENODE_STARTUP_PROGRESS_JMX_QUERY, "PercentComplete", 1.0, 0.01, false, nameNodeProperties, shouldExit, log);
        log.info("NameNode has started!");
    }

    static void waitForNameNodeReadiness(Properties nameNodeProperties, int numTotalDataNodes, boolean triggerBlockReports, Supplier<Boolean> shouldExit, Configuration conf, Logger log) throws IOException, InterruptedException {
        if (shouldExit.get().booleanValue()) {
            return;
        }
        int minDataNodes = (int)(conf.getFloat(DATANODE_LIVE_MIN_FRACTION_KEY, 0.99f) * (float)numTotalDataNodes);
        log.info(String.format("Waiting for %d DataNodes to register with the NameNode...", minDataNodes));
        DynoInfraUtils.waitForNameNodeJMXValue("Number of live DataNodes", FSNAMESYSTEM_STATE_JMX_QUERY, JMX_LIVE_NODE_COUNT, minDataNodes, (double)numTotalDataNodes * 0.001, false, nameNodeProperties, shouldExit, log);
        int totalBlocks = Integer.parseInt(DynoInfraUtils.fetchNameNodeJMXValue(nameNodeProperties, FSNAMESYSTEM_STATE_JMX_QUERY, JMX_BLOCKS_TOTAL));
        AtomicBoolean doneWaiting = new AtomicBoolean(false);
        if (triggerBlockReports) {
            int blockThreshold = totalBlocks / numTotalDataNodes * 2;
            conf.set("hadoop.security.authentication", "simple");
            conf.set("hadoop.security.authorization", "false");
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((URI)DynoInfraUtils.getNameNodeHdfsUri(nameNodeProperties), (Configuration)conf);
            log.info("Launching thread to trigger block reports for Datanodes with <" + blockThreshold + " blocks reported");
            Thread blockReportThread = new Thread(() -> {
                block8: {
                    long lastUnderRepBlocks = Long.MAX_VALUE;
                    try {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                                    long underRepBlocks = Long.parseLong(DynoInfraUtils.fetchNameNodeJMXValue(nameNodeProperties, FSNAMESYSTEM_JMX_QUERY, JMX_MISSING_BLOCKS)) + Long.parseLong(DynoInfraUtils.fetchNameNodeJMXValue(nameNodeProperties, FSNAMESYSTEM_STATE_JMX_QUERY, JMX_UNDER_REPLICATED_BLOCKS));
                                    long blockDecrease = lastUnderRepBlocks - underRepBlocks;
                                    lastUnderRepBlocks = underRepBlocks;
                                    if (blockDecrease < 0L || (double)blockDecrease > (double)totalBlocks * 0.001) continue;
                                    String liveNodeListString = DynoInfraUtils.fetchNameNodeJMXValue(nameNodeProperties, NAMENODE_INFO_JMX_QUERY, JMX_LIVE_NODES_LIST);
                                    Set<String> datanodesToReport = DynoInfraUtils.parseStaleDataNodeList(liveNodeListString, blockThreshold, log);
                                    if (datanodesToReport.isEmpty() && doneWaiting.get()) {
                                        log.info("BlockReportThread exiting; all DataNodes have reported blocks");
                                        break block8;
                                    }
                                    log.info("Queueing {} Datanodes for block report: {}", (Object)datanodesToReport.size(), (Object)Joiner.on((String)",").join(datanodesToReport));
                                    DatanodeInfo[] datanodes = dfs.getDataNodeStats();
                                    int cnt = 0;
                                    for (DatanodeInfo datanode : datanodes) {
                                        if (!datanodesToReport.contains(datanode.getXferAddr(true))) continue;
                                        Thread.sleep(1L);
                                        DynoInfraUtils.triggerDataNodeBlockReport(conf, datanode.getIpcAddr(true));
                                        ++cnt;
                                        Thread.sleep(1000L);
                                    }
                                    if (cnt == datanodesToReport.size()) continue;
                                    log.warn("Found {} Datanodes to queue block reports for but was only able to trigger {}", (Object)datanodesToReport.size(), (Object)cnt);
                                }
                            }
                            catch (IOException ioe) {
                                log.warn("Exception encountered in block report thread", (Throwable)ioe);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                log.info("Block reporting thread exiting");
            });
            blockReportThread.setDaemon(true);
            blockReportThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            blockReportThread.start();
        }
        float maxMissingBlocks = (float)totalBlocks * conf.getFloat(MISSING_BLOCKS_MAX_FRACTION_KEY, 1.0E-4f);
        log.info("Waiting for MissingBlocks to fall below {}...", (Object)Float.valueOf(maxMissingBlocks));
        DynoInfraUtils.waitForNameNodeJMXValue("Number of missing blocks", FSNAMESYSTEM_JMX_QUERY, JMX_MISSING_BLOCKS, maxMissingBlocks, (double)totalBlocks * 1.0E-4, true, nameNodeProperties, shouldExit, log);
        float maxUnderreplicatedBlocks = (float)totalBlocks * conf.getFloat(UNDERREPLICATED_BLOCKS_MAX_FRACTION_KEY, 0.01f);
        log.info("Waiting for UnderReplicatedBlocks to fall below {}...", (Object)Float.valueOf(maxUnderreplicatedBlocks));
        DynoInfraUtils.waitForNameNodeJMXValue("Number of under replicated blocks", FSNAMESYSTEM_STATE_JMX_QUERY, JMX_UNDER_REPLICATED_BLOCKS, maxUnderreplicatedBlocks, (double)totalBlocks * 0.001, true, nameNodeProperties, shouldExit, log);
        log.info("NameNode is ready for use!");
        doneWaiting.set(true);
    }

    private static void triggerDataNodeBlockReport(Configuration conf, String dataNodeTarget) throws IOException {
        InetSocketAddress datanodeAddr = NetUtils.createSocketAddr((String)dataNodeTarget);
        ClientDatanodeProtocol dnProtocol = DFSUtilClient.createClientDatanodeProtocolProxy((InetSocketAddress)datanodeAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, ClientDatanodeProtocol.class));
        dnProtocol.triggerBlockReport(new BlockReportOptions.Factory().build());
    }

    private static void waitForNameNodeJMXValue(String valueName, String jmxBeanQuery, String jmxProperty, double threshold, double printThreshold, boolean decreasing, Properties nameNodeProperties, Supplier<Boolean> shouldExit, Logger log) throws InterruptedException {
        double lastPrintedValue = decreasing ? Double.MAX_VALUE : Double.MIN_VALUE;
        int retryCount = 0;
        long startTime = Time.monotonicNow();
        while (!shouldExit.get().booleanValue()) {
            block5: {
                try {
                    double value = Double.parseDouble(DynoInfraUtils.fetchNameNodeJMXValue(nameNodeProperties, jmxBeanQuery, jmxProperty));
                    if (decreasing && value <= threshold || !decreasing && value >= threshold) {
                        log.info(String.format("%s = %.2f; %s threshold of %.2f; done waiting after %d ms.", valueName, value, decreasing ? "below" : "above", threshold, Time.monotonicNow() - startTime));
                        break;
                    }
                    if (Math.abs(value - lastPrintedValue) >= printThreshold) {
                        log.info(String.format("%s: %.2f", valueName, value));
                        lastPrintedValue = value;
                    }
                }
                catch (IOException ioe) {
                    if (++retryCount % 20 != 0) break block5;
                    log.warn("Unable to fetch {}; retried {} times / waited {} ms", new Object[]{valueName, retryCount, Time.monotonicNow() - startTime, ioe});
                }
            }
            Thread.sleep(3000L);
        }
    }

    static Set<String> parseStaleDataNodeList(String liveNodeJsonString, int blockThreshold, Logger log) throws IOException {
        HashSet<String> dataNodesToReport = new HashSet<String>();
        JsonFactory fac = new JsonFactory();
        JsonParser parser = fac.createParser(IOUtils.toInputStream((String)liveNodeJsonString, (String)StandardCharsets.UTF_8.name()));
        int objectDepth = 0;
        String currentNodeAddr = null;
        JsonToken tok = parser.nextToken();
        while (tok != null) {
            if (tok == JsonToken.START_OBJECT) {
                ++objectDepth;
            } else if (tok == JsonToken.END_OBJECT) {
                --objectDepth;
            } else if (tok == JsonToken.FIELD_NAME) {
                if (objectDepth == 1) {
                    currentNodeAddr = parser.getCurrentName();
                } else if (objectDepth == 2 && parser.getCurrentName().equals("numBlocks")) {
                    JsonToken valueToken = parser.nextToken();
                    if (valueToken != JsonToken.VALUE_NUMBER_INT || currentNodeAddr == null) {
                        throw new IOException(String.format("Malformed LiveNodes JSON; got token = %s; currentNodeAddr = %s: %s", valueToken, currentNodeAddr, liveNodeJsonString));
                    }
                    int numBlocks = parser.getIntValue();
                    if (numBlocks < blockThreshold) {
                        log.debug(String.format("Queueing Datanode <%s> for block report; numBlocks = %d", currentNodeAddr, numBlocks));
                        dataNodesToReport.add(currentNodeAddr);
                    } else {
                        log.debug(String.format("Not queueing Datanode <%s> for block report; numBlocks = %d", currentNodeAddr, numBlocks));
                    }
                }
            }
            tok = parser.nextToken();
        }
        return dataNodesToReport;
    }

    static String fetchNameNodeJMXValue(Properties nameNodeProperties, String jmxBeanQuery, String property) throws IOException {
        URL queryURL;
        URI nnWebUri = DynoInfraUtils.getNameNodeWebUri(nameNodeProperties);
        try {
            queryURL = new URL(nnWebUri.getScheme(), nnWebUri.getHost(), nnWebUri.getPort(), "/jmx?qry=" + jmxBeanQuery);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JMX query: \"" + jmxBeanQuery + "\" against NameNode URI: " + nnWebUri);
        }
        HttpURLConnection conn = (HttpURLConnection)queryURL.openConnection();
        if (conn.getResponseCode() != 200) {
            throw new IOException("Unable to retrieve JMX: " + conn.getResponseMessage());
        }
        JsonFactory fac = new JsonFactory();
        InputStream in = conn.getInputStream();
        JsonParser parser = fac.createParser(in);
        if (parser.nextToken() != JsonToken.START_OBJECT || parser.nextToken() != JsonToken.FIELD_NAME || !parser.getCurrentName().equals("beans") || parser.nextToken() != JsonToken.START_ARRAY || parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("Unexpected format of JMX JSON response for: " + jmxBeanQuery);
        }
        int objectDepth = 1;
        String ret = null;
        while (objectDepth > 0) {
            JsonToken tok = parser.nextToken();
            if (tok == JsonToken.START_OBJECT) {
                ++objectDepth;
                continue;
            }
            if (tok == JsonToken.END_OBJECT) {
                --objectDepth;
                continue;
            }
            if (tok != JsonToken.FIELD_NAME || !parser.getCurrentName().equals(property)) continue;
            parser.nextToken();
            ret = parser.getText();
            break;
        }
        parser.close();
        in.close();
        conn.disconnect();
        if (ret == null) {
            throw new IOException("Property " + property + " not found within " + jmxBeanQuery);
        }
        return ret;
    }
}

