/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapRFsOutputFile;
import org.apache.hadoop.mapred.MapRIFileInputStream;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.DirectOnDiskMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleSchedulerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapOutputLocation;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShuffleFetcher<K, V>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DirectShuffleFetcher.class);
    private static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private final Counters.Counter ioErrs;
    private final TaskAttemptID reduceId;
    private MapOutputLocation currentLocation = null;
    private MapRFsOutputFile mapOutputFile;
    private int id;
    private Reporter reporter;
    private volatile boolean shouldExit = false;
    private boolean useDirectReduce = false;
    private int prefetchBytesHint;
    private CompressionCodec codec = null;
    private Decompressor decompressor = null;
    private Configuration jobConf;
    private final MergeManager<K, V> merger;
    protected FileSystem rfs;
    private final ExceptionReporter exceptionReporter;
    private final ShuffleClientMetrics metrics;
    private DirectShuffleSchedulerImpl<K, V> scheduler;
    private static final int OBSOLETE = -2;

    public DirectShuffleFetcher(int id, JobConf jobConf, TaskAttemptID reduceId, DirectShuffleSchedulerImpl<K, V> scheduler, MergeManager<K, V> merger, Reporter reporter, ShuffleClientMetrics metrics, ExceptionReporter exceptionReporter, MapOutputFile mapOutputFile) {
        this.id = id;
        this.setName("MapOutputCopier " + reduceId.getTaskID() + "." + id);
        LOG.debug(this.getName() + " created");
        this.reporter = reporter;
        this.ioErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.exceptionReporter = exceptionReporter;
        this.reduceId = reduceId;
        this.mapOutputFile = (MapRFsOutputFile)mapOutputFile;
        this.metrics = metrics;
        this.jobConf = jobConf;
        this.merger = merger;
        try {
            this.rfs = FileSystem.get((Configuration)jobConf);
        }
        catch (IOException e) {
            LOG.error("Unable to init filesystem", (Throwable)e);
        }
        this.scheduler = scheduler;
        this.prefetchBytesHint = jobConf.getInt("maprfs.openfid2.prefetch.bytes", 0);
        if (jobConf.getCompressMapOutput()) {
            Class codecClass = jobConf.getMapOutputCompressorClass(DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jobConf);
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
        }
    }

    public synchronized boolean fail() {
        if (this.currentLocation != null) {
            this.finish(-1L, CopyOutputErrorType.OTHER_ERROR);
            return true;
        }
        return false;
    }

    public synchronized MapOutputLocation getLocation() {
        return this.currentLocation;
    }

    private synchronized void finish(long size, CopyOutputErrorType error) {
        if (this.currentLocation != null) {
            LOG.debug(this.getName() + " finishing " + this.currentLocation + " =" + size);
            this.currentLocation = null;
        }
    }

    public void shutDown() {
        this.shouldExit = true;
        this.interrupt();
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn("Got interrupt while joining " + this.getName(), (Throwable)ie);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shouldExit) {
                MapOutputLocation loc = null;
                try {
                    this.merger.waitForResource();
                    loc = this.scheduler.getLocation();
                    this.metrics.threadBusy();
                    this.copyOutput(loc);
                }
                catch (IOException ioe) {
                    LOG.warn(this.reduceId.getTaskID() + " copy failed: " + loc.getTaskAttemptId() + " from " + loc.getHost(), (Throwable)ioe);
                    this.metrics.failedFetch();
                }
                catch (InterruptedException ie) {
                    if (!this.shouldExit) {
                        LOG.warn("Unexpected InterruptedException");
                        continue;
                    }
                    break;
                }
                finally {
                    if (loc == null) continue;
                    this.metrics.threadFree();
                }
            }
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
        }
        if (this.decompressor != null) {
            CodecPool.returnDecompressor((Decompressor)this.decompressor);
        }
    }

    @VisibleForTesting
    protected long copyOutput(MapOutputLocation loc) throws IOException, InterruptedException {
        if (loc == null) {
            return -2L;
        }
        MapOutput<K, V> mapOutput = null;
        if (!this.useDirectReduce) {
            Path filename = this.mapOutputFile.getInputFile(loc.getTaskId().getId(), org.apache.hadoop.mapred.TaskAttemptID.downgrade((TaskAttemptID)this.reduceId));
            Path tmpMapOutput = new Path(filename + "-" + this.id);
            mapOutput = this.getMapOutputFromFile(loc, tmpMapOutput, this.reduceId.getTaskID().getId());
        }
        if (mapOutput == null) {
            this.scheduler.copyFailed(loc.getTaskAttemptId(), loc);
            this.scheduler.addKnownMapOutput(loc.getHost(), loc.getTaskAttemptId(), loc.getShuffleRootFid());
            return -1L;
        }
        long bytes = mapOutput.getSize();
        if (bytes == 0L) {
            mapOutput.abort();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MapOutput<K, V> getMapOutputFromFile(MapOutputLocation mapOutputLoc, Path filename, int reduce) {
        long dataLength;
        long mapOutputLength;
        long fileSize;
        long startTime;
        FSDataInputStream input;
        String inputFile;
        MapOutput mapOutput;
        block16: {
            mapOutput = null;
            inputFile = mapOutputLoc.shuffleRootFid.getFid() + "/" + this.mapOutputFile.getRelOutputFile(org.apache.hadoop.mapred.TaskAttemptID.downgrade((TaskAttemptID)mapOutputLoc.getTaskAttemptId()), reduce);
            input = null;
            startTime = System.currentTimeMillis();
            long _st = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            input = this.rfs.openFid2(mapOutputLoc.shuffleRootFid, this.mapOutputFile.getRelOutputFile(org.apache.hadoop.mapred.TaskAttemptID.downgrade((TaskAttemptID)mapOutputLoc.getTaskAttemptId()), reduce), this.prefetchBytesHint);
            if (LOG.isDebugEnabled()) {
                LOG.debug("MapR-DBG: openFid2 " + input + " took " + (System.currentTimeMillis() - _st));
            }
            fileSize = input.getFileLength();
            MapRIFileInputStream checksumInput = new MapRIFileInputStream((InputStream)input, fileSize, this.jobConf);
            mapOutputLength = checksumInput.getMapOutputFileInfo().getMapOutputSize();
            dataLength = checksumInput.getMapOutputFileInfo().getFileBytesWritten();
            try {
                mapOutput = this.merger.reserve((TaskAttemptID)org.apache.hadoop.mapred.TaskAttemptID.downgrade((TaskAttemptID)mapOutputLoc.getTaskAttemptId()), mapOutputLength, this.id);
            }
            catch (IOException ioe) {
                this.ioErrs.increment(1L);
                this.scheduler.reportLocalError(ioe);
                MapOutput<K, V> mapOutput2 = null;
                if (input == null) return mapOutput2;
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
                return mapOutput2;
            }
            if (mapOutput != null) break block16;
            LOG.error("mapOutput can not be returned as null from reserve");
            MapOutput<K, V> ioe = null;
            if (input == null) return ioe;
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            return ioe;
        }
        try {
            try {
                LOG.info("fetcher#" + this.id + " about to shuffle output of map " + mapOutput.getMapId() + " to " + mapOutput.getDescription());
                long dataSize = mapOutputLength;
                if (mapOutput instanceof DirectOnDiskMapOutput) {
                    dataSize = fileSize;
                }
                mapOutput.shuffle(new MapHost(mapOutputLoc.getHost(), ""), (InputStream)input, dataSize, dataLength, this.metrics, this.reporter);
            }
            catch (InternalError e) {
                LOG.warn("Failed to shuffle for fetcher#" + this.id, (Throwable)e);
                throw new IOException(e);
            }
            long endTime = System.currentTimeMillis();
            this.scheduler.copySucceeded(mapOutput.getMapId(), mapOutputLoc, mapOutput.getSize(), endTime - startTime, mapOutput);
            this.metrics.successFetch();
            long _st = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            input.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("MapR-DBG: close " + input + " took " + (System.currentTimeMillis() - _st));
            }
            if ((input = null) == null) return mapOutput;
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("FileNotFoundException reading map output of task " + mapOutputLoc.getTaskAttemptId() + " for reduce " + reduce + " file path " + inputFile, (Throwable)fnfe);
            MapOutput<K, V> mapOutput3 = null;
            if (input == null) return mapOutput3;
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            return mapOutput3;
        }
        catch (IOException ioe) {
            block17: {
                LOG.error("IOException reading map output of task " + mapOutputLoc.getTaskAttemptId() + " for reduce " + reduce + " file path " + inputFile, (Throwable)ioe);
                this.ioErrs.increment(1L);
                if (mapOutput != null) break block17;
                MapOutput<K, V> mapOutput4 = null;
                if (input == null) return mapOutput4;
                {
                    catch (Throwable throwable) {
                        if (input == null) throw throwable;
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
                        throw throwable;
                    }
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
                return mapOutput4;
            }
            mapOutput.abort();
            this.metrics.failedFetch();
            MapOutput<K, V> mapOutput5 = null;
            if (input == null) return mapOutput5;
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            return mapOutput5;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
        return mapOutput;
    }

    private static enum CopyOutputErrorType {
        NO_ERROR,
        READ_ERROR,
        OTHER_ERROR;

    }

    private static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }
}

