/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.RationalFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.RationalAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public class RationalArray
extends ScalarArray<RationalNumber> {
    public static final DenseArray.Factory<RationalNumber> FACTORY = new DenseArray.Factory<RationalNumber>(){

        @Override
        public AggregatorSet<RationalNumber> aggregator() {
            return RationalAggregator.getSet();
        }

        @Override
        public FunctionSet<RationalNumber> function() {
            return RationalFunction.getSet();
        }

        @Override
        public Scalar.Factory<RationalNumber> scalar() {
            return RationalNumber.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<RationalNumber> make(long size) {
            return RationalArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(RationalNumber.class);

    public static final RationalArray make(int size) {
        return new RationalArray(size);
    }

    public static final RationalArray wrap(RationalNumber[] data) {
        return new RationalArray(data);
    }

    protected RationalArray(int size) {
        super((Number[])new RationalNumber[size]);
        this.fill(0, size, 1, RationalNumber.ZERO);
    }

    protected RationalArray(RationalNumber[] data) {
        super((Number[])data);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof RationalArray) {
            return Arrays.equals(this.data, ((RationalArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((RationalNumber[])this.data)[i] = RationalNumber.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Comparable[])this.data));
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((RationalNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((RationalNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected boolean isAbsolute(int index) {
        return RationalNumber.isAbsolute(((RationalNumber[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return RationalNumber.isSmall(comparedTo, ((RationalNumber[])this.data)[index]);
    }

    @Override
    final RationalNumber valueOf(double value) {
        return RationalNumber.valueOf(value);
    }

    @Override
    final RationalNumber valueOf(Number number) {
        return RationalNumber.valueOf(number);
    }
}

