/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.junit.Assert;
import org.junit.Test;

@InterfaceStability.Stable
public class TestUsersACLsManager {
    @Test
    public void testUsersACLMapping() {
        Configuration conf = new Configuration();
        UsersACLsManager acl = new UsersACLsManager(conf);
        Assert.assertFalse((boolean)acl.isUsersACLEnable());
        conf.set("hadoop.users.acl.mapping", "u:drwho=u:user1");
        acl = new UsersACLsManager(conf);
        Assert.assertTrue((boolean)acl.isUsersACLEnable());
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho", "user1"));
        conf.set("hadoop.users.acl.mapping", "u:drwho=u:user1,u:user2");
        acl = new UsersACLsManager(conf);
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho", "user2"));
        conf.set("hadoop.users.acl.mapping", "u:drwho1=u:user1;u:drwho2=u:user2");
        acl = new UsersACLsManager(conf);
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho2", "user2"));
        conf.set("hadoop.users.acl.mapping", "u:drwho1=u:user1,u:user2;u:drwho2=u:user1,u:user2");
        acl = new UsersACLsManager(conf);
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user2"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho2", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho2", "user2"));
        conf.set("hadoop.users.acl.mapping", "u:drwho1=u:user1,u:user2;\n   u:drwho2=u:user1,u:user2");
        acl = new UsersACLsManager(conf);
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user2"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho2", "user1"));
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho2", "user2"));
        conf.set("hadoop.users.acl.mapping", "u:drwho1=u:user1,u:user2;u:drwho2=u:user1,u:user2");
        acl = new UsersACLsManager(conf);
        Assert.assertFalse((boolean)acl.checkUserAccess("drwho3", "user1"));
        Assert.assertFalse((boolean)acl.checkUserAccess("drwho1", "user3"));
        conf.set("hadoop.users.acl.mapping", "u:drwho1,g:drgroup=g:group2,u:user1,u:user2;u:drwho2=u:user1,u:user2,g:group2");
        Assert.assertTrue((boolean)acl.checkUserAccess("drwho1", "user1"));
        conf.set("hadoop.users.acl.mapping", " : =u:test");
        HadoopIllegalArgumentException ex = (HadoopIllegalArgumentException)Assert.assertThrows(HadoopIllegalArgumentException.class, () -> new UsersACLsManager(conf));
        Assert.assertEquals((Object)"User/group entity is invalid: :", (Object)ex.getMessage());
        conf.set("hadoop.users.acl.mapping", "ut:testUser=u:test");
        ex = (HadoopIllegalArgumentException)Assert.assertThrows(HadoopIllegalArgumentException.class, () -> new UsersACLsManager(conf));
        Assert.assertEquals((Object)"User/group entity is invalid: ut", (Object)ex.getMessage());
        conf.set("hadoop.users.acl.mapping", "u:drwho1,g:drgroup=test=test2 ");
        ex = (HadoopIllegalArgumentException)Assert.assertThrows(HadoopIllegalArgumentException.class, () -> new UsersACLsManager(conf));
        Assert.assertEquals((Object)"Configuration yarn.users.acl.mapping is invalid", (Object)ex.getMessage());
        conf.set("hadoop.users.acl.mapping", " ");
        acl = new UsersACLsManager(conf);
        Assert.assertFalse((boolean)acl.isUsersACLEnable());
        Assert.assertFalse((boolean)acl.checkUserAccess("drwho3", "user1"));
        Assert.assertFalse((boolean)acl.checkUserAccess("drwho1", "user3"));
    }
}

