/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public abstract class RpcReply
extends RpcMessage {
    protected final ReplyState replyState;
    protected final Verifier verifier;

    RpcReply(int xid, ReplyState state, Verifier verifier) {
        super(xid, RpcMessage.Type.RPC_REPLY);
        this.replyState = state;
        this.verifier = verifier;
    }

    public RpcAuthInfo getVerifier() {
        return this.verifier;
    }

    public static RpcReply read(XDR xdr) {
        int xid = xdr.readInt();
        RpcMessage.Type messageType = RpcMessage.Type.fromValue(xdr.readInt());
        Preconditions.checkState((messageType == RpcMessage.Type.RPC_REPLY ? 1 : 0) != 0);
        ReplyState stat = ReplyState.fromValue(xdr.readInt());
        switch (stat) {
            case MSG_ACCEPTED: {
                return RpcAcceptedReply.read(xid, stat, xdr);
            }
            case MSG_DENIED: {
                return RpcDeniedReply.read(xid, stat, xdr);
            }
        }
        return null;
    }

    public ReplyState getState() {
        return this.replyState;
    }

    public static enum ReplyState {
        MSG_ACCEPTED,
        MSG_DENIED;


        int getValue() {
            return this.ordinal();
        }

        public static ReplyState fromValue(int value) {
            return ReplyState.values()[value];
        }
    }
}

