/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.router.RouterHDFSContract;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.security.RouterSecurityManager;
import org.apache.hadoop.hdfs.server.federation.router.security.token.ZKDelegationTokenSecretManagerImpl;
import org.apache.hadoop.hdfs.server.federation.security.MockDelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.federation.security.MockNotRunningSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterSecurityManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterSecurityManager.class);
    private static RouterSecurityManager securityManager = null;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void createMockSecretManager() throws IOException {
        MockDelegationTokenSecretManager mockDelegationTokenSecretManager = new MockDelegationTokenSecretManager(100L, 100L, 100L, 100L);
        mockDelegationTokenSecretManager.startThreads();
        securityManager = new RouterSecurityManager((AbstractDelegationTokenSecretManager)mockDelegationTokenSecretManager);
    }

    @Test
    public void testCreateSecretManagerUsingReflection() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.router.secret.manager.class", MockDelegationTokenSecretManager.class.getName());
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.name());
        RouterSecurityManager routerSecurityManager = new RouterSecurityManager((Configuration)conf);
        AbstractDelegationTokenSecretManager secretManager = routerSecurityManager.getSecretManager();
        Assert.assertNotNull((Object)secretManager);
        Assert.assertTrue((boolean)secretManager.isRunning());
        routerSecurityManager.stop();
        Assert.assertFalse((boolean)secretManager.isRunning());
    }

    @Test
    public void testDelegationTokens() throws IOException {
        UserGroupInformation.reset();
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        Token token = securityManager.getDelegationToken(new Text("some_renewer"));
        Assert.assertNotNull((Object)token);
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"some_renewer", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        long updatedExpirationTime = securityManager.renewDelegationToken(token);
        Assert.assertTrue((updatedExpirationTime <= ((DelegationTokenIdentifier)token.decodeIdentifier()).getMaxDate() ? 1 : 0) != 0);
        securityManager.cancelDelegationToken(token);
        String exceptionCause = "Renewal request for unknown token";
        this.exceptionRule.expect(SecretManager.InvalidToken.class);
        this.exceptionRule.expectMessage(exceptionCause);
        securityManager.renewDelegationToken(token);
    }

    @Test
    public void testVerifyToken() throws IOException {
        UserGroupInformation.reset();
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        Token token = securityManager.getDelegationToken(new Text("some_renewer"));
        Assert.assertNotNull((Object)token);
        securityManager.verifyToken((DelegationTokenIdentifier)token.decodeIdentifier(), token.getPassword());
        String exceptionCause = "password doesn't match";
        this.exceptionRule.expect(SecretManager.InvalidToken.class);
        this.exceptionRule.expectMessage(StringContains.containsString((String)exceptionCause));
        securityManager.verifyToken((DelegationTokenIdentifier)token.decodeIdentifier(), new byte[10]);
    }

    @Test
    public void testCreateCredentials() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        conf.addResource(routerConf);
        Router router = new Router();
        router.init(conf);
        router.start();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting());
        Credentials creds = RouterSecurityManager.createCredentials((Router)router, (UserGroupInformation)ugi, (String)"some_renewer");
        for (Token token : creds.getAllTokens()) {
            Assert.assertNotNull((Object)token);
            Assert.assertEquals((Object)"HDFS_DELEGATION_TOKEN", (Object)token.getKind().toString());
            DelegationTokenIdentifier identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
            Assert.assertNotNull((Object)identifier);
            String owner = identifier.getOwner().toString();
            String host = Path.WINDOWS ? "127.0.0.1" : "localhost";
            String expectedOwner = "router/" + host + "@EXAMPLE.COM";
            Assert.assertEquals((Object)expectedOwner, (Object)owner);
            Assert.assertEquals((Object)"some_renewer", (Object)identifier.getRenewer().toString());
        }
        RouterHDFSContract.destroyCluster();
    }

    private static String[] getUserGroupForTesting() {
        String[] groupsForTesting = new String[]{"router_group"};
        return groupsForTesting;
    }

    @Test
    public void testWithoutSecretManager() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.set("dfs.federation.router.secret.manager.class", ZKDelegationTokenSecretManagerImpl.class.getName());
        Router router = new Router();
        LambdaTestUtils.intercept(ServiceStateException.class, (String)"Failed to create SecretManager", () -> router.init(conf));
    }

    @Test
    public void testNotRunningSecretManager() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.set("dfs.federation.router.secret.manager.class", MockNotRunningSecretManager.class.getName());
        Router router = new Router();
        LambdaTestUtils.intercept(ServiceStateException.class, (String)"Failed to create SecretManager", () -> router.init(conf));
    }
}

