/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePool;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePools;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.config.SizedResourcePool;
import org.apache.hadoop.shaded.org.ehcache.core.HumanReadable;

public class ResourcePoolsImpl
implements ResourcePools,
HumanReadable {
    private final Map<ResourceType<?>, ResourcePool> pools;

    public ResourcePoolsImpl(Map<ResourceType<?>, ResourcePool> pools) {
        if (pools.isEmpty()) {
            throw new IllegalArgumentException("No resource pools defined");
        }
        ResourcePoolsImpl.validateResourcePools(pools.values());
        this.pools = pools;
    }

    @Override
    public <P extends ResourcePool> P getPoolForResource(ResourceType<P> resourceType) {
        return (P)((ResourcePool)resourceType.getResourcePoolClass().cast(this.pools.get(resourceType)));
    }

    @Override
    public Set<ResourceType<?>> getResourceTypeSet() {
        return this.pools.keySet();
    }

    @Override
    public ResourcePools validateAndMerge(ResourcePools toBeUpdated) {
        if (!this.getResourceTypeSet().containsAll(toBeUpdated.getResourceTypeSet())) {
            throw new IllegalArgumentException("Pools to be updated cannot contain previously undefined resources pools");
        }
        if (toBeUpdated.getResourceTypeSet().contains(ResourceType.Core.OFFHEAP)) {
            throw new UnsupportedOperationException("Updating OFFHEAP resource is not supported");
        }
        if (toBeUpdated.getResourceTypeSet().contains(ResourceType.Core.DISK)) {
            throw new UnsupportedOperationException("Updating DISK resource is not supported");
        }
        for (ResourceType<?> currentResourceType : toBeUpdated.getResourceTypeSet()) {
            this.getPoolForResource(currentResourceType).validateUpdate((ResourcePool)toBeUpdated.getPoolForResource(currentResourceType));
        }
        HashMap poolsMap = new HashMap();
        poolsMap.putAll(this.pools);
        for (ResourceType<?> currentResourceType : toBeUpdated.getResourceTypeSet()) {
            Object poolForResource = toBeUpdated.getPoolForResource(currentResourceType);
            poolsMap.put(currentResourceType, (ResourcePool)poolForResource);
        }
        return new ResourcePoolsImpl(poolsMap);
    }

    public static void validateResourcePools(Collection<? extends ResourcePool> pools) {
        ArrayList<SizedResourcePool> ordered = new ArrayList<SizedResourcePool>(pools.size());
        for (ResourcePool resourcePool : pools) {
            if (!(resourcePool instanceof SizedResourcePool)) continue;
            ordered.add((SizedResourcePool)resourcePool);
        }
        Collections.sort(ordered, new Comparator<SizedResourcePool>(){

            @Override
            public int compare(SizedResourcePool o1, SizedResourcePool o2) {
                int retVal = o2.getType().getTierHeight() - o1.getType().getTierHeight();
                if (retVal == 0) {
                    return o1.toString().compareTo(o2.toString());
                }
                return retVal;
            }
        });
        for (int i = 0; i < ordered.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                boolean inversion;
                boolean ambiguity;
                SizedResourcePool upper = (SizedResourcePool)ordered.get(j);
                SizedResourcePool lower = (SizedResourcePool)ordered.get(i);
                try {
                    ambiguity = upper.getType().getTierHeight() == lower.getType().getTierHeight();
                    inversion = upper.getUnit().compareTo(upper.getSize(), lower.getSize(), lower.getUnit()) >= 0 || lower.getUnit().compareTo(lower.getSize(), upper.getSize(), upper.getUnit()) <= 0;
                }
                catch (IllegalArgumentException e) {
                    ambiguity = false;
                    inversion = false;
                }
                if (ambiguity) {
                    throw new IllegalArgumentException("Tiering Ambiguity: '" + upper + "' has the same tier height as '" + lower + "'");
                }
                if (!inversion) continue;
                throw new IllegalArgumentException("Tiering Inversion: '" + upper + "' is not smaller than '" + lower + "'");
            }
        }
    }

    @Override
    public String readableString() {
        TreeMap sortedPools = new TreeMap(new Comparator<ResourceType<?>>(){

            @Override
            public int compare(ResourceType<?> o1, ResourceType<?> o2) {
                return o2.getTierHeight() - o1.getTierHeight();
            }
        });
        sortedPools.putAll(this.pools);
        StringBuilder poolsToStringBuilder = new StringBuilder();
        for (Map.Entry poolEntry : sortedPools.entrySet()) {
            poolsToStringBuilder.append(poolEntry.getKey()).append(": ").append("\n        ").append("size: ").append((Object)(poolEntry.getValue() instanceof HumanReadable ? ((HumanReadable)poolEntry.getValue()).readableString() : poolEntry.getValue())).append("\n        ").append("tierHeight: ").append(((ResourceType)poolEntry.getKey()).getTierHeight()).append("\n    ");
        }
        if (poolsToStringBuilder.length() > 4) {
            poolsToStringBuilder.delete(poolsToStringBuilder.length() - 5, poolsToStringBuilder.length());
        }
        return "pools: \n    " + poolsToStringBuilder.toString();
    }
}

