/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.FileMonitoringTimerTask;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.ReloadingX509KeystoreManager;
import org.apache.hadoop.security.ssl.TestReloadingX509TrustManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReloadingX509KeyManager {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestReloadingX509TrustManager.class.getSimpleName());
    private final GenericTestUtils.LogCapturer reloaderLog = GenericTestUtils.LogCapturer.captureLogs(FileMonitoringTimerTask.LOG);

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @Test(expected=IOException.class)
    public void testLoadMissingKeyStore() throws Exception {
        String keystoreLocation = BASEDIR + "/testmissing.jks";
        ReloadingX509KeystoreManager tm = new ReloadingX509KeystoreManager("jks", keystoreLocation, "password", "password");
    }

    @Test(expected=IOException.class)
    public void testLoadCorruptKeyStore() throws Exception {
        String keystoreLocation = BASEDIR + "/testcorrupt.jks";
        FileOutputStream os = new FileOutputStream(keystoreLocation);
        ((OutputStream)os).write(1);
        ((OutputStream)os).close();
        ReloadingX509KeystoreManager tm = new ReloadingX509KeystoreManager("jks", keystoreLocation, "password", "password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000000L)
    public void testReload() throws Exception {
        final KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", kp, 30, "SHA256WithRSA");
        String keystoreLocation = BASEDIR + "/testreload.jks";
        KeyStoreTestUtil.createKeyStore(keystoreLocation, "password", "cert1", (Key)kp.getPrivate(), sCert);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        final ReloadingX509KeystoreManager tm = new ReloadingX509KeystoreManager("jks", keystoreLocation, "password", "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(keystoreLocation, new String[0]), arg_0 -> ((ReloadingX509KeystoreManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((Object)kp.getPrivate(), (Object)tm.getPrivateKey("cert1"));
            Thread.sleep(reloadInterval + 1000L);
            KeyPair anotherKP = KeyStoreTestUtil.generateKeyPair("RSA");
            sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", anotherKP, 30, "SHA256WithRSA");
            KeyStoreTestUtil.createKeyStore(keystoreLocation, "password", "cert1", (Key)anotherKP.getPrivate(), sCert);
            GenericTestUtils.waitFor((Supplier<Boolean>)new org.apache.hadoop.thirdparty.com.google.common.base.Supplier<Boolean>(){

                public Boolean get() {
                    return tm.getPrivateKey("cert1").equals(kp.getPrivate());
                }
            }, (int)reloadInterval, 100000L);
        }
        finally {
            fileMonitoringTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadMissingTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        String keystoreLocation = BASEDIR + "/testmissing.jks";
        KeyStoreTestUtil.createKeyStore(keystoreLocation, "password", "cert1", (Key)kp.getPrivate(), cert1);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        ReloadingX509KeystoreManager tm = new ReloadingX509KeystoreManager("jks", keystoreLocation, "password", "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(keystoreLocation, new String[0]), arg_0 -> ((ReloadingX509KeystoreManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((Object)kp.getPrivate(), (Object)tm.getPrivateKey("cert1"));
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not process file change : "));
            Thread.sleep(reloadInterval + 1000L);
            new File(keystoreLocation).delete();
            Thread.sleep(reloadInterval + 1000L);
            this.waitForFailedReloadAtLeastOnce((int)reloadInterval);
            Assert.assertEquals((Object)kp.getPrivate(), (Object)tm.getPrivateKey("cert1"));
        }
        finally {
            this.reloaderLog.stopCapturing();
            fileMonitoringTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadCorruptTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        String keystoreLocation = BASEDIR + "/testmissing.jks";
        KeyStoreTestUtil.createKeyStore(keystoreLocation, "password", "cert1", (Key)kp.getPrivate(), cert1);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        ReloadingX509KeystoreManager tm = new ReloadingX509KeystoreManager("jks", keystoreLocation, "password", "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(keystoreLocation, new String[0]), arg_0 -> ((ReloadingX509KeystoreManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((Object)kp.getPrivate(), (Object)tm.getPrivateKey("cert1"));
            Thread.sleep(reloadInterval + 1000L);
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not process file change : "));
            FileOutputStream os = new FileOutputStream(keystoreLocation);
            ((OutputStream)os).write(1);
            ((OutputStream)os).close();
            this.waitForFailedReloadAtLeastOnce((int)reloadInterval);
            Assert.assertEquals((Object)kp.getPrivate(), (Object)tm.getPrivateKey("cert1"));
        }
        finally {
            this.reloaderLog.stopCapturing();
            fileMonitoringTimer.cancel();
        }
    }

    private void waitForFailedReloadAtLeastOnce(int reloadInterval) throws InterruptedException, TimeoutException {
        GenericTestUtils.waitFor((Supplier<Boolean>)new org.apache.hadoop.thirdparty.com.google.common.base.Supplier<Boolean>(){

            public Boolean get() {
                return TestReloadingX509KeyManager.this.reloaderLog.getOutput().contains("Could not process file change : ");
            }
        }, reloadInterval, 10000L);
    }
}

