/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AdminStatesBaseTest;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDecommissionWithBackoffMonitor;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDecommission
extends AdminStatesBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestDecommission.class);

    private static String checkFile(FileSystem fileSys, Path name, int repl, String downnode, int numDatanodes) throws IOException {
        boolean isNodeDown = downnode != null;
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)fileSys.open(name);
        List dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int hasdown = 0;
            DatanodeInfoWithStorage[] nodes = blk.getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                if (isNodeDown && nodes[j].getXferAddr().equals(downnode)) {
                    ++hasdown;
                    if (!nodes[j].isDecommissioned()) {
                        return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is given as downnode, but is not decommissioned";
                    }
                    if (j != nodes.length - 1) {
                        return "For block " + blk.getBlock() + " decommissioned node " + nodes[j] + " was not last node in list: " + (j + 1) + " of " + nodes.length;
                    }
                    LOG.info("Block " + blk.getBlock() + " replica on " + nodes[j] + " is decommissioned.");
                    continue;
                }
                if (!nodes[j].isDecommissioned()) continue;
                return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is unexpectedly decommissioned";
            }
            LOG.info("Block " + blk.getBlock() + " has " + hasdown + " decommissioned replica.");
            if (Math.min(numDatanodes, repl + hasdown) == nodes.length) continue;
            return "Wrong number of replicas for block " + blk.getBlock() + ": " + nodes.length + ", expected " + Math.min(numDatanodes, repl + hasdown);
        }
        return null;
    }

    private void verifyStats(NameNode namenode, FSNamesystem fsn, DatanodeInfo info, DataNode node, boolean decommissioning) throws InterruptedException, IOException {
        for (int i = 0; i < 10; ++i) {
            long[] newStats = namenode.getRpcServer().getStats();
            Assert.assertEquals((long)newStats[0], (long)(decommissioning ? 0L : info.getCapacity()));
            Assert.assertEquals((long)newStats[1], (long)(decommissioning ? 0L : info.getDfsUsed()));
            Assert.assertEquals((long)newStats[2], (long)(decommissioning ? 0L : info.getRemaining()));
            Assert.assertEquals((long)fsn.getTotalLoad(), (long)info.getXceiverCount());
            DataNodeTestUtils.triggerHeartbeat(node);
        }
    }

    @Test(timeout=360000L)
    public void testDecommission() throws IOException {
        this.testDecommission(1, 6);
    }

    @Test(timeout=360000L)
    public void testDecommission2() throws IOException {
        LOG.info("Starting test testDecommission");
        int numNamenodes = 1;
        int numDatanodes = 4;
        this.getConf().setInt("dfs.replication", 3);
        this.startCluster(numNamenodes, numDatanodes);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        Path file1 = new Path("testDecommission2.dat");
        int replicas = 4;
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
        int deadDecommissioned = ns.getNumDecomDeadDataNodes();
        int liveDecommissioned = ns.getNumDecomLiveDataNodes();
        DatanodeInfo decomNode = this.takeNodeOutofService(0, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        Assert.assertEquals((long)deadDecommissioned, (long)ns.getNumDecomDeadDataNodes());
        Assert.assertEquals((long)(liveDecommissioned + 1), (long)ns.getNumDecomLiveDataNodes());
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertNull((Object)TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes));
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        this.shutdownCluster();
        this.startCluster(1, 4);
    }

    @Test(timeout=360000L)
    public void testDecommissionFederation() throws IOException {
        this.testDecommission(2, 2);
    }

    @Test(timeout=360000L)
    public void testDecommissionOnStandby() throws Exception {
        this.getConf().setInt("dfs.ha.tail-edits.period", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 30000);
        this.getConf().setInt("dfs.namenode.tolerate.heartbeat.multiplier", 2);
        long slowHeartbeatDNwaitTime = this.getConf().getLong("dfs.heartbeat.interval", 3L) * 1000L * (long)(this.getConf().getInt("dfs.namenode.tolerate.heartbeat.multiplier", 4) + 1);
        this.startSimpleHACluster(3);
        Path file1 = new Path("testDecommissionHA.dat");
        int replicas = 3;
        DistributedFileSystem activeFileSys = this.getCluster().getFileSystem(0);
        TestDecommission.writeFile((FileSystem)activeFileSys, file1, replicas);
        HATestUtil.waitForStandbyToCatchUp(this.getCluster().getNameNode(0), this.getCluster().getNameNode(1));
        this.getConf().setLong("dfs.heartbeat.interval", 30L);
        this.getCluster().startDataNodes(this.getConf(), 1, true, null, null, null);
        DataNode lastDN = this.getCluster().getDataNodes().get(3);
        lastDN.getDatanodeUuid();
        DataNode firstDN = this.getCluster().getDataNodes().get(0);
        DatanodeInfo decommissionedNodeFromANN = this.takeNodeOutofService(0, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        DatanodeInfo decomNodeFromSBN = this.takeNodeOutofService(1, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        Thread.sleep(slowHeartbeatDNwaitTime);
        this.putNodeInService(1, decomNodeFromSBN);
        MiniDFSCluster.DataNodeProperties lastDNprop = this.getCluster().stopDataNode(3);
        lastDNprop.conf.setLong("dfs.heartbeat.interval", 1L);
        this.getCluster().restartDataNode(lastDNprop);
        MiniDFSCluster.DataNodeProperties nextToLastDNprop = this.getCluster().stopDataNode(2);
        nextToLastDNprop.conf.setLong("dfs.heartbeat.interval", 30L);
        this.getCluster().restartDataNode(nextToLastDNprop);
        this.getCluster().waitActive();
        Thread.sleep(slowHeartbeatDNwaitTime);
        this.putNodeInService(0, decommissionedNodeFromANN);
        this.getCluster().triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.getCluster());
        this.getCluster().triggerDeletionReports();
        this.takeNodeOutofService(0, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.takeNodeOutofService(1, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
    }

    private void testDecommission(int numNamenodes, int numDatanodes) throws IOException {
        LOG.info("Starting test testDecommission");
        this.startCluster(numNamenodes, numDatanodes);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        for (int i = 0; i < numNamenodes; ++i) {
            namenodeDecomList.add(i, new ArrayList(numDatanodes));
        }
        Path file1 = new Path("testDecommission.dat");
        for (int iteration = 0; iteration < numDatanodes - 1; ++iteration) {
            int replicas = numDatanodes - iteration - 1;
            for (int i = 0; i < numNamenodes; ++i) {
                ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(i);
                DistributedFileSystem fileSys = this.getCluster().getFileSystem(i);
                FSNamesystem ns = this.getCluster().getNamesystem(i);
                TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
                int deadDecommissioned = ns.getNumDecomDeadDataNodes();
                int liveDecommissioned = ns.getNumDecomLiveDataNodes();
                DatanodeInfo decomNode = this.takeNodeOutofService(i, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
                decommissionedNodes.add(decomNode);
                Assert.assertEquals((long)deadDecommissioned, (long)ns.getNumDecomDeadDataNodes());
                Assert.assertEquals((long)(liveDecommissioned + 1), (long)ns.getNumDecomLiveDataNodes());
                DFSClient client = this.getDfsClient(i);
                Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
                int tries = 0;
                while (tries++ < 20) {
                    try {
                        Thread.sleep(1000L);
                        if (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes) != null) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Assert.assertTrue((String)("Checked if block was replicated after decommission, tried " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
                TestDecommission.cleanupFile((FileSystem)fileSys, file1);
            }
        }
        this.shutdownCluster();
        this.startCluster(numNamenodes, numDatanodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRecommission() throws Exception {
        int numDatanodes = 6;
        try {
            LOG.info("Starting test testRecommission");
            this.startCluster(1, 6);
            Path file1 = new Path("testDecommission.dat");
            int replicas = 5;
            ArrayList decommissionedNodes = Lists.newArrayList();
            DistributedFileSystem fileSys = this.getCluster().getFileSystem();
            TestDecommission.writeFile((FileSystem)fileSys, file1, 5);
            BlockLocation loc = fileSys.getFileBlockLocations(file1, 0L, 1L)[0];
            Assert.assertEquals((String)"Unexpected number of replicas from getFileBlockLocations", (long)5L, (long)loc.getHosts().length);
            String toDecomHost = loc.getNames()[0];
            String toDecomUuid = null;
            for (DataNode d : this.getCluster().getDataNodes()) {
                if (!d.getDatanodeId().getXferAddr().equals(toDecomHost)) continue;
                toDecomUuid = d.getDatanodeId().getDatanodeUuid();
                break;
            }
            Assert.assertNotNull((String)"Could not find a dn with the block!", toDecomUuid);
            DatanodeInfo decomNode = this.takeNodeOutofService(0, toDecomUuid, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
            decommissionedNodes.add(decomNode);
            final BlockManager blockManager = this.getCluster().getNamesystem().getBlockManager();
            DatanodeManager datanodeManager = blockManager.getDatanodeManager();
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSClient client = this.getDfsClient(0);
            Assert.assertEquals((String)"All datanodes must be alive", (long)6L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
            final ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fileSys, file1);
            final String uuid = toDecomUuid;
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    BlockInfo info = blockManager.getStoredBlock(b.getLocalBlock());
                    int count = 0;
                    StringBuilder sb = new StringBuilder("Replica locations: ");
                    for (int i = 0; i < info.numNodes(); ++i) {
                        DatanodeDescriptor dn = info.getDatanode(i);
                        sb.append(dn + ", ");
                        if (dn.getDatanodeUuid().equals(uuid)) continue;
                        ++count;
                    }
                    LOG.info(sb.toString());
                    LOG.info("Count: " + count);
                    return count == 5;
                }
            }, (long)500L, (long)30000L);
            this.putNodeInService(0, decomNode);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSTestUtil.waitForReplication(this.getCluster(), b, 1, 5, 0);
            TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=360000L)
    public void testClusterStats() throws Exception {
        this.testClusterStats(1);
    }

    @Test(timeout=360000L)
    public void testClusterStatsFederation() throws Exception {
        this.testClusterStats(3);
    }

    public void testClusterStats(int numNameNodes) throws IOException, InterruptedException {
        LOG.info("Starting test testClusterStats");
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes);
        for (int i = 0; i < numNameNodes; ++i) {
            DistributedFileSystem fileSys = this.getCluster().getFileSystem(i);
            Path file = new Path("testClusterStats.dat");
            TestDecommission.writeFile((FileSystem)fileSys, file, 1);
            FSNamesystem fsn = this.getCluster().getNamesystem(i);
            NameNode namenode = this.getCluster().getNameNode(i);
            DatanodeInfo decomInfo = this.takeNodeOutofService(i, null, 0L, null, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            DataNode decomNode = this.getDataNode(decomInfo);
            this.verifyStats(namenode, fsn, decomInfo, decomNode, true);
            DatanodeDescriptor retInfo = NameNodeAdapter.getDatanode(fsn, (DatanodeID)decomInfo);
            this.putNodeInService(i, (DatanodeInfo)retInfo);
            DataNode retNode = this.getDataNode(decomInfo);
            this.verifyStats(namenode, fsn, (DatanodeInfo)retInfo, retNode, false);
        }
    }

    private DataNode getDataNode(DatanodeInfo decomInfo) {
        DataNode decomNode = null;
        for (DataNode dn : this.getCluster().getDataNodes()) {
            if (!decomInfo.equals((Object)dn.getDatanodeId())) continue;
            decomNode = dn;
            break;
        }
        Assert.assertNotNull((String)"Could not find decomNode in cluster!", decomNode);
        return decomNode;
    }

    @Test(timeout=360000L)
    public void testHostsFile() throws IOException, InterruptedException {
        this.testHostsFile(1);
    }

    @Test(timeout=360000L)
    public void testHostsFileFederation() throws IOException, InterruptedException {
        this.testHostsFile(3);
    }

    public void testHostsFile(int numNameNodes) throws IOException, InterruptedException {
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes, true, null, false);
        String bogusIp = "127.0.30.1";
        this.initIncludeHost("127.0.30.1");
        for (int j = 0; j < numNameNodes; ++j) {
            this.refreshNodes(j);
            DFSClient client = this.getDfsClient(j);
            DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != 0; ++i) {
                LOG.info("Waiting for datanode to be marked dead");
                Thread.sleep(1000L);
                info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            Assert.assertEquals((String)"Number of live nodes should be 0", (long)0L, (long)info.length);
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            Assert.assertEquals((String)"There should be 1 dead node", (long)1L, (long)info.length);
            Assert.assertEquals((Object)"127.0.30.1", (Object)info[0].getHostName());
        }
    }

    @Test(timeout=120000L)
    public void testDecommissionWithOpenfile() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithOpenfile");
        this.startCluster(1, 7);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        TestDecommission.writeFile((FileSystem)fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfoWithStorage[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        DatanodeInfoWithStorage[] dnInfos4FirstBlock = lbs.get(0).getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> dnInfos = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        DatanodeInfoWithStorage[] datanodeInfoWithStorageArray = dnInfos4FirstBlock;
        int n = datanodeInfoWithStorageArray.length;
        for (int i = 0; i < n; ++i) {
            DatanodeInfoWithStorage datanodeInfo;
            DatanodeInfoWithStorage found = datanodeInfo = datanodeInfoWithStorageArray[i];
            for (DatanodeInfoWithStorage dif : dnInfos4LastBlock) {
                if (!datanodeInfo.equals((Object)dif)) continue;
                found = null;
            }
            if (found == null) continue;
            nodes.add(found.getXferAddr());
            dnInfos.add(dm.getDatanode((DatanodeID)found));
        }
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[0]));
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        for (DatanodeInfo datanodeInfo : dnInfos) {
            this.waitNodeState(datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        fdos.close();
    }

    @Test(timeout=20000L)
    public void testDecommissionWithUnknownBlock() throws IOException {
        this.startCluster(1, 3);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        DatanodeManager datanodeManager = ns.getBlockManager().getDatanodeManager();
        BlockInfoContiguous blk = new BlockInfoContiguous(new Block(1L), 1);
        DatanodeDescriptor dn = (DatanodeDescriptor)datanodeManager.getDatanodes().iterator().next();
        dn.getStorageInfos()[0].addBlock((BlockInfo)blk, (Block)blk);
        datanodeManager.getDatanodeAdminManager().startDecommission(dn);
        this.waitNodeState((DatanodeInfo)dn, DatanodeInfo.AdminStates.DECOMMISSIONED);
    }

    private static String scanIntoString(ByteArrayOutputStream baos) {
        TextStringBuilder sb = new TextStringBuilder();
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            sb.appendln(scanner.nextLine());
        }
        scanner.close();
        return sb.toString();
    }

    private boolean verifyOpenFilesListing(String message, HashSet<Path> closedFileSet, HashMap<Path, FSDataOutputStream> openFilesMap, ByteArrayOutputStream out, int expOpenFilesListSize) {
        String outStr = TestDecommission.scanIntoString(out);
        LOG.info(message + " - stdout: \n" + outStr);
        for (Path path : closedFileSet) {
            if (!outStr.contains(path.toString())) continue;
            return false;
        }
        HashSet<Path> openFilesNotListed = new HashSet<Path>();
        for (Path openFilePath : openFilesMap.keySet()) {
            if (outStr.contains(openFilePath.toString())) continue;
            openFilesNotListed.add(openFilePath);
        }
        int n = openFilesMap.size() - openFilesNotListed.size();
        if (n >= expOpenFilesListSize) {
            return true;
        }
        LOG.info("Open files that are not listed yet: " + openFilesNotListed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOpenFilesBlockingDecommission(final HashSet<Path> closedFileSet, final HashMap<Path, FSDataOutputStream> openFilesMap, final int maxOpenFiles) throws Exception {
        PrintStream oldStreamOut = System.out;
        try {
            final ByteArrayOutputStream toolOut = new ByteArrayOutputStream();
            System.setOut(new PrintStream(toolOut));
            final DFSAdmin dfsAdmin = new DFSAdmin(this.getConf());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        boolean result1 = false;
                        boolean result2 = false;
                        toolOut.reset();
                        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission"}));
                        toolOut.flush();
                        result1 = TestDecommission.this.verifyOpenFilesListing("dfsadmin -listOpenFiles -blockingDecommission", closedFileSet, openFilesMap, toolOut, maxOpenFiles);
                        if (openFilesMap.size() > 0) {
                            String firstOpenFile = null;
                            HashMap<Path, FSDataOutputStream> newOpenFilesMap = new HashMap<Path, FSDataOutputStream>();
                            HashSet<Path> newClosedFileSet = new HashSet<Path>();
                            for (Map.Entry entry : openFilesMap.entrySet()) {
                                if (firstOpenFile == null) {
                                    newOpenFilesMap.put((Path)entry.getKey(), (FSDataOutputStream)entry.getValue());
                                    firstOpenFile = ((Path)entry.getKey()).toString();
                                    continue;
                                }
                                newClosedFileSet.add((Path)entry.getKey());
                            }
                            toolOut.reset();
                            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission", "-path", firstOpenFile}));
                            toolOut.flush();
                            result2 = TestDecommission.this.verifyOpenFilesListing("dfsadmin -listOpenFiles -blockingDecommission -path" + firstOpenFile, newClosedFileSet, newOpenFilesMap, toolOut, 1);
                        } else {
                            result2 = true;
                        }
                        return result1 && result2;
                    }
                    catch (Exception e) {
                        LOG.warn("Unexpected exception: " + e);
                        return false;
                    }
                }
            }, (long)1000L, (long)60000L);
        }
        finally {
            System.setOut(oldStreamOut);
        }
    }

    @Test(timeout=180000L)
    public void testDecommissionWithOpenfileReporting() throws Exception {
        LOG.info("Starting test testDecommissionWithOpenfileReporting");
        this.getConf().setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        this.getConf().setLong("dfs.namenode.list.openfiles.num.responses", 1L);
        this.startSimpleCluster(1, 4);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String[] closedFiles = new String[3];
        String[] openFiles = new String[3];
        HashSet<Path> closedFileSet = new HashSet<Path>();
        HashMap<Path, FSDataOutputStream> openFilesMap = new HashMap<Path, FSDataOutputStream>();
        for (int i = 0; i < 3; ++i) {
            closedFiles[i] = "/testDecommissionWithOpenfileReporting.closed." + i;
            openFiles[i] = "/testDecommissionWithOpenfileReporting.open." + i;
            TestDecommission.writeFile((FileSystem)fileSys, new Path(closedFiles[i]), 3, 10);
            closedFileSet.add(new Path(closedFiles[i]));
            TestDecommission.writeFile((FileSystem)fileSys, new Path(openFiles[i]), 3, 10);
            FSDataOutputStream fdos = fileSys.append(new Path(openFiles[i]));
            openFilesMap.put(new Path(openFiles[i]), fdos);
        }
        HashMap<DatanodeInfoWithStorage, Integer> dnInfoMap = new HashMap<DatanodeInfoWithStorage, Integer>();
        for (int i = 0; i < 3; ++i) {
            LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFiles[i], 0L, 81920L);
            for (DatanodeInfoWithStorage dn : lbs.getLastLocatedBlock().getLocations()) {
                if (dnInfoMap.containsKey(dn)) {
                    dnInfoMap.put(dn, (Integer)dnInfoMap.get(dn) + 1);
                    continue;
                }
                dnInfoMap.put(dn, 1);
            }
        }
        DatanodeInfo dnToDecommission = null;
        int maxDnOccurance = 0;
        for (Map.Entry entry : dnInfoMap.entrySet()) {
            if ((Integer)entry.getValue() <= maxDnOccurance) continue;
            maxDnOccurance = (Integer)entry.getValue();
            dnToDecommission = (DatanodeInfo)entry.getKey();
        }
        LOG.info("XXX Dn to decommission: " + dnToDecommission + ", max: " + maxDnOccurance);
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        ArrayList<String> nodes = new ArrayList<String>();
        dnToDecommission = dm.getDatanode(dnToDecommission.getDatanodeUuid());
        nodes.add(dnToDecommission.getXferAddr());
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        this.waitNodeState(dnToDecommission, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        this.verifyOpenFilesBlockingDecommission(closedFileSet, openFilesMap, maxDnOccurance);
        final AtomicBoolean stopRedundancyMonitor = new AtomicBoolean(false);
        Thread monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopRedundancyMonitor.get()) {
                    try {
                        BlockManagerTestUtil.checkRedundancy(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                        BlockManagerTestUtil.updateState(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        LOG.warn("Encountered exception during redundancy monitor: " + e);
                    }
                }
            }
        });
        monitorThread.start();
        this.waitNodeState(dnToDecommission, DatanodeInfo.AdminStates.DECOMMISSIONED);
        stopRedundancyMonitor.set(true);
        monitorThread.join();
        openFilesMap.clear();
        this.verifyOpenFilesBlockingDecommission(closedFileSet, openFilesMap, 0);
    }

    @Test(timeout=360000L)
    public void testDecommissionWithCloseFileAndListOpenFiles() throws Exception {
        LOG.info("Starting test testDecommissionWithCloseFileAndListOpenFiles");
        this.getConf().setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        this.getConf().setLong("dfs.namenode.list.openfiles.num.responses", 1L);
        this.startSimpleCluster(1, 3);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        Path file = new Path("/openFile");
        FSDataOutputStream st = AdminStatesBaseTest.writeIncompleteFile((FileSystem)fileSys, file, (short)3, (short)2);
        for (DataNode d : this.getCluster().getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), file.toUri().getPath(), 0L, 81920L);
        DatanodeInfoWithStorage dnToDecommission = lbs.getLastLocatedBlock().getLocations()[0];
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        dnToDecommission = dm.getDatanode(dnToDecommission.getDatanodeUuid());
        this.initExcludeHost(dnToDecommission.getXferAddr());
        this.refreshNodes(0);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.waitNodeState((DatanodeInfo)dnToDecommission, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        Thread.sleep(3000L);
        BatchedRemoteIterator.BatchedEntries batchedListEntries = this.getCluster().getNameNodeRpc(0).listOpenFiles(0L, EnumSet.of(OpenFilesIterator.OpenFilesType.BLOCKING_DECOMMISSION), "/");
        Assert.assertEquals((long)1L, (long)batchedListEntries.size());
        st.close();
        try {
            batchedListEntries = this.getCluster().getNameNodeRpc().listOpenFiles(0L, EnumSet.of(OpenFilesIterator.OpenFilesType.BLOCKING_DECOMMISSION), "/");
            Assert.assertEquals((long)0L, (long)batchedListEntries.size());
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Should not throw NPE when the file is not under construction but has lease!");
        }
        this.initExcludeHost("");
        this.refreshNodes(0);
        fileSys.delete(file, false);
    }

    @Test(timeout=360000L)
    public void testDecommissionWithOpenFileAndBlockRecovery() throws IOException, InterruptedException {
        long writtenBytes;
        this.startCluster(1, 6);
        this.getCluster().waitActive();
        Path file = new Path("/testRecoveryDecommission");
        DistributedFileSystem dfs = this.getCluster().getFileSystem();
        FSDataOutputStream out = dfs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
        for (writtenBytes = 0L; writtenBytes < 16384L; writtenBytes += 8L) {
            out.writeLong(writtenBytes);
        }
        out.hsync();
        DatanodeInfoWithStorage[] lastBlockLocations = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(), "/testRecoveryDecommission", 0L, 16384L).getLastLocatedBlock().getLocations();
        ArrayList<String> toDecom = new ArrayList<String>();
        for (DatanodeInfoWithStorage dnDecom : lastBlockLocations) {
            toDecom.add(dnDecom.getXferAddr());
        }
        this.initExcludeHosts(toDecom);
        this.refreshNodes(0);
        this.getCluster().setLeasePeriod(300L, 300L);
        Thread.sleep(2000L);
        for (DatanodeInfoWithStorage dnDecom : lastBlockLocations) {
            DatanodeDescriptor datanode = NameNodeAdapter.getDatanode(this.getCluster().getNamesystem(), (DatanodeID)dnDecom);
            this.waitNodeState((DatanodeInfo)datanode, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        Assert.assertEquals((long)dfs.getFileStatus(file).getLen(), (long)writtenBytes);
    }

    @Test(timeout=120000L)
    public void testCloseWhileDecommission() throws IOException, ExecutionException, InterruptedException {
        LOG.info("Starting test testCloseWhileDecommission");
        this.getConf().setInt("dfs.namenode.replication.min", 2);
        this.startCluster(1, 3);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        TestDecommission.writeFile((FileSystem)fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        byte[] bytes = new byte[1];
        fdos.write(bytes);
        fdos.hsync();
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfoWithStorage[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> dnInfos = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[0]));
        nodes.add(dnInfos4LastBlock[1].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[1]));
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        fdos.close();
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.assertTrackedAndPending(dm.getDatanodeAdminManager(), 2, 0);
    }

    @Test(timeout=120000L)
    public void testAllocAndIBRWhileDecommission() throws IOException {
        LOG.info("Starting test testAllocAndIBRWhileDecommission");
        this.startCluster(1, 6);
        this.getCluster().waitActive();
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        Path file = new Path("/testAllocAndIBRWhileDecommission");
        DistributedFileSystem dfs = this.getCluster().getFileSystem();
        FSDataOutputStream out = dfs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
        long writtenBytes = 0L;
        while (writtenBytes + 8L < 8192L) {
            out.writeLong(writtenBytes);
            writtenBytes += 8L;
        }
        out.hsync();
        LocatedBlock firstLocatedBlock = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(), "/testAllocAndIBRWhileDecommission", 0L, 16384L).getLastLocatedBlock();
        DatanodeInfoWithStorage[] firstBlockLocations = firstLocatedBlock.getLocations();
        ArrayList<String> toDecom = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> decomDNInfos = new ArrayList<DatanodeDescriptor>();
        for (DatanodeInfoWithStorage datanodeInfo : firstBlockLocations) {
            toDecom.add(datanodeInfo.getXferAddr());
            decomDNInfos.add(dm.getDatanode((DatanodeID)datanodeInfo));
            DataNode dn = this.getDataNode((DatanodeInfo)datanodeInfo);
            DataNodeTestUtils.triggerHeartbeat(dn);
            DataNodeTestUtils.pauseIBR(dn);
        }
        while (writtenBytes <= 8192L) {
            out.writeLong(writtenBytes);
            writtenBytes += 8L;
        }
        out.hsync();
        Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.COMMITTED, (Object)((BlockInfo)firstLocatedBlock.getBlock().getLocalBlock()).getBlockUCState());
        this.initExcludeHosts(toDecom);
        this.refreshNodes(0);
        for (DatanodeInfo datanodeInfo : decomDNInfos) {
            this.waitNodeState(datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            DataNodeTestUtils.resumeIBR(this.getDataNode(datanodeInfo));
        }
        for (DataNode dataNode : this.getCluster().getDataNodes()) {
            DataNodeTestUtils.triggerHeartbeat(dataNode);
        }
        Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.COMPLETE, (Object)((BlockInfo)firstLocatedBlock.getBlock().getLocalBlock()).getBlockUCState());
        out.close();
        this.shutdownCluster();
    }

    @Test(timeout=360000L)
    public void testDecommissionWithNamenodeRestart() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithNamenodeRestart");
        int numNamenodes = 1;
        int numDatanodes = 1;
        int replicas = 1;
        this.getConf().setLong("dfs.blockreport.intervalMsec", 21600000L);
        this.getConf().setLong("dfs.blockreport.initialDelay", 5L);
        this.startCluster(numNamenodes, numDatanodes);
        Path file1 = new Path("testDecommissionWithNamenodeRestart.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem();
        TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
        DFSClient client = this.getDfsClient(0);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo excludedDatanodeID = info[0];
        String excludedDatanodeName = info[0].getXferAddr();
        this.initExcludeHost(excludedDatanodeName);
        this.getCluster().startDataNodes(this.getConf(), 1, true, null, null, null, null);
        Assert.assertEquals((String)"Number of datanodes should be 2 ", (long)2L, (long)this.getCluster().getDataNodes().size());
        this.getCluster().restartNameNode(new String[0]);
        DatanodeDescriptor datanodeInfo = NameNodeAdapter.getDatanode(this.getCluster().getNamesystem(), (DatanodeID)excludedDatanodeID);
        this.waitNodeState((DatanodeInfo)datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        Assert.assertEquals((String)"All datanodes must be alive", (long)(++numDatanodes), (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertTrue((String)"Checked if block was replicated after decommission.", (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, datanodeInfo.getXferAddr(), numDatanodes) == null ? 1 : 0) != 0);
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        this.shutdownCluster();
        this.startCluster(numNamenodes, numDatanodes);
    }

    @Test(timeout=360000L)
    public void testDeadNodeCountAfterNamenodeRestart() throws Exception {
        LOG.info("Starting test testDeadNodeCountAfterNamenodeRestart");
        int numNamenodes = 1;
        int numDatanodes = 2;
        this.startCluster(numNamenodes, numDatanodes);
        DFSClient client = this.getDfsClient(0);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo excludedDatanode = info[0];
        String excludedDatanodeName = info[0].getXferAddr();
        ArrayList<String> hosts = new ArrayList<String>(Arrays.asList(excludedDatanodeName, info[1].getXferAddr()));
        this.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
        this.takeNodeOutofService(0, excludedDatanode.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.getCluster().stopDataNode(excludedDatanodeName);
        DFSTestUtil.waitForDatanodeState(this.getCluster(), excludedDatanode.getDatanodeUuid(), false, 20000);
        this.getCluster().restartNameNode(new String[0]);
        Assert.assertEquals((String)"There should be one node alive", (long)1L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertEquals((String)"There should be one node dead", (long)1L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD).length);
    }

    @Ignore
    @Test(timeout=360000L)
    public void testIncludeByRegistrationName() throws Exception {
        String registrationName = "127.0.0.100";
        String nonExistentDn = "127.0.0.10";
        this.getConf().set("dfs.datanode.hostname", "127.0.0.100");
        this.startCluster(1, 1, false, null, true);
        this.initIncludeHost("127.0.0.10");
        this.refreshNodes(0);
        LOG.info("Waiting for DN to be marked as dead.");
        final DFSClient client = this.getDfsClient(0);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                try {
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
                    return info.length == 1;
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                    return false;
                }
            }
        }, (long)500L, (long)5000L);
        int dnPort = this.getCluster().getDataNodes().get(0).getXferPort();
        this.initIncludeHost("127.0.0.100:" + dnPort);
        this.refreshNodes(0);
        this.getCluster().restartDataNode(0);
        this.getCluster().triggerHeartbeats();
        LOG.info("Waiting for DN to come back.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                try {
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                    if (info.length == 1) {
                        Assert.assertFalse((boolean)info[0].isDecommissioned());
                        Assert.assertFalse((boolean)info[0].isDecommissionInProgress());
                        Assert.assertEquals((Object)"127.0.0.100", (Object)info[0].getHostName());
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                }
                return false;
            }
        }, (long)500L, (long)5000L);
    }

    @Test(timeout=120000L)
    public void testBlocksPerInterval() throws Exception {
        org.apache.log4j.Logger.getLogger(DatanodeAdminManager.class).setLevel(Level.TRACE);
        this.getConf().setInt("dfs.namenode.decommission.blocks.per.interval", 3);
        this.getConf().setInt("dfs.namenode.decommission.interval.testing", Integer.MAX_VALUE);
        this.startCluster(1, 3);
        DistributedFileSystem fs = this.getCluster().getFileSystem();
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file1"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 3);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file2"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 2);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file3"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file4"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
    }

    private void doDecomCheck(DatanodeManager datanodeManager, DatanodeAdminManager decomManager, int expectedNumCheckedNodes) throws IOException, ExecutionException, InterruptedException {
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (DataNode d : this.getCluster().getDataNodes()) {
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        Assert.assertEquals((String)"Unexpected # of nodes checked", (long)expectedNumCheckedNodes, (long)decomManager.getNumNodesChecked());
        for (DatanodeInfo dn : decommissionedNodes) {
            this.putNodeInService(0, dn);
        }
    }

    @Test(timeout=120000L)
    public void testPendingNodeButDecommissioned() throws Exception {
        this.getConf().setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 1);
        this.getConf().setInt("dfs.namenode.decommission.interval.testing", Integer.MAX_VALUE);
        this.startCluster(1, 2);
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        ArrayList decommissionedNodes = Lists.newArrayList();
        ArrayList<DataNode> dns = this.getCluster().getDataNodes();
        for (int i = 0; i < 2; ++i) {
            DataNode d = (DataNode)dns.get(i);
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        Assert.assertEquals((long)2L, (long)decomManager.getNumPendingNodes());
        DatanodeDescriptor dn = datanodeManager.getDatanode(((DataNode)dns.get(0)).getDatanodeId());
        dn.setDecommissioned();
        try {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            GenericTestUtils.waitFor(() -> decomManager.getNumTrackedNodes() == 0, (long)500L, (long)30000L);
            Assert.assertTrue((boolean)GenericTestUtils.anyThreadMatching((Pattern)Pattern.compile("DatanodeAdminMonitor-.*")));
        }
        catch (ExecutionException e) {
            GenericTestUtils.assertExceptionContains((String)"in an invalid state!", (Throwable)e);
            Assert.fail((String)"DatanodeAdminManager#monitor does not swallow exceptions.");
        }
    }

    @Test(timeout=120000L)
    public void testPendingNodes() throws Exception {
        int i;
        org.apache.log4j.Logger.getLogger(DatanodeAdminManager.class).setLevel(Level.TRACE);
        this.getConf().setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 1);
        this.getConf().setInt("dfs.namenode.decommission.interval.testing", Integer.MAX_VALUE);
        this.startCluster(1, 3);
        DistributedFileSystem fs = this.getCluster().getFileSystem();
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        HdfsDataOutputStream open1 = (HdfsDataOutputStream)fs.create(new Path("/openFile1"), (short)3);
        open1.write(123);
        open1.hflush();
        for (DataNode d : this.getCluster().getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            DataNode d = this.getCluster().getDataNodes().get(i);
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        for (i = 2; i >= 0; --i) {
            this.assertTrackedAndPending(decomManager, 0, i);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        }
        open1.close();
        DataNode d = this.getCluster().getDataNodes().get(2);
        DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        decommissionedNodes.add(dn);
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        this.assertTrackedAndPending(decomManager, 1, 0);
    }

    private void assertTrackedAndPending(DatanodeAdminManager decomManager, int tracked, int pending) {
        Assert.assertEquals((String)"Unexpected number of tracked nodes", (long)tracked, (long)decomManager.getNumTrackedNodes());
        Assert.assertEquals((String)"Unexpected number of pending nodes", (long)pending, (long)decomManager.getNumPendingNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountOnDecommissionedNodeList() throws IOException {
        this.getConf().setInt("dfs.heartbeat.interval", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        try {
            this.startCluster(1, 1);
            ArrayList namenodeDecomList = new ArrayList(1);
            namenodeDecomList.add(0, new ArrayList(1));
            ArrayList decommissionedNode = (ArrayList)namenodeDecomList.get(0);
            this.takeNodeOutofService(0, null, 0L, decommissionedNode, DatanodeInfo.AdminStates.DECOMMISSIONED);
            FSNamesystem ns = this.getCluster().getNamesystem(0);
            DatanodeManager datanodeManager = ns.getBlockManager().getDatanodeManager();
            ArrayList live = new ArrayList();
            datanodeManager.fetchDatanodes(live, null, false);
            Assert.assertTrue((1 == live.size() ? 1 : 0) != 0);
            datanodeManager.fetchDatanodes(live, null, true);
            Assert.assertTrue((0 == live.size() ? 1 : 0) != 0);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test
    public void testNodeUsageAfterDecommissioned() throws IOException, InterruptedException {
        this.nodeUsageVerification(2, new long[]{26384L, 26384L}, DatanodeInfo.AdminStates.DECOMMISSIONED);
    }

    @Test
    public void testNodeUsageWhileDecommissioining() throws IOException, InterruptedException {
        this.nodeUsageVerification(1, new long[]{26384L}, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUsageVerification(int numDatanodes, long[] nodesCapacity, DatanodeInfo.AdminStates decommissionState) throws IOException, InterruptedException {
        Map usage = null;
        DatanodeInfo decommissionedNodeInfo = null;
        String zeroNodeUsage = "0.00%";
        this.getConf().setInt("dfs.replication", 1);
        this.getConf().setInt("dfs.heartbeat.interval", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        DistributedFileSystem fileSys = null;
        Path file1 = new Path("testNodeUsage.dat");
        try {
            SimulatedFSDataset.setFactory(this.getConf());
            this.startCluster(1, numDatanodes, false, nodesCapacity, false);
            ArrayList namenodeDecomList = new ArrayList(1);
            namenodeDecomList.add(0, new ArrayList(numDatanodes));
            if (decommissionState == DatanodeInfo.AdminStates.DECOMMISSIONED) {
                ArrayList decommissionedNode = (ArrayList)namenodeDecomList.get(0);
                decommissionedNodeInfo = this.takeNodeOutofService(0, null, 0L, decommissionedNode, decommissionState);
            }
            fileSys = this.getCluster().getFileSystem(0);
            FSNamesystem ns = this.getCluster().getNamesystem(0);
            TestDecommission.writeFile((FileSystem)fileSys, file1, 1);
            Thread.sleep(2000L);
            usage = (Map)JSON.parse((String)ns.getNodeUsage());
            String minUsageBeforeDecom = (String)((Map)usage.get("nodeUsage")).get("min");
            Assert.assertTrue((!minUsageBeforeDecom.equalsIgnoreCase(zeroNodeUsage) ? 1 : 0) != 0);
            if (decommissionState == DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS) {
                ArrayList decommissioningNodes = (ArrayList)namenodeDecomList.get(0);
                decommissionedNodeInfo = this.takeNodeOutofService(0, null, 0L, decommissioningNodes, decommissionState);
                usage = (Map)JSON.parse((String)ns.getNodeUsage());
                Assert.assertTrue((boolean)((String)((Map)usage.get("nodeUsage")).get("min")).equalsIgnoreCase(zeroNodeUsage));
            }
            this.putNodeInService(0, decommissionedNodeInfo);
            usage = (Map)JSON.parse((String)ns.getNodeUsage());
            String nodeusageAfterRecommi = decommissionState == DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS ? minUsageBeforeDecom : zeroNodeUsage;
            Assert.assertTrue((boolean)((String)((Map)usage.get("nodeUsage")).get("min")).equalsIgnoreCase(nodeusageAfterRecommi));
        }
        catch (Throwable throwable) {
            TestDecommission.cleanupFile(fileSys, file1);
            throw throwable;
        }
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
    }

    @Test
    public void testUsedCapacity() throws Exception {
        int numNamenodes = 1;
        int numDatanodes = 2;
        this.startCluster(numNamenodes, numDatanodes);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        BlockManager blockManager = ns.getBlockManager();
        DatanodeStatistics datanodeStatistics = blockManager.getDatanodeManager().getDatanodeStatistics();
        long initialUsedCapacity = datanodeStatistics.getCapacityUsed();
        long initialTotalCapacity = datanodeStatistics.getCapacityTotal();
        long initialBlockPoolUsed = datanodeStatistics.getBlockPoolUsed();
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DatanodeInfo decomNode = this.takeNodeOutofService(0, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        long newUsedCapacity = datanodeStatistics.getCapacityUsed();
        long newTotalCapacity = datanodeStatistics.getCapacityTotal();
        long newBlockPoolUsed = datanodeStatistics.getBlockPoolUsed();
        Assert.assertTrue((String)"DfsUsedCapacity should not be the same after a node has been decommissioned!", (initialUsedCapacity != newUsedCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)"TotalCapacity should not be the same after a node has been decommissioned!", (initialTotalCapacity != newTotalCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)"BlockPoolUsed should not be the same after a node has been decommissioned!", (initialBlockPoolUsed != newBlockPoolUsed ? 1 : 0) != 0);
    }

    @Test(timeout=360000L)
    public void testMultipleNodesDecommission() throws Exception {
        this.startCluster(1, 5);
        Path file = new Path("/testMultipleNodesDecommission.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        int repl = 3;
        TestDecommission.writeFile((FileSystem)fileSys, file, repl, 1);
        List<DatanodeInfo> decomDataNodes = this.takeNodeOutofService(0, Lists.newArrayList((Object[])new String[]{this.getCluster().getDataNodes().get(0).getDatanodeUuid(), this.getCluster().getDataNodes().get(1).getDatanodeUuid()}), Long.MAX_VALUE, null, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>((FileSystem)fileSys, file, repl, decomDataNodes){
            final /* synthetic */ FileSystem val$fileSys;
            final /* synthetic */ Path val$file;
            final /* synthetic */ int val$repl;
            final /* synthetic */ List val$decomDataNodes;
            {
                this.val$fileSys = fileSystem;
                this.val$file = path;
                this.val$repl = n;
                this.val$decomDataNodes = list;
            }

            @Override
            public Boolean get() {
                try {
                    String errMsg = TestDecommission.checkFile(this.val$fileSys, this.val$file, this.val$repl, ((DatanodeInfo)this.val$decomDataNodes.get(0)).getXferAddr(), 5);
                    if (errMsg != null) {
                        LOG.warn("Check file: " + errMsg);
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.warn("Check file: " + e);
                    return false;
                }
            }
        }, (long)500L, (long)30000L);
        for (DatanodeInfo datanodeInfo : decomDataNodes) {
            this.putNodeInService(0, datanodeInfo);
        }
        TestDecommission.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=120000L)
    public void testRequeueUnhealthyDecommissioningNodes() throws Exception {
        int numLiveNodes = 3;
        int numDeadNodes = 2;
        int numNodes = 5;
        ArrayList<DatanodeDescriptor> liveNodes = new ArrayList<DatanodeDescriptor>();
        HashMap<DatanodeDescriptor, MiniDFSCluster.DataNodeProperties> deadNodeProps = new HashMap<DatanodeDescriptor, MiniDFSCluster.DataNodeProperties>();
        ArrayList<DatanodeInfo> decommissionedNodes = new ArrayList<DatanodeInfo>();
        Path filePath = new Path("/tmp/test");
        this.createClusterWithDeadNodesDecommissionInProgress(3, liveNodes, 2, deadNodeProps, decommissionedNodes, filePath);
        FSNamesystem namesystem = this.getCluster().getNamesystem();
        BlockManager blockManager = namesystem.getBlockManager();
        DatanodeManager datanodeManager = blockManager.getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        Duration checkDuration = Duration.ofSeconds(5L);
        Instant checkUntil = Instant.now().plus(checkDuration);
        while (Instant.now().isBefore(checkUntil)) {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            Assert.assertEquals((String)"Unexpected number of decommissioning nodes queued in DatanodeAdminManager.", (long)0L, (long)decomManager.getNumPendingNodes());
            Assert.assertEquals((String)"Unexpected number of decommissioning nodes tracked in DatanodeAdminManager.", (long)2L, (long)decomManager.getNumTrackedNodes());
            Assert.assertTrue((String)"Dead decommissioning nodes unexpectedly transitioned out of DECOMMISSION_INPROGRESS.", (boolean)deadNodeProps.keySet().stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS)));
            Thread.sleep(500L);
        }
        this.getCluster().getFileSystem().delete(filePath, true);
        int numLiveDecommNodes = 2;
        List liveDecommNodes = liveNodes.subList(0, numLiveDecommNodes);
        for (DatanodeDescriptor liveNode : liveDecommNodes) {
            this.takeNodeOutofService(0, liveNode.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add((DatanodeInfo)liveNode);
        }
        TestDecommission.writeFile((FileSystem)this.getCluster().getFileSystem(), filePath, 5, 10);
        GenericTestUtils.waitFor(() -> decomManager.getNumTrackedNodes() == 2 && decomManager.getNumPendingNodes() == numLiveDecommNodes && liveDecommNodes.stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS)), (long)500L, (long)30000L);
        ((ListAssert)Assertions.assertThat(liveDecommNodes).as("Check all live decommissioning nodes queued in DatanodeAdminManager", new Object[0])).containsAll((Iterable)decomManager.getPendingNodes());
        if (this instanceof TestDecommissionWithBackoffMonitor) {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            Assert.assertEquals((String)"DatanodeAdminBackoffMonitor did not re-queue dead decommissioning nodes as expected.", (long)2L, (long)decomManager.getNumPendingNodes());
            Assert.assertEquals((String)"DatanodeAdminBackoffMonitor did not re-queue dead decommissioning nodes as expected.", (long)0L, (long)decomManager.getNumTrackedNodes());
        } else {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            Assert.assertEquals((String)"DatanodeAdminDefaultMonitor did not re-queue dead decommissioning nodes as expected.", (long)4L, (long)decomManager.getNumPendingNodes());
            Assert.assertEquals((String)"DatanodeAdminDefaultMonitor did not re-queue dead decommissioning nodes as expected.", (long)0L, (long)decomManager.getNumTrackedNodes());
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            Assert.assertEquals((String)"DatanodeAdminDefaultMonitor did not decommission live nodes as expected.", (long)2L, (long)decomManager.getNumPendingNodes());
            Assert.assertEquals((String)"DatanodeAdminDefaultMonitor did not decommission live nodes as expected.", (long)0L, (long)decomManager.getNumTrackedNodes());
        }
        Assert.assertTrue((String)"Live nodes not DECOMMISSIONED as expected.", (boolean)liveDecommNodes.stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED)));
        Assert.assertTrue((String)"Dead nodes not DECOMMISSION_INPROGRESS as expected.", (boolean)deadNodeProps.keySet().stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS)));
        ((IterableAssert)Assertions.assertThat(deadNodeProps.keySet()).as("Check all dead decommissioning nodes queued in DatanodeAdminManager", new Object[0])).containsAll((Iterable)decomManager.getPendingNodes());
        checkUntil = Instant.now().plus(checkDuration);
        while (Instant.now().isBefore(checkUntil)) {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            Assert.assertEquals((String)"Unexpected number of decommissioning nodes queued in DatanodeAdminManager.", (long)0L, (long)decomManager.getNumPendingNodes());
            Assert.assertEquals((String)"Unexpected number of decommissioning nodes tracked in DatanodeAdminManager.", (long)2L, (long)decomManager.getNumTrackedNodes());
            Assert.assertTrue((String)"Dead decommissioning nodes unexpectedly transitioned out of DECOMMISSION_INPROGRESS.", (boolean)deadNodeProps.keySet().stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS)));
            Thread.sleep(500L);
        }
        this.getCluster().getFileSystem().delete(filePath, true);
        GenericTestUtils.waitFor(() -> {
            try {
                BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception running DatanodeAdminMonitor", (Throwable)e);
                return false;
            }
            return decomManager.getNumTrackedNodes() == 0 && decomManager.getNumPendingNodes() == 0 && deadNodeProps.keySet().stream().allMatch(node -> node.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        }, (long)500L, (long)30000L);
    }

    private void createClusterWithDeadNodesDecommissionInProgress(int numLiveNodes, List<DatanodeDescriptor> liveNodes, int numDeadNodes, Map<DatanodeDescriptor, MiniDFSCluster.DataNodeProperties> deadNodeProps, ArrayList<DatanodeInfo> decommissionedNodes, Path filePath) throws Exception {
        Assert.assertTrue((String)"Must have numLiveNode > 0", (numLiveNodes > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Must have numDeadNode > 0", (numDeadNodes > 0 ? 1 : 0) != 0);
        int numNodes = numLiveNodes + numDeadNodes;
        this.getConf().setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", numDeadNodes);
        this.getConf().setInt("dfs.namenode.decommission.interval.testing", Integer.MAX_VALUE);
        this.startCluster(1, numNodes);
        FSNamesystem namesystem = this.getCluster().getNamesystem();
        BlockManager blockManager = namesystem.getBlockManager();
        DatanodeManager datanodeManager = blockManager.getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        Assert.assertEquals((long)numNodes, (long)this.getCluster().getDataNodes().size());
        this.getCluster().waitActive();
        for (DataNode node : this.getCluster().getDataNodes().subList(0, numLiveNodes)) {
            liveNodes.add(TestDecommission.getDatanodeDesriptor(namesystem, node.getDatanodeUuid()));
        }
        Assert.assertEquals((long)numLiveNodes, (long)liveNodes.size());
        List deadNodes = this.getCluster().getDataNodes().subList(numLiveNodes, numNodes).stream().map(dn -> TestDecommission.getDatanodeDesriptor(namesystem, dn.getDatanodeUuid())).collect(Collectors.toList());
        Assert.assertEquals((long)numDeadNodes, (long)deadNodes.size());
        TestDecommission.writeFile((FileSystem)this.getCluster().getFileSystem(), filePath, numNodes, 10);
        for (DatanodeDescriptor deadNode : deadNodes) {
            this.takeNodeOutofService(0, deadNode.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add((DatanodeInfo)deadNode);
            MiniDFSCluster.DataNodeProperties dn2 = this.getCluster().stopDataNode(deadNode.getXferAddr());
            deadNodeProps.put(deadNode, dn2);
            deadNode.setLastUpdate(213L);
        }
        Assert.assertEquals((long)numDeadNodes, (long)deadNodeProps.size());
        GenericTestUtils.waitFor(() -> decomManager.getNumTrackedNodes() == 0 && decomManager.getNumPendingNodes() == numDeadNodes && deadNodes.stream().allMatch(node -> !BlockManagerTestUtil.isNodeHealthyForDecommissionOrMaintenance(blockManager, node) && !node.isAlive()), (long)500L, (long)20000L);
    }

    @Test(timeout=60000L)
    public void testDeleteCorruptReplicaForUnderReplicatedBlock() throws Exception {
        Path file = new Path("/test-file");
        int numDatanode = 3;
        int replicationFactor = 2;
        int numStoppedNodes = 2;
        boolean numDecommNodes = true;
        Assert.assertEquals((long)3L, (long)3L);
        int datanodeAdminMonitorFixedRateSeconds = 5;
        this.getConf().setInt("dfs.namenode.decommission.interval.testing", 5);
        this.getConf().setLong("dfs.blockreport.intervalMsec", 21600000L);
        this.getConf().setLong("dfs.namenode.redundancy.interval.seconds", 3L);
        this.getConf().set("dfs.client.block.write.replace-datanode-on-failure.policy", "ALWAYS");
        this.getConf().setBoolean("dfs.client.block.write.replace-datanode-on-failure.best-effort", true);
        ArrayList<DatanodeDescriptor> allNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> stoppedNodes = new ArrayList<DatanodeDescriptor>();
        this.startCluster(1, 3);
        this.getCluster().waitActive();
        FSNamesystem namesystem = this.getCluster().getNamesystem();
        BlockManager blockManager = namesystem.getBlockManager();
        DatanodeManager datanodeManager = blockManager.getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        DistributedFileSystem fs = this.getCluster().getFileSystem();
        for (DataNode node : this.getCluster().getDataNodes()) {
            allNodes.add(TestDecommission.getDatanodeDesriptor(namesystem, node.getDatanodeUuid()));
        }
        LOG.info("Creating Initial Block with {} FINALIZED replicas", (Object)2);
        FSDataOutputStream out = fs.create(file, (short)2);
        for (int i = 0; i < 512; ++i) {
            out.write(i);
        }
        out.close();
        Assert.assertEquals((long)1L, (long)blockManager.getTotalBlocks());
        BlockLocation[] blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
        Assert.assertEquals((long)1L, (long)blocksInFile.length);
        List<String> replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
        Assert.assertEquals((long)2L, (long)replicasInBlock.size());
        DatanodeDescriptor decommNodeTmp = null;
        for (DatanodeDescriptor node : allNodes) {
            if (replicasInBlock.contains(node.getName())) {
                stoppedNodes.add(node);
                continue;
            }
            decommNodeTmp = node;
        }
        Assert.assertEquals((long)2L, (long)stoppedNodes.size());
        Assert.assertNotNull(decommNodeTmp);
        DatanodeDescriptor decommNode = decommNodeTmp;
        DatanodeDescriptor firstStoppedNode = (DatanodeDescriptor)stoppedNodes.get(0);
        DatanodeDescriptor secondStoppedNode = (DatanodeDescriptor)stoppedNodes.get(1);
        LOG.info("Detected 2 nodes with replicas : {} , {}", (Object)firstStoppedNode.getXferAddr(), (Object)secondStoppedNode.getXferAddr());
        LOG.info("Detected 1 node without replica : {}", (Object)decommNode.getXferAddr());
        LOG.info("Stopping first node with replica {}", (Object)firstStoppedNode.getXferAddr());
        ArrayList<MiniDFSCluster.DataNodeProperties> stoppedNodeProps = new ArrayList<MiniDFSCluster.DataNodeProperties>();
        MiniDFSCluster.DataNodeProperties stoppedNodeProp = this.getCluster().stopDataNode(firstStoppedNode.getXferAddr());
        stoppedNodeProps.add(stoppedNodeProp);
        firstStoppedNode.setLastUpdate(213L);
        GenericTestUtils.waitFor(() -> 2 == datanodeManager.getNumLiveDataNodes() && 1 == datanodeManager.getNumDeadDataNodes(), (long)500L, (long)30000L);
        this.appendBlock((FileSystem)fs, file, 2);
        LOG.info("Stopping second node with replica {}", (Object)secondStoppedNode.getXferAddr());
        stoppedNodeProp = this.getCluster().stopDataNode(secondStoppedNode.getXferAddr());
        stoppedNodeProps.add(stoppedNodeProp);
        secondStoppedNode.setLastUpdate(213L);
        GenericTestUtils.waitFor(() -> 1 == datanodeManager.getNumLiveDataNodes() && 2 == datanodeManager.getNumDeadDataNodes(), (long)500L, (long)30000L);
        this.appendBlock((FileSystem)fs, file, 1);
        blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
        Assert.assertEquals((long)1L, (long)blocksInFile.length);
        replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
        Assert.assertEquals((long)1L, (long)replicasInBlock.size());
        Assert.assertTrue((boolean)replicasInBlock.contains(decommNode.getName()));
        LOG.info("Block now has 2 corrupt replicas on [{} , {}] and 1 live replica on {}", new Object[]{firstStoppedNode.getXferAddr(), secondStoppedNode.getXferAddr(), decommNode.getXferAddr()});
        LOG.info("Decommission node {} with the live replica", (Object)decommNode.getXferAddr());
        ArrayList<DatanodeInfo> decommissionedNodes = new ArrayList<DatanodeInfo>();
        this.takeNodeOutofService(0, decommNode.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        try {
            GenericTestUtils.waitFor(() -> decomManager.getNumTrackedNodes() == 0 && decomManager.getNumPendingNodes() == 1 && decommNode.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), (long)500L, (long)30000L);
        }
        catch (Exception e) {
            blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
            Assert.assertEquals((long)1L, (long)blocksInFile.length);
            replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
            String errMsg = String.format("Node %s failed to start decommissioning. numTrackedNodes=%d , numPendingNodes=%d , adminState=%s , nodesWithReplica=[%s]", decommNode.getXferAddr(), decomManager.getNumTrackedNodes(), decomManager.getNumPendingNodes(), decommNode.getAdminState(), String.join((CharSequence)", ", replicasInBlock));
            LOG.error(errMsg);
            Assert.fail((String)errMsg);
        }
        blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
        Assert.assertEquals((long)1L, (long)blocksInFile.length);
        replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
        Assert.assertEquals((long)1L, (long)replicasInBlock.size());
        Assert.assertEquals((Object)replicasInBlock.get(0), (Object)decommNode.getName());
        LOG.info("Block now has 2 corrupt replicas on [{} , {}] and 1 decommissioning replica on {}", new Object[]{firstStoppedNode.getXferAddr(), secondStoppedNode.getXferAddr(), decommNode.getXferAddr()});
        LOG.info("Restarting stopped nodes {} , {}", (Object)firstStoppedNode.getXferAddr(), (Object)secondStoppedNode.getXferAddr());
        for (MiniDFSCluster.DataNodeProperties stoppedNode : stoppedNodeProps) {
            Assert.assertTrue((boolean)this.getCluster().restartDataNode(stoppedNode));
        }
        for (MiniDFSCluster.DataNodeProperties stoppedNode : stoppedNodeProps) {
            try {
                this.getCluster().waitDatanodeFullyStarted(stoppedNode.getDatanode(), 30000);
                LOG.info("Node {} Restarted", (Object)stoppedNode.getDatanode().getXferAddress());
            }
            catch (Exception e) {
                String errMsg = String.format("Node %s Failed to Restart within 30 seconds", stoppedNode.getDatanode().getXferAddress());
                LOG.error(errMsg);
                Assert.fail((String)errMsg);
            }
        }
        for (MiniDFSCluster.DataNodeProperties dnProps : stoppedNodeProps) {
            DataNodeTestUtils.triggerBlockReport(dnProps.getDatanode());
        }
        int checkEveryMillis = 10000;
        try {
            GenericTestUtils.waitFor(() -> {
                blockManager.clearQueues();
                return decomManager.getNumTrackedNodes() == 0 && decomManager.getNumPendingNodes() == 0 && decommNode.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED);
            }, (long)10000L, (long)40000L);
        }
        catch (Exception e) {
            blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
            Assert.assertEquals((long)1L, (long)blocksInFile.length);
            replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
            String errMsg = String.format("Node %s failed to complete decommissioning. numTrackedNodes=%d , numPendingNodes=%d , adminState=%s , nodesWithReplica=[%s]", decommNode.getXferAddr(), decomManager.getNumTrackedNodes(), decomManager.getNumPendingNodes(), decommNode.getAdminState(), String.join((CharSequence)", ", replicasInBlock));
            LOG.error(errMsg);
            Assert.fail((String)errMsg);
        }
        blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
        Assert.assertEquals((long)1L, (long)blocksInFile.length);
        replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
        Assert.assertEquals((long)3L, (long)replicasInBlock.size());
        Assert.assertTrue((boolean)replicasInBlock.contains(decommNode.getName()));
        for (DatanodeDescriptor node : stoppedNodes) {
            Assert.assertTrue((boolean)replicasInBlock.contains(node.getName()));
        }
        LOG.info("Block now has 2 live replicas on [{} , {}] and 1 decommissioned replica on {}", new Object[]{firstStoppedNode.getXferAddr(), secondStoppedNode.getXferAddr(), decommNode.getXferAddr()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendBlock(FileSystem fs, Path file, int expectedReplicas) throws IOException {
        LOG.info("Appending to the block pipeline");
        boolean failed = false;
        Exception failedReason = null;
        try {
            FSDataOutputStream out = fs.append(file);
            for (int i = 0; i < 512; ++i) {
                out.write(i);
            }
            out.close();
        }
        catch (Exception e) {
            try {
                failed = true;
                failedReason = e;
            }
            catch (Throwable throwable) {
                BlockLocation[] blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
                Assert.assertEquals((long)1L, (long)blocksInFile.length);
                List<String> replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
                if (failed) {
                    String errMsg = String.format("Unexpected exception appending to the block pipeline. nodesWithReplica=[%s]", String.join((CharSequence)", ", replicasInBlock));
                    LOG.error(errMsg, (Throwable)failedReason);
                    Assert.fail((String)errMsg);
                } else if (expectedReplicas != replicasInBlock.size()) {
                    String errMsg = String.format("Expecting %d replicas in block pipeline, unexpectedly found %d replicas. nodesWithReplica=[%s]", expectedReplicas, replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
                    LOG.error(errMsg);
                    Assert.fail((String)errMsg);
                } else {
                    String infoMsg = String.format("Successfully appended block pipeline with %d replicas. nodesWithReplica=[%s]", replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
                    LOG.info(infoMsg);
                }
                throw throwable;
            }
            BlockLocation[] blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
            Assert.assertEquals((long)1L, (long)blocksInFile.length);
            List<String> replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
            if (failed) {
                String errMsg = String.format("Unexpected exception appending to the block pipeline. nodesWithReplica=[%s]", String.join((CharSequence)", ", replicasInBlock));
                LOG.error(errMsg, (Throwable)failedReason);
                Assert.fail((String)errMsg);
            } else if (expectedReplicas != replicasInBlock.size()) {
                String errMsg = String.format("Expecting %d replicas in block pipeline, unexpectedly found %d replicas. nodesWithReplica=[%s]", expectedReplicas, replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
                LOG.error(errMsg);
                Assert.fail((String)errMsg);
            } else {
                String infoMsg = String.format("Successfully appended block pipeline with %d replicas. nodesWithReplica=[%s]", replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
                LOG.info(infoMsg);
            }
        }
        BlockLocation[] blocksInFile = fs.getFileBlockLocations(file, 0L, 0L);
        Assert.assertEquals((long)1L, (long)blocksInFile.length);
        List<String> replicasInBlock = Arrays.asList(blocksInFile[0].getNames());
        if (failed) {
            String errMsg = String.format("Unexpected exception appending to the block pipeline. nodesWithReplica=[%s]", String.join((CharSequence)", ", replicasInBlock));
            LOG.error(errMsg, (Throwable)failedReason);
            Assert.fail((String)errMsg);
        } else if (expectedReplicas != replicasInBlock.size()) {
            String errMsg = String.format("Expecting %d replicas in block pipeline, unexpectedly found %d replicas. nodesWithReplica=[%s]", expectedReplicas, replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
            LOG.error(errMsg);
            Assert.fail((String)errMsg);
        } else {
            String infoMsg = String.format("Successfully appended block pipeline with %d replicas. nodesWithReplica=[%s]", replicasInBlock.size(), String.join((CharSequence)", ", replicasInBlock));
            LOG.info(infoMsg);
        }
    }
}

