/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProxyCA {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyCA.class);
    private X509Certificate caCert;
    private KeyPair caKeyPair;
    private KeyStore childTrustStore;
    private final Random srand = new SecureRandom();
    private X509TrustManager defaultTrustManager;
    private X509KeyManager x509KeyManager;
    private HostnameVerifier hostnameVerifier;
    private static String ALG_NAME = "SHA512WITHRSA";

    public ProxyCA() {
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
    }

    public void init() throws GeneralSecurityException, IOException {
        this.createCACertAndKeyPair();
        this.initInternal();
    }

    public void init(X509Certificate caCert, PrivateKey caPrivateKey) throws GeneralSecurityException, IOException {
        if (caCert == null || caPrivateKey == null || !this.verifyCertAndKeys(caCert, caPrivateKey)) {
            LOG.warn("Could not verify Certificate, Public Key, and Private Key: regenerating");
            this.createCACertAndKeyPair();
        } else {
            this.caCert = caCert;
            this.caKeyPair = new KeyPair(caCert.getPublicKey(), caPrivateKey);
        }
        this.initInternal();
    }

    private void initInternal() throws GeneralSecurityException, IOException {
        this.defaultTrustManager = null;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        for (TrustManager manager : factory.getTrustManagers()) {
            if (!(manager instanceof X509TrustManager)) continue;
            this.defaultTrustManager = (X509TrustManager)manager;
            break;
        }
        if (this.defaultTrustManager == null) {
            throw new YarnRuntimeException("Could not find default X509 Trust Manager");
        }
        this.x509KeyManager = this.createKeyManager();
        this.hostnameVerifier = this.createHostnameVerifier();
        this.childTrustStore = this.createTrustStore("client", this.caCert);
    }

    private X509Certificate createCert(boolean isCa, String issuerStr, String subjectStr, Date from, Date to, PublicKey publicKey, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        ContentSigner contentSigner;
        X500Name issuer = new X500Name(issuerStr);
        X500Name subject = new X500Name(subjectStr);
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, new BigInteger(64, this.srand), from, to, subject, subPubKeyInfo);
        try {
            contentSigner = new JcaContentSignerBuilder(ALG_NAME).build(privateKey);
        }
        catch (OperatorCreationException oce) {
            throw new GeneralSecurityException(oce);
        }
        if (isCa) {
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        } else {
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(this.caCert));
        }
        X509CertificateHolder certHolder = certBuilder.build(contentSigner);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BCFIPS").getCertificate(certHolder);
        LOG.info("Created Certificate for {}", (Object)subject);
        return cert;
    }

    private void createCACertAndKeyPair() throws GeneralSecurityException, IOException {
        Date from = new Date();
        Date to = new GregorianCalendar(2037, 11, 31).getTime();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        this.caKeyPair = keyGen.genKeyPair();
        String subject = "OU=YARN-" + UUID.randomUUID();
        this.caCert = this.createCert(true, subject, subject, from, to, this.caKeyPair.getPublic(), this.caKeyPair.getPrivate());
        LOG.debug("CA Certificate: \n{}", (Object)this.caCert);
    }

    public byte[] createChildKeyStore(ApplicationId appId, String ksPassword) throws Exception {
        Date from;
        Date to = from = new Date();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        String issuer = this.caCert.getSubjectX500Principal().getName();
        String subject = "CN=" + appId;
        X509Certificate cert = this.createCert(false, issuer, subject, from, to, keyPair.getPublic(), this.caKeyPair.getPrivate());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate for {}: \n{}", (Object)appId, (Object)cert);
        }
        KeyStore keyStore = this.createChildKeyStore(ksPassword, "server", keyPair.getPrivate(), cert);
        return this.keyStoreToBytes(keyStore, ksPassword);
    }

    public byte[] getChildTrustStore(String password) throws GeneralSecurityException, IOException {
        return this.keyStoreToBytes(this.childTrustStore, password);
    }

    private KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    private KeyStore createChildKeyStore(String password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = this.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{cert, this.caCert});
        return ks;
    }

    public String generateKeyStorePassword() {
        return RandomStringUtils.random((int)16, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.srand);
    }

    private byte[] keyStoreToBytes(KeyStore ks, String password) throws GeneralSecurityException, IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ks.store(out, password.toCharArray());
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private KeyStore createTrustStore(String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = this.createEmptyKeyStore();
        ks.setCertificateEntry(alias, cert);
        return ks;
    }

    public SSLContext createSSLContext(ApplicationId appId) throws GeneralSecurityException {
        TrustManager[] trustManagers = new TrustManager[]{this.createTrustManager(appId)};
        KeyManager[] keyManagers = new KeyManager[]{this.x509KeyManager};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(keyManagers, trustManagers, new SecureRandom());
        return sc;
    }

    @VisibleForTesting
    X509TrustManager createTrustManager(final ApplicationId appId) {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return ProxyCA.this.defaultTrustManager.getAcceptedIssuers();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                boolean issuedByRM = false;
                if (certs.length == 2) {
                    try {
                        certs[0].verify(ProxyCA.this.caKeyPair.getPublic());
                        certs[1].verify(ProxyCA.this.caKeyPair.getPublic());
                        issuedByRM = true;
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                        LOG.debug("Could not verify certificate with RM CA, falling back to default", (Throwable)e);
                        ProxyCA.this.defaultTrustManager.checkServerTrusted(certs, authType);
                    }
                } else {
                    LOG.debug("Certificate not issued by RM CA, falling back to default");
                    ProxyCA.this.defaultTrustManager.checkServerTrusted(certs, authType);
                }
                if (issuedByRM) {
                    if (!certs[0].getSubjectX500Principal().getName().equals("CN=" + appId)) {
                        throw new CertificateException("Expected to find Subject X500 Principal with CN=" + appId + " but found " + certs[0].getSubjectX500Principal().getName());
                    }
                    LOG.debug("Verified certificate signed by RM CA");
                }
            }
        };
    }

    @VisibleForTesting
    X509KeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    private X509KeyManager createKeyManager() {
        return new X509KeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return new String[]{"client"};
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return "client";
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return null;
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                return new X509Certificate[]{ProxyCA.this.caCert};
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return ProxyCA.this.caKeyPair.getPrivate();
            }
        };
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private HostnameVerifier createHostnameVerifier() {
        DefaultHostnameVerifier defaultHostnameVerifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        return new HostnameVerifier((HostnameVerifier)defaultHostnameVerifier){
            final /* synthetic */ HostnameVerifier val$defaultHostnameVerifier;
            {
                this.val$defaultHostnameVerifier = hostnameVerifier;
            }

            @Override
            public boolean verify(String host, SSLSession sslSession) {
                try {
                    Certificate[] certs = sslSession.getPeerCertificates();
                    if (certs.length == 2) {
                        certs[0].verify(ProxyCA.this.caKeyPair.getPublic());
                        LOG.debug("Verified certificate signed by RM CA, skipping hostname verification");
                        return true;
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    return false;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                    LOG.debug("Could not verify certificate with RM CA, falling back to default hostname verification", (Throwable)e);
                }
                return this.val$defaultHostnameVerifier.verify(host, sslSession);
            }
        };
    }

    @VisibleForTesting
    void setDefaultTrustManager(X509TrustManager trustManager) {
        this.defaultTrustManager = trustManager;
    }

    @VisibleForTesting
    public X509Certificate getCaCert() {
        return this.caCert;
    }

    @VisibleForTesting
    public KeyPair getCaKeyPair() {
        return this.caKeyPair;
    }

    private boolean verifyCertAndKeys(X509Certificate cert, PrivateKey privateKey) throws GeneralSecurityException {
        PublicKey publicKey = cert.getPublicKey();
        byte[] data = new byte[2000];
        this.srand.nextBytes(data);
        Signature signer = Signature.getInstance("SHA512withRSA");
        signer.initSign(privateKey);
        signer.update(data);
        byte[] sig = signer.sign();
        signer = Signature.getInstance("SHA512withRSA");
        signer.initVerify(publicKey);
        signer.update(data);
        return signer.verify(sig);
    }
}

