/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderProcessing
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderProcessing.class);
    private static final byte[] EMPTY = new byte[0];
    public static final String XA_CACHE_CONTROL = "header.Cache-Control";
    public static final String XA_CONTENT_DISPOSITION = "header.Content-Disposition";
    public static final String XA_CONTENT_ENCODING = "header.Content-Encoding";
    public static final String XA_CONTENT_LANGUAGE = "header.Content-Language";
    public static final String XA_CONTENT_LENGTH = "header.Content-Length";
    public static final String XA_CONTENT_MD5 = "header.Content-MD5";
    public static final String XA_CONTENT_RANGE = "header.Content-Range";
    public static final String XA_CONTENT_TYPE = "header.Content-Type";
    public static final String XA_ETAG = "header.ETag";
    public static final String XA_LAST_MODIFIED = "header.Last-Modified";
    public static final String XA_ARCHIVE_STATUS = "header.x-amz-archive-status";
    public static final String XA_OBJECT_LOCK_LEGAL_HOLD_STATUS = "header.x-amz-object-lock-legal-hold";
    public static final String XA_OBJECT_LOCK_MODE = "header.x-amz-object-lock-mode";
    public static final String XA_OBJECT_LOCK_RETAIN_UNTIL_DATE = "header.x-amz-object-lock-retain-until-date";
    public static final String XA_OBJECT_REPLICATION_STATUS = "header.x-amz-replication-status";
    public static final String XA_S3_VERSION_ID = "header.x-amz-version-id";
    public static final String XA_SERVER_SIDE_ENCRYPTION = "header.x-amz-server-side-encryption";
    public static final String XA_STORAGE_CLASS = "header.x-amz-storage-class";
    public static final String HEADER_REFERRER = "Referer";
    public static final String[] XA_STANDARD_HEADERS = new String[]{"header.Cache-Control", "header.Content-Disposition", "header.Content-Encoding", "header.Content-Language", "header.Content-Length", "header.Content-MD5", "header.Content-Range", "header.Content-Type", "header.ETag", "header.Last-Modified", "header.x-amz-archive-status", "header.x-amz-object-lock-legal-hold", "header.x-amz-object-lock-mode", "header.x-amz-object-lock-retain-until-date", "header.x-amz-replication-status", "header.x-amz-version-id", "header.x-amz-server-side-encryption", "header.x-amz-storage-class"};
    public static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_X_DIRECTORY = "application/x-directory";
    private final HeaderProcessingCallbacks callbacks;

    public HeaderProcessing(StoreContext storeContext, HeaderProcessingCallbacks callbacks) {
        super(storeContext);
        this.callbacks = callbacks;
    }

    private Map<String, byte[]> retrieveHeaders(Path path, Statistic statistic) throws IOException {
        ObjectMetadata md;
        StoreContext context = this.getStoreContext();
        String objectKey = context.pathToKey(path);
        String symbol = statistic.getSymbol();
        S3AStatisticsContext instrumentation = context.getInstrumentation();
        try {
            md = (ObjectMetadata)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation, (String)symbol, () -> this.callbacks.getObjectMetadata(objectKey));
        }
        catch (FileNotFoundException e) {
            md = (ObjectMetadata)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation, (String)symbol, () -> this.callbacks.getObjectMetadata(objectKey + "/"));
        }
        Map rawHeaders = md.getUserMetadata();
        TreeMap<String, byte[]> headers = new TreeMap<String, byte[]>();
        rawHeaders.forEach((key, value) -> headers.put("header." + key, HeaderProcessing.encodeBytes(value)));
        this.maybeSetHeader(headers, XA_CACHE_CONTROL, md.getCacheControl());
        this.maybeSetHeader(headers, XA_CONTENT_DISPOSITION, md.getContentDisposition());
        this.maybeSetHeader(headers, XA_CONTENT_ENCODING, md.getContentEncoding());
        this.maybeSetHeader(headers, XA_CONTENT_LANGUAGE, md.getContentLanguage());
        if (md.getUserMetaDataOf("x-amz-cek-alg") != null && md.getUserMetaDataOf("x-amz-unencrypted-content-length") != null) {
            this.maybeSetHeader(headers, XA_CONTENT_LENGTH, md.getUserMetaDataOf("x-amz-unencrypted-content-length"));
        } else {
            this.maybeSetHeader(headers, XA_CONTENT_LENGTH, md.getContentLength());
        }
        this.maybeSetHeader(headers, XA_CONTENT_MD5, md.getContentMD5());
        this.maybeSetHeader(headers, XA_CONTENT_RANGE, md.getContentRange());
        this.maybeSetHeader(headers, XA_CONTENT_TYPE, md.getContentType());
        this.maybeSetHeader(headers, XA_ETAG, md.getETag());
        this.maybeSetHeader(headers, XA_LAST_MODIFIED, md.getLastModified());
        this.maybeSetHeader(headers, XA_ARCHIVE_STATUS, md.getArchiveStatus());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_LEGAL_HOLD_STATUS, md.getObjectLockLegalHoldStatus());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_MODE, md.getObjectLockMode());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_RETAIN_UNTIL_DATE, md.getObjectLockRetainUntilDate());
        this.maybeSetHeader(headers, XA_OBJECT_REPLICATION_STATUS, md.getReplicationStatus());
        this.maybeSetHeader(headers, XA_S3_VERSION_ID, md.getVersionId());
        this.maybeSetHeader(headers, XA_SERVER_SIDE_ENCRYPTION, md.getSSEAlgorithm());
        this.maybeSetHeader(headers, XA_STORAGE_CLASS, md.getStorageClass());
        this.maybeSetHeader(headers, XA_STORAGE_CLASS, md.getReplicationStatus());
        return headers;
    }

    private void maybeSetHeader(Map<String, byte[]> headers, String name, Object value) {
        if (value != null) {
            headers.put(name, HeaderProcessing.encodeBytes(value));
        }
    }

    public static byte[] encodeBytes(@Nullable Object s) {
        return s == null ? EMPTY : s.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static String decodeBytes(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_NAMED).get(name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_MAP);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return new ArrayList<String>(this.retrieveHeaders(path, Statistic.INVOCATION_OP_XATTR_LIST).keySet());
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        Map<String, byte[]> headers = this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_NAMED_MAP);
        TreeMap<String, byte[]> result = new TreeMap<String, byte[]>();
        headers.entrySet().stream().filter(entry -> names.contains(entry.getKey())).forEach(entry -> result.put((String)entry.getKey(), (byte[])entry.getValue()));
        return result;
    }

    public static Optional<Long> extractXAttrLongValue(byte[] data) {
        String xAttr = HeaderProcessing.decodeBytes(data);
        if (StringUtils.isNotEmpty((CharSequence)xAttr)) {
            try {
                long l = Long.parseLong(xAttr);
                if (l >= 0L) {
                    return Optional.of(l);
                }
            }
            catch (NumberFormatException ex) {
                LOG.warn("Not a number: {}", (Object)xAttr, (Object)ex);
            }
        }
        return Optional.empty();
    }

    public static void cloneObjectMetadata(ObjectMetadata source, ObjectMetadata dest) {
        if (source.getCacheControl() != null) {
            dest.setCacheControl(source.getCacheControl());
        }
        if (source.getContentDisposition() != null) {
            dest.setContentDisposition(source.getContentDisposition());
        }
        if (source.getContentEncoding() != null) {
            dest.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMD5() != null) {
            dest.setContentMD5(source.getContentMD5());
        }
        if (source.getContentType() != null) {
            dest.setContentType(source.getContentType());
        }
        if (source.getExpirationTime() != null) {
            dest.setExpirationTime(source.getExpirationTime());
        }
        if (source.getExpirationTimeRuleId() != null) {
            dest.setExpirationTimeRuleId(source.getExpirationTimeRuleId());
        }
        if (source.getHttpExpiresDate() != null) {
            dest.setHttpExpiresDate(source.getHttpExpiresDate());
        }
        if (source.getLastModified() != null) {
            dest.setLastModified(source.getLastModified());
        }
        if (source.getOngoingRestore() != null) {
            dest.setOngoingRestore(source.getOngoingRestore().booleanValue());
        }
        if (source.getRestoreExpirationTime() != null) {
            dest.setRestoreExpirationTime(source.getRestoreExpirationTime());
        }
        if (source.getSSEAlgorithm() != null) {
            dest.setSSEAlgorithm(source.getSSEAlgorithm());
        }
        if (source.getSSECustomerAlgorithm() != null) {
            dest.setSSECustomerAlgorithm(source.getSSECustomerAlgorithm());
        }
        if (source.getSSECustomerKeyMd5() != null) {
            dest.setSSECustomerKeyMd5(source.getSSECustomerKeyMd5());
        }
        source.getUserMetadata().entrySet().stream().filter(e -> !((String)e.getKey()).equals("x-hadoop-s3a-magic-data-length")).forEach(e -> dest.addUserMetadata((String)e.getKey(), (String)e.getValue()));
    }

    public static interface HeaderProcessingCallbacks {
        public ObjectMetadata getObjectMetadata(String var1) throws IOException;
    }
}

