/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.ftp;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.AbstractContractRenameTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ftp.FTPContract;

public class TestFTPContractRename
extends AbstractContractRenameTest {
    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new FTPContract(conf);
    }

    private void verifyUnsupportedDirRenameException(IOException e) throws IOException {
        if (!e.toString().contains("only same directory renames are supported")) {
            throw e;
        }
    }

    @Override
    public void testRenameDirIntoExistingDir() throws Throwable {
        try {
            super.testRenameDirIntoExistingDir();
            TestFTPContractRename.fail((String)"Expected a failure");
        }
        catch (IOException e) {
            this.verifyUnsupportedDirRenameException(e);
        }
    }

    @Override
    public void testRenameFileNonexistentDir() throws Throwable {
        try {
            super.testRenameFileNonexistentDir();
            TestFTPContractRename.fail((String)"Expected a failure");
        }
        catch (IOException e) {
            this.verifyUnsupportedDirRenameException(e);
        }
    }
}

