/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;
import rx.functions.Func0;

class AsyncLazy<TValue> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncLazy.class);
    private final Single<TValue> single;
    private volatile boolean succeeded;
    private volatile boolean failed;

    public AsyncLazy(Func0<Single<TValue>> func) {
        this(Single.defer(() -> {
            logger.debug("using Func0<Single<TValue>> {}", (Object)func);
            return (Single)func.call();
        }));
    }

    public AsyncLazy(TValue value) {
        this.single = Single.just(value);
        this.succeeded = true;
        this.failed = false;
    }

    private AsyncLazy(Single<TValue> single) {
        logger.debug("constructor");
        this.single = single.doOnSuccess(v -> {
            this.succeeded = true;
        }).doOnError(e -> {
            this.failed = true;
        }).cache();
    }

    public Single<TValue> single() {
        return this.single;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public boolean isFaulted() {
        return this.failed;
    }
}

