/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTBasicObjectSerializer;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;

public class FSTMapSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Map col = (Map)toWrite;
        out.writeInt(col.size());
        FSTClazzInfo lastKClzI = null;
        FSTClazzInfo lastVClzI = null;
        Class<?> lastKClz = null;
        Class<?> lastVClz = null;
        for (Map.Entry next : col.entrySet()) {
            Object key = next.getKey();
            Object value = next.getValue();
            if (key != null && value != null) {
                lastKClzI = out.writeObjectInternal(key, key.getClass() == lastKClz ? lastKClzI : null, null);
                lastVClzI = out.writeObjectInternal(value, value.getClass() == lastVClz ? lastVClzI : null, null);
                lastKClz = key.getClass();
                lastVClz = value.getClass();
                continue;
            }
            out.writeObjectInternal(key, null, null);
            out.writeObjectInternal(value, null, null);
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        Map res = null;
        int len = in.readInt();
        res = objectClass == HashMap.class ? new HashMap(len) : (objectClass == Hashtable.class ? new Hashtable(len) : objectClass.newInstance());
        in.registerObject(res, streamPosition, serializationInfo, referencee);
        Map col = res;
        for (int i = 0; i < len; ++i) {
            Object key = in.readObjectInternal(null);
            Object val = in.readObjectInternal(null);
            col.put(key, val);
        }
        return res;
    }
}

