/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ClientSCMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.sharedcache.SharedCacheUtil;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.ClientSCMMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SharedCacheResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientProtocolService
extends AbstractService
implements ClientSCMProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ClientProtocolService.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private Server server;
    InetSocketAddress clientBindAddress;
    private final SCMStore store;
    private int cacheDepth;
    private String cacheRoot;
    private ClientSCMMetrics metrics;

    public ClientProtocolService(SCMStore store) {
        super(ClientProtocolService.class.getName());
        this.store = store;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.clientBindAddress = this.getBindAddress(conf);
        this.cacheDepth = SharedCacheUtil.getCacheDepth((Configuration)conf);
        this.cacheRoot = conf.get("yarn.sharedcache.root-dir", "/sharedcache");
        super.serviceInit(conf);
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.sharedcache.client-server.address", "0.0.0.0:8045", 8045);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        this.metrics = ClientSCMMetrics.getInstance();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ClientSCMProtocol.class, (Object)this, this.clientBindAddress, conf, null, conf.getInt("yarn.sharedcache.client-server.thread-count", 50));
        this.server.start();
        this.clientBindAddress = conf.updateConnectAddr("yarn.sharedcache.client-server.address", this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    public UseSharedCacheResourceResponse use(UseSharedCacheResourceRequest request) throws YarnException, IOException {
        UserGroupInformation callerUGI;
        UseSharedCacheResourceResponse response = (UseSharedCacheResourceResponse)this.recordFactory.newRecordInstance(UseSharedCacheResourceResponse.class);
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info("Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        String fileName = this.store.addResourceReference(request.getResourceKey(), new SharedCacheResourceReference(request.getAppId(), callerUGI.getShortUserName()));
        if (fileName != null) {
            response.setPath(this.getCacheEntryFilePath(request.getResourceKey(), fileName));
            this.metrics.incCacheHitCount();
        } else {
            this.metrics.incCacheMissCount();
        }
        return response;
    }

    public ReleaseSharedCacheResourceResponse release(ReleaseSharedCacheResourceRequest request) throws YarnException, IOException {
        UserGroupInformation callerUGI;
        ReleaseSharedCacheResourceResponse response = (ReleaseSharedCacheResourceResponse)this.recordFactory.newRecordInstance(ReleaseSharedCacheResourceResponse.class);
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info("Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        boolean removed = this.store.removeResourceReference(request.getResourceKey(), new SharedCacheResourceReference(request.getAppId(), callerUGI.getShortUserName()), true);
        if (removed) {
            this.metrics.incCacheRelease();
        }
        return response;
    }

    private String getCacheEntryFilePath(String checksum, String filename) {
        return SharedCacheUtil.getCacheEntryPath((int)this.cacheDepth, (String)this.cacheRoot, (String)checksum) + "/" + filename;
    }
}

