/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.fs.slive.DataHasher;
import org.apache.hadoop.fs.slive.Timer;

class DataWriter {
    private static final int HEADER_LENGTH = 16;
    private int bufferSize;
    private Random rnd;

    DataWriter(Random rnd, int bufferSize) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("Buffer size must be greater than or equal to 8");
        }
        if (bufferSize % 8 != 0) {
            throw new IllegalArgumentException("Buffer size must be a multiple of 8");
        }
        this.bufferSize = bufferSize;
        this.rnd = rnd;
    }

    DataWriter(Random rnd) {
        this(rnd, 65536);
    }

    private GenerateResult generatePartialSegment(int byteAm, long offset, DataHasher hasher) {
        if (byteAm > 8) {
            throw new IllegalArgumentException("Partial bytes must be less or equal to 8");
        }
        if (byteAm <= 0) {
            throw new IllegalArgumentException("Partial bytes must be greater than zero and not " + byteAm);
        }
        ByteBuffer buf = ByteBuffer.wrap(new byte[8]);
        buf.putLong(hasher.generate(offset));
        ByteBuffer allBytes = ByteBuffer.wrap(new byte[byteAm]);
        ((Buffer)buf).rewind();
        for (int i = 0; i < byteAm; ++i) {
            allBytes.put(buf.get());
        }
        ((Buffer)allBytes).rewind();
        return new GenerateResult(offset, allBytes);
    }

    private GenerateResult generateFullSegment(int byteAm, long startOffset, DataHasher hasher) {
        if (byteAm <= 0) {
            throw new IllegalArgumentException("Byte amount must be greater than zero and not " + byteAm);
        }
        if (byteAm % 8 != 0) {
            throw new IllegalArgumentException("Byte amount " + byteAm + " must be a multiple of 8");
        }
        ByteBuffer allBytes = ByteBuffer.wrap(new byte[byteAm]);
        long offset = startOffset;
        ByteBuffer buf = ByteBuffer.wrap(new byte[8]);
        for (long i = 0L; i < (long)byteAm; i += 8L) {
            ((Buffer)buf).rewind();
            buf.putLong(hasher.generate(offset));
            ((Buffer)buf).rewind();
            allBytes.put(buf);
            offset += 8L;
        }
        ((Buffer)allBytes).rewind();
        return new GenerateResult(offset, allBytes);
    }

    private GenerateOutput writePieces(long byteAm, long startPos, DataHasher hasher, OutputStream out) throws IOException {
        GenerateResult genData;
        if (byteAm <= 0L) {
            return new GenerateOutput(0L, 0L);
        }
        if (startPos < 0L) {
            startPos = 0L;
        }
        int leftOver = (int)(byteAm % (long)this.bufferSize);
        long fullPieces = byteAm / (long)this.bufferSize;
        long offset = startPos;
        long bytesWritten = 0L;
        long timeTaken = 0L;
        for (long i = 0L; i < fullPieces; ++i) {
            genData = this.generateFullSegment(this.bufferSize, offset, hasher);
            offset = genData.getOffset();
            ByteBuffer gBuf = genData.getBuffer();
            byte[] buf = gBuf.array();
            long startTime = Timer.now();
            out.write(buf);
            timeTaken += Timer.elapsed(startTime);
            bytesWritten += (long)buf.length;
        }
        if (leftOver > 0) {
            int bytesLeft;
            ByteBuffer leftOverBuf = ByteBuffer.wrap(new byte[leftOver]);
            if ((leftOver -= (bytesLeft = leftOver % 8)) > 0) {
                genData = this.generateFullSegment(leftOver, offset, hasher);
                offset = genData.getOffset();
                leftOverBuf.put(genData.getBuffer());
            }
            if (bytesLeft > 0) {
                genData = this.generatePartialSegment(bytesLeft, offset, hasher);
                offset = genData.getOffset();
                leftOverBuf.put(genData.getBuffer());
            }
            ((Buffer)leftOverBuf).rewind();
            byte[] buf = leftOverBuf.array();
            long startTime = Timer.now();
            out.write(buf);
            timeTaken += Timer.elapsed(startTime);
            bytesWritten += (long)buf.length;
        }
        return new GenerateOutput(bytesWritten, timeTaken);
    }

    GenerateOutput writeSegment(long byteAm, OutputStream out) throws IOException {
        long headerLen = DataWriter.getHeaderLength();
        if (byteAm < headerLen) {
            return new GenerateOutput(0L, 0L);
        }
        if ((byteAm -= headerLen) < 0L) {
            byteAm = 0L;
        }
        WriteInfo header = this.writeHeader(out, byteAm);
        DataHasher hasher = new DataHasher(header.getHashValue());
        GenerateOutput pRes = this.writePieces(byteAm, 0L, hasher, out);
        long bytesWritten = pRes.getBytesWritten() + header.getBytesWritten();
        long timeTaken = header.getTimeTaken() + pRes.getTimeTaken();
        return new GenerateOutput(bytesWritten, timeTaken);
    }

    static int getHeaderLength() {
        return 16;
    }

    WriteInfo writeHeader(OutputStream os, long fileSize) throws IOException {
        int headerLen = DataWriter.getHeaderLength();
        ByteBuffer buf = ByteBuffer.wrap(new byte[headerLen]);
        long hash = this.rnd.nextLong();
        buf.putLong(hash);
        buf.putLong(fileSize);
        ((Buffer)buf).rewind();
        byte[] headerData = buf.array();
        long elapsed = 0L;
        long startTime = Timer.now();
        os.write(headerData);
        return new WriteInfo(hash, headerLen, elapsed += Timer.elapsed(startTime));
    }

    private static class WriteInfo {
        private long hashValue;
        private long bytesWritten;
        private long timeTaken;

        WriteInfo(long hashValue, long bytesWritten, long timeTaken) {
            this.hashValue = hashValue;
            this.bytesWritten = bytesWritten;
            this.timeTaken = timeTaken;
        }

        long getHashValue() {
            return this.hashValue;
        }

        long getTimeTaken() {
            return this.timeTaken;
        }

        long getBytesWritten() {
            return this.bytesWritten;
        }
    }

    private static class GenerateResult {
        private long offset;
        private ByteBuffer buffer;

        GenerateResult(long offset, ByteBuffer buffer) {
            this.offset = offset;
            this.buffer = buffer;
        }

        long getOffset() {
            return this.offset;
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }
    }

    static class GenerateOutput {
        private long bytes;
        private long time;

        GenerateOutput(long bytesWritten, long timeTaken) {
            this.bytes = bytesWritten;
            this.time = timeTaken;
        }

        long getBytesWritten() {
            return this.bytes;
        }

        long getTimeTaken() {
            return this.time;
        }

        public String toString() {
            return "Wrote " + this.getBytesWritten() + " bytes  which took " + this.getTimeTaken() + " milliseconds";
        }
    }
}

