/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.JavaKeyStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProviderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderUtils.class);

    private ProviderUtils() {
    }

    public static Path unnestUri(URI nestedUri) {
        StringBuilder result = new StringBuilder();
        String authority = nestedUri.getAuthority();
        if (authority != null) {
            String[] parts = nestedUri.getAuthority().split("@", 2);
            result.append(parts[0]);
            result.append("://");
            if (parts.length == 2) {
                result.append(parts[1]);
            }
        }
        result.append(nestedUri.getPath());
        if (nestedUri.getQuery() != null) {
            result.append("?");
            result.append(nestedUri.getQuery());
        }
        if (nestedUri.getFragment() != null) {
            result.append("#");
            result.append(nestedUri.getFragment());
        }
        return new Path(result.toString());
    }

    public static URI nestURIForLocalJavaKeyStoreProvider(URI localFile) throws URISyntaxException {
        if (!"file".equals(localFile.getScheme())) {
            throw new IllegalArgumentException("passed URI had a scheme other than file.");
        }
        if (localFile.getAuthority() != null) {
            throw new IllegalArgumentException("passed URI must not have an authority component. For non-local keystores, please use " + JavaKeyStoreProvider.class.getName());
        }
        return new URI("localjceks", "//file" + localFile.getSchemeSpecificPart(), localFile.getFragment());
    }

    public static Configuration excludeIncompatibleCredentialProviders(Configuration config, Class<? extends FileSystem> fileSystemClass) throws IOException {
        String providerPath = config.get("hadoop.security.credential.provider.path");
        if (providerPath == null) {
            return config;
        }
        StringBuffer newProviderPath = new StringBuffer();
        String[] providers = providerPath.split(",");
        Path path = null;
        for (String provider : providers) {
            try {
                path = ProviderUtils.unnestUri(new URI(provider));
                Class<? extends FileSystem> clazz = null;
                try {
                    String scheme = path.toUri().getScheme();
                    clazz = FileSystem.getFileSystemClass(scheme, config);
                }
                catch (IOException ioe) {
                    if (newProviderPath.length() > 0) {
                        newProviderPath.append(",");
                    }
                    newProviderPath.append(provider);
                }
                if (clazz == null) continue;
                if (fileSystemClass.isAssignableFrom(clazz)) {
                    LOG.debug("Filesystem based provider excluded from provider path due to recursive dependency: " + provider);
                    continue;
                }
                if (newProviderPath.length() > 0) {
                    newProviderPath.append(",");
                }
                newProviderPath.append(provider);
            }
            catch (URISyntaxException e) {
                LOG.warn("Credential Provider URI is invalid." + provider);
            }
        }
        String effectivePath = newProviderPath.toString();
        if (effectivePath.equals(providerPath)) {
            return config;
        }
        Configuration conf = new Configuration(config);
        if (effectivePath.equals("")) {
            conf.unset("hadoop.security.credential.provider.path");
        } else {
            conf.set("hadoop.security.credential.provider.path", effectivePath);
        }
        return conf;
    }
}

