/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DockerLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DockerLinuxContainerRuntime.class);
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE_FILE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE_FILE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE";
    private Configuration conf;
    private DockerClient dockerClient;
    private PrivilegedOperationExecutor privilegedOperationExecutor;

    public static boolean isDockerContainerRequested(Map<String, String> env) {
        if (env == null) {
            return false;
        }
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type != null && type.equals("docker");
    }

    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        this.conf = conf;
        this.dockerClient = new DockerClient(conf);
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    public void addCGroupParentIfRequired(String resourcesOptions, String containerIdStr, DockerRunCommand runCommand) throws ContainerExecutionException {
        if (resourcesOptions.equals("cgroups=none")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("no resource restrictions specified. not using docker's cgroup options");
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("using docker's cgroups options");
            }
            try {
                CGroupsHandler cGroupsHandler = ResourceHandlerModule.getCGroupsHandler(this.conf);
                String cGroupPath = "/" + cGroupsHandler.getRelativePathForCGroup(containerIdStr);
                if (LOG.isInfoEnabled()) {
                    LOG.info("using cgroup parent: " + cGroupPath);
                }
                runCommand.setCGroupParent(cGroupPath);
            }
            catch (ResourceHandlerException e) {
                LOG.warn("unable to use cgroups handler. Exception: ", (Throwable)((Object)e));
                throw new ContainerExecutionException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_DOCKER_CONTAINER_IMAGE);
        if (imageName == null) {
            throw new ContainerExecutionException("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE not set!");
        }
        String containerIdStr = container.getContainerId().toString();
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        List containerLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOCAL_DIRS);
        List containerLogDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS);
        DockerRunCommand runCommand = new DockerRunCommand(containerIdStr, runAsUser, imageName).detachOnRun().setContainerWorkDir(containerWorkDir.toString()).setNetworkType("host").addMountLocation("/etc/passwd", "/etc/password:ro");
        ArrayList<String> allDirs = new ArrayList<String>(containerLocalDirs);
        allDirs.add(containerWorkDir.toString());
        allDirs.addAll(containerLogDirs);
        for (String dir : allDirs) {
            runCommand.addMountLocation(dir, dir);
        }
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        Path nmPrivateContainerScriptPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        String disableOverride = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE);
        if (disableOverride != null && disableOverride.equals("true")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("command override disabled");
            }
        } else {
            ArrayList<String> overrideCommands = new ArrayList<String>();
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            overrideCommands.add("bash");
            overrideCommands.add(launchDst.toUri().getPath());
            runCommand.setOverrideCommandWithArgs(overrideCommands);
        }
        String commandFile = this.dockerClient.writeCommandToTempFile(runCommand, containerIdStr);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_DOCKER_CONTAINER);
        launchOp.appendArgs(runAsUser, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_DOCKER_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), containerIdStr, containerWorkDir.toString(), nmPrivateContainerScriptPath.toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)localDirs), StringUtils.join((char)'%', (Iterable)logDirs), commandFile, resourcesOpts);
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, container.getLaunchContext().getEnvironment(), false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Launch container failed. Exception: ", (Throwable)((Object)e));
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        try {
            PrivilegedOperationExecutor executor = PrivilegedOperationExecutor.getInstance(this.conf);
            executor.executePrivilegedOperation(null, signalOp, null, container.getLaunchContext().getEnvironment(), false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Signal container failed. Exception: ", (Throwable)((Object)e));
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }
}

