/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DiskBasedResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "fair";
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DiskBasedResourceCalculator();
    private FairShareComparator comparator = new FairShareComparator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    @Override
    public Resource getHeadroom(Resource queueFairShare, Resource queueUsage, Resource maxAvailable) {
        int queueAvailableMemory = Math.max(queueFairShare.getMemory() - queueUsage.getMemory(), 0);
        Resource headroom = Resources.createResource((int)Math.min(maxAvailable.getMemory(), queueAvailableMemory), (int)maxAvailable.getVirtualCores(), (double)maxAvailable.getDisks());
        return headroom;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        ComputeFairShares.computeShares(schedulables, totalResources, ResourceType.MEMORY);
    }

    @Override
    public void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources) {
        ComputeFairShares.computeSteadyShares(queues, totalResources, ResourceType.MEMORY);
    }

    @Override
    public boolean checkIfUsageOverFairShare(Resource usage, Resource fairShare) {
        return Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)usage, (Resource)fairShare);
    }

    @Override
    public boolean checkIfAMResourceUsageOverLimit(Resource usage, Resource maxAMResource) {
        return usage.getMemory() > maxAMResource.getMemory();
    }

    @Override
    public byte getApplicableDepth() {
        return 7;
    }

    private static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;
        private static final Resource ONE = Resources.createResource((int)1);

        private FairShareComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            Resource resourceUsage1 = s1.getResourceUsage();
            Resource resourceUsage2 = s2.getResourceUsage();
            Resource minShare1 = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s1.getMinShare(), (Resource)s1.getDemand());
            Resource minShare2 = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s2.getMinShare(), (Resource)s2.getDemand());
            boolean s1Needy = Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)resourceUsage1, (Resource)minShare1);
            boolean s2Needy = Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)resourceUsage2, (Resource)minShare2);
            double minShareRatio1 = (double)resourceUsage1.getMemory() / (double)Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)minShare1, (Resource)ONE).getMemory();
            double minShareRatio2 = (double)resourceUsage2.getMemory() / (double)Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)minShare2, (Resource)ONE).getMemory();
            double useToWeightRatio1 = (float)resourceUsage1.getMemory() / s1.getWeights().getWeight(ResourceType.MEMORY);
            double useToWeightRatio2 = (float)resourceUsage2.getMemory() / s2.getWeights().getWeight(ResourceType.MEMORY);
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(useToWeightRatio1 - useToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

