/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FairSchedulerConfiguration
extends Configuration {
    public static final Logger LOG = LoggerFactory.getLogger((String)FairSchedulerConfiguration.class.getName());
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_MB = "yarn.scheduler.increment-allocation-mb";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_MB = 1024;
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = "yarn.scheduler.increment-allocation-vcores";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = 1;
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_DISKS = "yarn.scheduler.increment-allocation-disk";
    public static final double DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_DISKS = 0.0;
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    public static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String DEFAULT_ALLOCATION_FILE = "fair-scheduler.xml";
    public static final String EVENT_LOG_ENABLED = "yarn.scheduler.fair.event-log-enabled";
    public static final boolean DEFAULT_EVENT_LOG_ENABLED = false;
    protected static final String EVENT_LOG_DIR = "eventlog.dir";
    protected static final String ALLOW_UNDECLARED_POOLS = "yarn.scheduler.fair.allow-undeclared-pools";
    protected static final boolean DEFAULT_ALLOW_UNDECLARED_POOLS = true;
    protected static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    protected static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;
    protected static final String ACL_CASE_SENSITIVITY_DISABLED = "yarn.scheduler.fair.acl-case-sensitivity-disabled";
    protected static final boolean DEFAULT_ACL_CASE_SENSITIVITY_DISABLED = false;
    protected static final float DEFAULT_LOCALITY_THRESHOLD = -1.0f;
    protected static final String LOCALITY_THRESHOLD_NODE = "yarn.scheduler.fair.locality.threshold.node";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_NODE = -1.0f;
    protected static final String LOCALITY_THRESHOLD_RACK = "yarn.scheduler.fair.locality.threshold.rack";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_RACK = -1.0f;
    protected static final String LOCALITY_DELAY_NODE_MS = "yarn.scheduler.fair.locality-delay-node-ms";
    protected static final long DEFAULT_LOCALITY_DELAY_NODE_MS = -1L;
    protected static final String LOCALITY_DELAY_RACK_MS = "yarn.scheduler.fair.locality-delay-rack-ms";
    protected static final long DEFAULT_LOCALITY_DELAY_RACK_MS = -1L;
    protected static final String CONTINUOUS_SCHEDULING_ENABLED = "yarn.scheduler.fair.continuous-scheduling-enabled";
    protected static final boolean DEFAULT_CONTINUOUS_SCHEDULING_ENABLED = false;
    protected static final String CONTINUOUS_SCHEDULING_SLEEP_MS = "yarn.scheduler.fair.continuous-scheduling-sleep-ms";
    protected static final int DEFAULT_CONTINUOUS_SCHEDULING_SLEEP_MS = 5;
    protected static final String PREEMPTION = "yarn.scheduler.fair.preemption";
    protected static final boolean DEFAULT_PREEMPTION = false;
    protected static final String PREEMPTION_THRESHOLD = "yarn.scheduler.fair.preemption.cluster-utilization-threshold";
    protected static final float DEFAULT_PREEMPTION_THRESHOLD = 0.8f;
    protected static final String PREEMPTION_THRESHOLD_BASED_ON_LABELS_ENABLED = "yarn.scheduler.fair.preemption.cluster-utilization-threshold.based-on-labels-enabled";
    protected static final boolean DEFAULT_PREEMPTION_THRESHOLD_BASED_ON_LABELS_ENABLED = false;
    protected static final String PREEMPTION_INTERVAL = "yarn.scheduler.fair.preemptionInterval";
    protected static final int DEFAULT_PREEMPTION_INTERVAL = 5000;
    protected static final String WAIT_TIME_BEFORE_KILL = "yarn.scheduler.fair.waitTimeBeforeKill";
    protected static final int DEFAULT_WAIT_TIME_BEFORE_KILL = 15000;
    public static final String ASSIGN_MULTIPLE = "yarn.scheduler.fair.assignmultiple";
    protected static final boolean DEFAULT_ASSIGN_MULTIPLE = false;
    protected static final String SIZE_BASED_WEIGHT = "yarn.scheduler.fair.sizebasedweight";
    protected static final boolean DEFAULT_SIZE_BASED_WEIGHT = false;
    protected static final String MAX_ASSIGN = "yarn.scheduler.fair.max.assign";
    protected static final int DEFAULT_MAX_ASSIGN = -1;
    public static final String UPDATE_INTERVAL_MS = "yarn.scheduler.fair.update-interval-ms";
    public static final int DEFAULT_UPDATE_INTERVAL_MS = 500;
    public static final String RESOURCES_BASED_ON_LABELS_ENABLED = "yarn.scheduler.fair.resources-based-on-labels-enabled";
    public static final boolean DEFAULT_RESOURCES_BASED_ON_LABELS_ENABLED = false;

    public FairSchedulerConfiguration() {
    }

    public FairSchedulerConfiguration(Configuration conf) {
        super(conf);
    }

    public Resource getMinimumAllocation() {
        int mem = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int cpu = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        double disk = this.getDouble("yarn.scheduler.minimum-allocation-disks", 0.0);
        return Resources.createResource((int)mem, (int)cpu, (double)disk);
    }

    public Resource getMaximumAllocation() {
        int mem = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int cpu = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        double disk = this.getDouble("yarn.scheduler.maximum-allocation-disks", 4.0);
        return Resources.createResource((int)mem, (int)cpu, (double)disk);
    }

    public Resource getIncrementAllocation() {
        int incrementMemory = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_MB, 1024);
        int incrementCores = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES, 1);
        double incrementDisk = this.getDouble(RM_SCHEDULER_INCREMENT_ALLOCATION_DISKS, 0.0);
        return Resources.createResource((int)incrementMemory, (int)incrementCores, (double)incrementDisk);
    }

    public float getLocalityThresholdNode() {
        return this.getFloat(LOCALITY_THRESHOLD_NODE, -1.0f);
    }

    public float getLocalityThresholdRack() {
        return this.getFloat(LOCALITY_THRESHOLD_RACK, -1.0f);
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.getBoolean(CONTINUOUS_SCHEDULING_ENABLED, false);
    }

    public int getContinuousSchedulingSleepMs() {
        return this.getInt(CONTINUOUS_SCHEDULING_SLEEP_MS, 5);
    }

    public long getLocalityDelayNodeMs() {
        return this.getLong(LOCALITY_DELAY_NODE_MS, -1L);
    }

    public long getLocalityDelayRackMs() {
        return this.getLong(LOCALITY_DELAY_RACK_MS, -1L);
    }

    public boolean getPreemptionEnabled() {
        return this.getBoolean(PREEMPTION, false);
    }

    public float getPreemptionUtilizationThreshold() {
        return this.getFloat(PREEMPTION_THRESHOLD, 0.8f);
    }

    public boolean isPreemptionThresholdBasedOnLabelsEnabled() {
        return this.getBoolean(PREEMPTION_THRESHOLD_BASED_ON_LABELS_ENABLED, false);
    }

    public boolean getAssignMultiple() {
        return this.getBoolean(ASSIGN_MULTIPLE, false);
    }

    public int getMaxAssign() {
        return this.getInt(MAX_ASSIGN, -1);
    }

    public boolean getSizeBasedWeight() {
        return this.getBoolean(SIZE_BASED_WEIGHT, false);
    }

    public boolean isEventLogEnabled() {
        return this.getBoolean(EVENT_LOG_ENABLED, false);
    }

    public String getEventlogDir() {
        return this.get(EVENT_LOG_DIR, new File(System.getProperty("hadoop.log.dir", "/tmp/")).getAbsolutePath() + File.separator + "fairscheduler");
    }

    public int getPreemptionInterval() {
        return this.getInt(PREEMPTION_INTERVAL, 5000);
    }

    public int getWaitTimeBeforeKill() {
        return this.getInt(WAIT_TIME_BEFORE_KILL, 15000);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public boolean isResourcesBasedOnLabelsEnabled() {
        return this.getBoolean(RESOURCES_BASED_ON_LABELS_ENABLED, false);
    }

    public static Resource parseResourceConfigValue(String val) throws AllocationConfigurationException {
        try {
            val = StringUtils.toLowerCase((String)val);
            int memory = FairSchedulerConfiguration.findResource(val, "mb");
            int vcores = FairSchedulerConfiguration.findResource(val, "vcores");
            double disks = FairSchedulerConfiguration.findResourceDouble(val, "disks");
            return BuilderUtils.newResource((int)memory, (int)vcores, (double)disks);
        }
        catch (AllocationConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AllocationConfigurationException("Error reading resource config", ex);
        }
    }

    public long getUpdateInterval() {
        return this.getLong(UPDATE_INTERVAL_MS, 500L);
    }

    private static int findResource(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("(\\d+)(\\.\\d*)?\\s*" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Integer.parseInt(matcher.group(1));
    }

    private static double findResourceDouble(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("(\\d+(\\.\\d*)?)\\s*" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Double.parseDouble(matcher.group(1));
    }
}

