/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FiCaSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Logger LOG = LoggerFactory.getLogger(FiCaSchedulerApp.class);
    private final Set<ContainerId> containersToPreempt = new HashSet<ContainerId>();
    private CapacityHeadroomProvider headroomProvider;

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
        RMApp rmApp = (RMApp)rmContext.getRMApps().get(this.getApplicationId());
        Resource amResource = rmApp == null || rmApp.getAMResourceRequest() == null ? rmContext.getScheduler().getMinimumResourceCapability() : rmApp.getAMResourceRequest().getCapability();
        this.setAMResource(amResource);
    }

    public synchronized boolean containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (null == this.liveContainers.remove(rmContainer.getContainerId())) {
            return false;
        }
        this.newlyAllocatedContainers.remove(rmContainer);
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info("Completed container: " + rmContainer.getContainerId() + " in state: " + rmContainer.getState() + " event:" + event);
        this.containersToPreempt.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        this.lastMemoryAggregateAllocationUpdateTime = -1L;
        return true;
    }

    public synchronized RMContainer allocate(NodeType type, FiCaSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        if (this.isStopped) {
            return null;
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        List<ResourceRequest> resourceRequestList = this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        rmContainer.setResourceRequests(resourceRequestList);
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + type);
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    public synchronized boolean unreserve(FiCaSchedulerNode node, Priority priority) {
        RMContainer reservedContainer;
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        if (reservedContainers != null && (reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID())) != null && reservedContainer.getContainer() != null && reservedContainer.getContainer().getResource() != null) {
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(priority);
            }
            this.resetReReservations(priority);
            Resource resource = reservedContainer.getContainer().getResource();
            Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
            LOG.info("Application " + this.getApplicationId() + " unreserved  on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation);
            return true;
        }
        return false;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized Resource getTotalPendingRequests() {
        Resource ret = Resource.newInstance((int)0, (int)0);
        for (ResourceRequest rr : this.appSchedulingInfo.getAllResourceRequests()) {
            if (!ResourceRequest.isAnyLocation((String)rr.getResourceName())) continue;
            Resources.addTo((Resource)ret, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    public synchronized void addPreemptContainer(ContainerId cont) {
        if (this.liveContainers.containsKey(cont)) {
            this.containersToPreempt.add(cont);
        }
    }

    public synchronized Allocation getAllocation(ResourceCalculator rc, Resource clusterResource, Resource minimumAllocation) {
        Set<ContainerId> currentContPreemption = Collections.unmodifiableSet(new HashSet<ContainerId>(this.containersToPreempt));
        this.containersToPreempt.clear();
        Resource tot = Resource.newInstance((int)0, (int)0);
        for (ContainerId c : currentContPreemption) {
            Resources.addTo((Resource)tot, (Resource)((RMContainer)this.liveContainers.get(c)).getContainer().getResource());
        }
        int numCont = (int)Math.ceil(Resources.divide((ResourceCalculator)rc, (Resource)clusterResource, (Resource)tot, (Resource)minimumAllocation));
        ResourceRequest rr = ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)minimumAllocation, (int)numCont);
        SchedulerApplicationAttempt.ContainersAndNMTokensAllocation allocation = this.pullNewlyAllocatedContainersAndNMTokens();
        Resource headroom = this.getHeadroom();
        this.setApplicationHeadroomForMetrics(headroom);
        return new Allocation(allocation.getContainerList(), headroom, null, currentContPreemption, Collections.singletonList(rr), allocation.getNMTokenList());
    }

    public synchronized NodeId getNodeIdToUnreserve(Priority priority, Resource capability) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        if (reservedContainers != null && !reservedContainers.isEmpty()) {
            for (Map.Entry entry : reservedContainers.entrySet()) {
                if (!Resources.fitsIn((Resource)capability, (Resource)((RMContainer)entry.getValue()).getContainer().getResource())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unreserving node with reservation size: " + ((RMContainer)entry.getValue()).getContainer().getResource() + " in order to allocate container with size: " + capability);
                }
                return (NodeId)entry.getKey();
            }
        }
        return null;
    }

    public synchronized void setHeadroomProvider(CapacityHeadroomProvider headroomProvider) {
        this.headroomProvider = headroomProvider;
    }

    public synchronized CapacityHeadroomProvider getHeadroomProvider() {
        return this.headroomProvider;
    }

    @Override
    public synchronized Resource getHeadroom() {
        if (this.headroomProvider != null) {
            return this.headroomProvider.getHeadroom();
        }
        return super.getHeadroom();
    }

    @Override
    public synchronized void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        super.transferStateFromPreviousAttempt(appAttempt);
        this.headroomProvider = ((FiCaSchedulerApp)appAttempt).getHeadroomProvider();
    }
}

