/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalCapacityPreemptionPolicy
implements SchedulingEditPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ProportionalCapacityPreemptionPolicy.class);
    public static final String OBSERVE_ONLY = "yarn.resourcemanager.monitor.capacity.preemption.observe_only";
    public static final String MONITORING_INTERVAL = "yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval";
    public static final String WAIT_TIME_BEFORE_KILL = "yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill";
    public static final String TOTAL_PREEMPTION_PER_ROUND = "yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round";
    public static final String MAX_IGNORED_OVER_CAPACITY = "yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity";
    public static final String NATURAL_TERMINATION_FACTOR = "yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor";
    public EventHandler<ContainerPreemptEvent> dispatcher;
    private final Clock clock;
    private double maxIgnoredOverCapacity;
    private long maxWaitTime;
    private CapacityScheduler scheduler;
    private long monitoringInterval;
    private final Map<RMContainer, Long> preempted = new HashMap<RMContainer, Long>();
    private ResourceCalculator rc;
    private float percentageClusterPreemptionAllowed;
    private double naturalTerminationFactor;
    private boolean observeOnly;
    private Map<NodeId, Set<String>> labels;

    public ProportionalCapacityPreemptionPolicy() {
        this.clock = new SystemClock();
    }

    public ProportionalCapacityPreemptionPolicy(Configuration config, EventHandler<ContainerPreemptEvent> dispatcher, CapacityScheduler scheduler) {
        this(config, dispatcher, scheduler, (Clock)new SystemClock());
    }

    public ProportionalCapacityPreemptionPolicy(Configuration config, EventHandler<ContainerPreemptEvent> dispatcher, CapacityScheduler scheduler, Clock clock) {
        this.init(config, dispatcher, scheduler);
        this.clock = clock;
    }

    @Override
    public void init(Configuration config, EventHandler<ContainerPreemptEvent> disp, PreemptableResourceScheduler sched) {
        LOG.info("Preemption monitor:" + this.getClass().getCanonicalName());
        assert (null == this.scheduler) : "Unexpected duplicate call to init";
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + sched.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.dispatcher = disp;
        this.scheduler = (CapacityScheduler)sched;
        this.maxIgnoredOverCapacity = config.getDouble(MAX_IGNORED_OVER_CAPACITY, 0.1);
        this.naturalTerminationFactor = config.getDouble(NATURAL_TERMINATION_FACTOR, 0.2);
        this.maxWaitTime = config.getLong(WAIT_TIME_BEFORE_KILL, 15000L);
        this.monitoringInterval = config.getLong(MONITORING_INTERVAL, 3000L);
        this.percentageClusterPreemptionAllowed = config.getFloat(TOTAL_PREEMPTION_PER_ROUND, 0.1f);
        this.observeOnly = config.getBoolean(OBSERVE_ONLY, false);
        this.rc = this.scheduler.getResourceCalculator();
        this.labels = null;
    }

    @VisibleForTesting
    public ResourceCalculator getResourceCalculator() {
        return this.rc;
    }

    @Override
    public void editSchedule() {
        CSQueue root = this.scheduler.getRootQueue();
        Resource clusterResources = Resources.clone((Resource)this.scheduler.getClusterResource());
        clusterResources = this.getNonLabeledResources(clusterResources);
        this.setNodeLabels(this.scheduler.getRMContext().getNodeLabelManager().getNodeLabels());
        this.containerBasedPreemptOrKill(root, clusterResources);
    }

    public void setNodeLabels(Map<NodeId, Set<String>> nodelabels) {
        this.labels = nodelabels;
    }

    private Resource getNonLabeledResources(Resource clusterResources) {
        RMContext rmcontext = this.scheduler.getRMContext();
        RMNodeLabelsManager lm = rmcontext.getNodeLabelManager();
        Resource res = lm.getResourceByLabel("", clusterResources);
        return res == null ? clusterResources : res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containerBasedPreemptOrKill(CSQueue root, Resource clusterResources) {
        TempQueue tRoot;
        CapacityScheduler capacityScheduler = this.scheduler;
        synchronized (capacityScheduler) {
            tRoot = this.cloneQueues(root, clusterResources);
        }
        tRoot.idealAssigned = tRoot.guaranteed;
        Resource totalPreemptionAllowed = Resources.multiply((Resource)clusterResources, (double)this.percentageClusterPreemptionAllowed);
        List<TempQueue> queues = this.recursivelyComputeIdealAssignment(tRoot, totalPreemptionAllowed);
        Map<ApplicationAttemptId, Set<RMContainer>> toPreempt = this.getContainersToPreempt(queues, clusterResources);
        if (LOG.isDebugEnabled()) {
            this.logToCSV(queues);
        }
        if (this.observeOnly) {
            return;
        }
        for (Map.Entry<ApplicationAttemptId, Set<RMContainer>> e : toPreempt.entrySet()) {
            for (RMContainer container : e.getValue()) {
                if (this.preempted.get(container) != null && this.preempted.get(container) + this.maxWaitTime < this.clock.getTime()) {
                    this.dispatcher.handle((Event)new ContainerPreemptEvent(e.getKey(), container, ContainerPreemptEventType.KILL_CONTAINER));
                    this.preempted.remove(container);
                    continue;
                }
                this.dispatcher.handle((Event)new ContainerPreemptEvent(e.getKey(), container, ContainerPreemptEventType.PREEMPT_CONTAINER));
                if (this.preempted.get(container) != null) continue;
                this.preempted.put(container, this.clock.getTime());
            }
        }
        Iterator<RMContainer> i = this.preempted.keySet().iterator();
        while (i.hasNext()) {
            RMContainer id = i.next();
            if (this.preempted.get(id) + 2L * this.maxWaitTime >= this.clock.getTime()) continue;
            i.remove();
        }
    }

    private List<TempQueue> recursivelyComputeIdealAssignment(TempQueue root, Resource totalPreemptionAllowed) {
        ArrayList<TempQueue> leafs = new ArrayList<TempQueue>();
        if (root.getChildren() != null && root.getChildren().size() > 0) {
            this.computeIdealResourceDistribution(this.rc, root.getChildren(), totalPreemptionAllowed, root.idealAssigned);
            for (TempQueue t : root.getChildren()) {
                leafs.addAll(this.recursivelyComputeIdealAssignment(t, totalPreemptionAllowed));
            }
        } else {
            return Collections.singletonList(root);
        }
        return leafs;
    }

    private void computeIdealResourceDistribution(ResourceCalculator rc, List<TempQueue> queues, Resource totalPreemptionAllowed, Resource tot_guarant) {
        ArrayList<TempQueue> qAlloc = new ArrayList<TempQueue>(queues);
        Resource unassigned = Resources.clone((Resource)tot_guarant);
        HashSet<TempQueue> nonZeroGuarQueues = new HashSet<TempQueue>();
        HashSet<TempQueue> zeroGuarQueues = new HashSet<TempQueue>();
        for (TempQueue tempQueue : qAlloc) {
            if (Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)tempQueue.guaranteed, (Resource)Resources.none())) {
                nonZeroGuarQueues.add(tempQueue);
                continue;
            }
            zeroGuarQueues.add(tempQueue);
        }
        this.computeFixpointAllocation(rc, tot_guarant, nonZeroGuarQueues, unassigned, false);
        if (!zeroGuarQueues.isEmpty() && Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)unassigned, (Resource)Resources.none())) {
            this.computeFixpointAllocation(rc, tot_guarant, zeroGuarQueues, unassigned, true);
        }
        Resource totPreemptionNeeded = Resource.newInstance((int)0, (int)0);
        for (TempQueue tempQueue : queues) {
            if (!Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)tempQueue.current, (Resource)tempQueue.idealAssigned)) continue;
            Resources.addTo((Resource)totPreemptionNeeded, (Resource)Resources.subtract((Resource)tempQueue.current, (Resource)tempQueue.idealAssigned));
        }
        float f = 1.0f;
        if (Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)totPreemptionNeeded, (Resource)totalPreemptionAllowed)) {
            f = Resources.divide((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)totalPreemptionAllowed, (Resource)totPreemptionNeeded);
        }
        for (TempQueue t : queues) {
            t.assignPreemption(f, rc, tot_guarant);
        }
        if (LOG.isDebugEnabled()) {
            long l = this.clock.getTime();
            for (TempQueue t : queues) {
                LOG.debug(l + ": " + t);
            }
        }
    }

    private void computeFixpointAllocation(ResourceCalculator rc, Resource tot_guarant, Collection<TempQueue> qAlloc, Resource unassigned, boolean ignoreGuarantee) {
        TQComparator tqComparator = new TQComparator(rc, tot_guarant);
        PriorityQueue<TempQueue> orderedByNeed = new PriorityQueue<TempQueue>(10, tqComparator);
        for (TempQueue q : qAlloc) {
            q.idealAssigned = Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)q.current, (Resource)q.guaranteed) ? Resources.add((Resource)q.guaranteed, (Resource)q.untouchableExtra) : Resources.clone((Resource)q.current);
            Resources.subtractFrom((Resource)unassigned, (Resource)q.idealAssigned);
            Resource curPlusPend = Resources.add((Resource)q.current, (Resource)q.pending);
            if (!Resources.lessThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)q.idealAssigned, (Resource)curPlusPend)) continue;
            orderedByNeed.add(q);
        }
        while (!orderedByNeed.isEmpty() && Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)unassigned, (Resource)Resources.none())) {
            Resource wQassigned = Resource.newInstance((int)0, (int)0);
            this.resetCapacity(rc, unassigned, orderedByNeed, ignoreGuarantee);
            Collection<TempQueue> underserved = this.getMostUnderservedQueues(orderedByNeed, tqComparator);
            for (TempQueue sub : underserved) {
                Resource wQidle;
                Resource wQavail = Resources.multiplyAndNormalizeUp((ResourceCalculator)rc, (Resource)unassigned, (double)sub.normalizedGuarantee, (Resource)Resource.newInstance((int)1, (int)1));
                Resource wQdone = Resources.subtract((Resource)wQavail, (Resource)(wQidle = sub.offer(wQavail, rc, tot_guarant)));
                if (Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)wQdone, (Resource)Resources.none())) {
                    orderedByNeed.add(sub);
                }
                Resources.addTo((Resource)wQassigned, (Resource)wQdone);
            }
            Resources.subtractFrom((Resource)unassigned, (Resource)wQassigned);
        }
    }

    protected Collection<TempQueue> getMostUnderservedQueues(PriorityQueue<TempQueue> orderedByNeed, TQComparator tqComparator) {
        ArrayList<TempQueue> underserved = new ArrayList<TempQueue>();
        while (!orderedByNeed.isEmpty()) {
            TempQueue q1 = (TempQueue)orderedByNeed.remove();
            underserved.add(q1);
            TempQueue q2 = orderedByNeed.peek();
            if (q2 != null && tqComparator.compare(q1, q2) >= 0) continue;
            return underserved;
        }
        return underserved;
    }

    private void resetCapacity(ResourceCalculator rc, Resource clusterResource, Collection<TempQueue> queues, boolean ignoreGuar) {
        Resource activeCap = Resource.newInstance((int)0, (int)0);
        if (ignoreGuar) {
            for (TempQueue q : queues) {
                q.normalizedGuarantee = 1.0f / (float)queues.size();
            }
        } else {
            for (TempQueue q : queues) {
                Resources.addTo((Resource)activeCap, (Resource)q.guaranteed);
            }
            for (TempQueue q : queues) {
                q.normalizedGuarantee = Resources.divide((ResourceCalculator)rc, (Resource)clusterResource, (Resource)q.guaranteed, (Resource)activeCap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ApplicationAttemptId, Set<RMContainer>> getContainersToPreempt(List<TempQueue> queues, Resource clusterResource) {
        HashMap<ApplicationAttemptId, Set<RMContainer>> preemptMap = new HashMap<ApplicationAttemptId, Set<RMContainer>>();
        ArrayList<RMContainer> skippedAMContainerlist = new ArrayList<RMContainer>();
        for (TempQueue qT : queues) {
            if (qT.preemptionDisabled && qT.leafQueue != null) {
                if (!LOG.isDebugEnabled() || !Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)qT.toBePreempted, (Resource)Resource.newInstance((int)0, (int)0))) continue;
                LOG.debug("Tried to preempt the following resources from non-preemptable queue: " + qT.queueName + " - Resources: " + qT.toBePreempted);
                continue;
            }
            if (!Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)qT.current, (Resource)Resources.multiply((Resource)qT.guaranteed, (double)(1.0 + this.maxIgnoredOverCapacity)))) continue;
            Resource resToObtain = Resources.multiply((Resource)qT.toBePreempted, (double)this.naturalTerminationFactor);
            Resource skippedAMSize = Resource.newInstance((int)0, (int)0);
            LeafQueue leafQueue = qT.leafQueue;
            synchronized (leafQueue) {
                NavigableSet ns = (NavigableSet)qT.leafQueue.getApplications();
                Iterator desc = ns.descendingIterator();
                qT.actuallyPreempted = Resources.clone((Resource)resToObtain);
                while (desc.hasNext()) {
                    FiCaSchedulerApp fc = (FiCaSchedulerApp)desc.next();
                    if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resToObtain, (Resource)Resources.none())) break;
                    preemptMap.put(fc.getApplicationAttemptId(), this.preemptFrom(fc, clusterResource, resToObtain, skippedAMContainerlist, skippedAMSize));
                }
                Resource maxAMCapacityForThisQueue = Resources.multiply((Resource)Resources.multiply((Resource)clusterResource, (double)qT.leafQueue.getAbsoluteCapacity()), (double)qT.leafQueue.getMaxAMResourcePerQueuePercent());
                this.preemptAMContainers(clusterResource, preemptMap, skippedAMContainerlist, resToObtain, skippedAMSize, maxAMCapacityForThisQueue);
            }
        }
        return preemptMap;
    }

    private void preemptAMContainers(Resource clusterResource, Map<ApplicationAttemptId, Set<RMContainer>> preemptMap, List<RMContainer> skippedAMContainerlist, Resource resToObtain, Resource skippedAMSize, Resource maxAMCapacityForThisQueue) {
        for (RMContainer c : skippedAMContainerlist) {
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resToObtain, (Resource)Resources.none()) || Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)skippedAMSize, (Resource)maxAMCapacityForThisQueue)) break;
            Set<RMContainer> contToPrempt = preemptMap.get(c.getApplicationAttemptId());
            if (null == contToPrempt) {
                contToPrempt = new HashSet<RMContainer>();
                preemptMap.put(c.getApplicationAttemptId(), contToPrempt);
            }
            contToPrempt.add(c);
            Resources.subtractFrom((Resource)resToObtain, (Resource)c.getContainer().getResource());
            Resources.subtractFrom((Resource)skippedAMSize, (Resource)c.getContainer().getResource());
        }
        skippedAMContainerlist.clear();
    }

    private Set<RMContainer> preemptFrom(FiCaSchedulerApp app, Resource clusterResource, Resource rsrcPreempt, List<RMContainer> skippedAMContainerlist, Resource skippedAMSize) {
        HashSet<RMContainer> ret = new HashSet<RMContainer>();
        ApplicationAttemptId appId = app.getApplicationAttemptId();
        ArrayList<RMContainer> reservations = new ArrayList<RMContainer>(app.getReservedContainers());
        for (RMContainer c : reservations) {
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)rsrcPreempt, (Resource)Resources.none())) {
                return ret;
            }
            if (!this.observeOnly) {
                this.dispatcher.handle((Event)new ContainerPreemptEvent(appId, c, ContainerPreemptEventType.DROP_RESERVATION));
            }
            Resources.subtractFrom((Resource)rsrcPreempt, (Resource)c.getContainer().getResource());
        }
        ArrayList<RMContainer> containers = new ArrayList<RMContainer>(app.getLiveContainers());
        ProportionalCapacityPreemptionPolicy.sortContainers(containers);
        for (RMContainer c : containers) {
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)rsrcPreempt, (Resource)Resources.none())) {
                return ret;
            }
            if (c.isAMContainer()) {
                skippedAMContainerlist.add(c);
                Resources.addTo((Resource)skippedAMSize, (Resource)c.getContainer().getResource());
                continue;
            }
            if (this.isLabeledContainer(c)) continue;
            ret.add(c);
            Resources.subtractFrom((Resource)rsrcPreempt, (Resource)c.getContainer().getResource());
        }
        return ret;
    }

    private boolean isLabeledContainer(RMContainer c) {
        return this.labels.containsKey(c.getAllocatedNode());
    }

    @VisibleForTesting
    static void sortContainers(List<RMContainer> containers) {
        Collections.sort(containers, new Comparator<RMContainer>(){

            @Override
            public int compare(RMContainer a, RMContainer b) {
                Priority.Comparator c = new Priority.Comparator();
                int priorityComp = c.compare(b.getContainer().getPriority(), a.getContainer().getPriority());
                if (priorityComp != 0) {
                    return priorityComp;
                }
                return b.getContainerId().compareTo(a.getContainerId());
            }
        });
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return "ProportionalCapacityPreemptionPolicy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempQueue cloneQueues(CSQueue root, Resource clusterResources) {
        TempQueue ret;
        CSQueue cSQueue = root;
        synchronized (cSQueue) {
            String queueName = root.getQueueName();
            float absCap = root.getAbsoluteCapacity();
            float absMaxCap = root.getAbsoluteMaximumCapacity();
            boolean preemptionDisabled = root.getPreemptionDisabled();
            Resource current = root.getQueueResourceUsage().getUsed();
            Resource guaranteed = Resources.multiply((Resource)clusterResources, (double)absCap);
            Resource maxCapacity = Resources.multiply((Resource)clusterResources, (double)absMaxCap);
            Resource extra = Resource.newInstance((int)0, (int)0);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResources, (Resource)current, (Resource)guaranteed)) {
                extra = Resources.subtract((Resource)current, (Resource)guaranteed);
            }
            if (root instanceof LeafQueue) {
                LeafQueue l = (LeafQueue)root;
                Resource pending = l.getTotalResourcePending();
                ret = new TempQueue(queueName, current, pending, guaranteed, maxCapacity, preemptionDisabled);
                if (preemptionDisabled) {
                    ret.untouchableExtra = extra;
                } else {
                    ret.preemptableExtra = extra;
                }
                ret.setLeafQueue(l);
            } else {
                Resource pending = Resource.newInstance((int)0, (int)0);
                ret = new TempQueue(root.getQueueName(), current, pending, guaranteed, maxCapacity, false);
                Resource childrensPreemptable = Resource.newInstance((int)0, (int)0);
                for (CSQueue c : root.getChildQueues()) {
                    TempQueue subq = this.cloneQueues(c, clusterResources);
                    Resources.addTo((Resource)childrensPreemptable, (Resource)subq.preemptableExtra);
                    ret.addChild(subq);
                }
                ret.untouchableExtra = Resources.greaterThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResources, (Resource)childrensPreemptable, (Resource)extra) ? Resource.newInstance((int)0, (int)0) : Resources.subtractFrom((Resource)extra, (Resource)childrensPreemptable);
            }
        }
        return ret;
    }

    private void logToCSV(List<TempQueue> unorderedqueues) {
        ArrayList<TempQueue> queues = new ArrayList<TempQueue>(unorderedqueues);
        Collections.sort(queues, new Comparator<TempQueue>(){

            @Override
            public int compare(TempQueue o1, TempQueue o2) {
                return o1.queueName.compareTo(o2.queueName);
            }
        });
        String queueState = " QUEUESTATE: " + this.clock.getTime();
        StringBuilder sb = new StringBuilder();
        sb.append(queueState);
        for (TempQueue tq : queues) {
            sb.append(", ");
            tq.appendLogString(sb);
        }
        LOG.debug(sb.toString());
    }

    static class TQComparator
    implements Comparator<TempQueue> {
        private ResourceCalculator rc;
        private Resource clusterRes;

        TQComparator(ResourceCalculator rc, Resource clusterRes) {
            this.rc = rc;
            this.clusterRes = clusterRes;
        }

        @Override
        public int compare(TempQueue tq1, TempQueue tq2) {
            if (this.getIdealPctOfGuaranteed(tq1) < this.getIdealPctOfGuaranteed(tq2)) {
                return -1;
            }
            if (this.getIdealPctOfGuaranteed(tq1) > this.getIdealPctOfGuaranteed(tq2)) {
                return 1;
            }
            return 0;
        }

        private double getIdealPctOfGuaranteed(TempQueue q) {
            double pctOver = 2.147483647E9;
            if (q != null && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.guaranteed, (Resource)Resources.none())) {
                pctOver = Resources.divide((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.idealAssigned, (Resource)q.guaranteed);
            }
            return pctOver;
        }
    }

    static class TempQueue {
        final String queueName;
        final Resource current;
        final Resource pending;
        final Resource guaranteed;
        final Resource maxCapacity;
        Resource idealAssigned;
        Resource toBePreempted;
        Resource actuallyPreempted;
        Resource untouchableExtra;
        Resource preemptableExtra;
        double normalizedGuarantee;
        final ArrayList<TempQueue> children;
        LeafQueue leafQueue;
        boolean preemptionDisabled;

        TempQueue(String queueName, Resource current, Resource pending, Resource guaranteed, Resource maxCapacity, boolean preemptionDisabled) {
            this.queueName = queueName;
            this.current = current;
            this.pending = pending;
            this.guaranteed = guaranteed;
            this.maxCapacity = maxCapacity;
            this.idealAssigned = Resource.newInstance((int)0, (int)0);
            this.actuallyPreempted = Resource.newInstance((int)0, (int)0);
            this.toBePreempted = Resource.newInstance((int)0, (int)0);
            this.normalizedGuarantee = Double.NaN;
            this.children = new ArrayList();
            this.untouchableExtra = Resource.newInstance((int)0, (int)0);
            this.preemptableExtra = Resource.newInstance((int)0, (int)0);
            this.preemptionDisabled = preemptionDisabled;
        }

        public void setLeafQueue(LeafQueue l) {
            assert (this.children.size() == 0);
            this.leafQueue = l;
        }

        public void addChild(TempQueue q) {
            assert (this.leafQueue == null);
            this.children.add(q);
            Resources.addTo((Resource)this.pending, (Resource)q.pending);
        }

        public void addChildren(ArrayList<TempQueue> queues) {
            assert (this.leafQueue == null);
            this.children.addAll(queues);
        }

        public ArrayList<TempQueue> getChildren() {
            return this.children;
        }

        Resource offer(Resource avail, ResourceCalculator rc, Resource clusterResource) {
            Resource absMaxCapIdealAssignedDelta = Resources.componentwiseMax((Resource)Resources.subtract((Resource)this.maxCapacity, (Resource)this.idealAssigned), (Resource)Resource.newInstance((int)0, (int)0));
            Resource accepted = Resources.min((ResourceCalculator)rc, (Resource)clusterResource, (Resource)absMaxCapIdealAssignedDelta, (Resource)Resources.min((ResourceCalculator)rc, (Resource)clusterResource, (Resource)avail, (Resource)Resources.subtract((Resource)Resources.add((Resource)this.current, (Resource)this.pending), (Resource)this.idealAssigned)));
            Resource remain = Resources.subtract((Resource)avail, (Resource)accepted);
            Resources.addTo((Resource)this.idealAssigned, (Resource)accepted);
            return remain;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" NAME: " + this.queueName).append(" CUR: ").append(this.current).append(" PEN: ").append(this.pending).append(" GAR: ").append(this.guaranteed).append(" NORM: ").append(this.normalizedGuarantee).append(" IDEAL_ASSIGNED: ").append(this.idealAssigned).append(" IDEAL_PREEMPT: ").append(this.toBePreempted).append(" ACTUAL_PREEMPT: ").append(this.actuallyPreempted).append(" UNTOUCHABLE: ").append(this.untouchableExtra).append(" PREEMPTABLE: ").append(this.preemptableExtra).append("\n");
            return sb.toString();
        }

        public void printAll() {
            LOG.info(this.toString());
            for (TempQueue sub : this.getChildren()) {
                sub.printAll();
            }
        }

        public void assignPreemption(float scalingFactor, ResourceCalculator rc, Resource clusterResource) {
            this.toBePreempted = Resources.greaterThan((ResourceCalculator)rc, (Resource)clusterResource, (Resource)this.current, (Resource)this.idealAssigned) ? Resources.multiply((Resource)Resources.subtract((Resource)this.current, (Resource)this.idealAssigned), (double)scalingFactor) : Resource.newInstance((int)0, (int)0);
        }

        void appendLogString(StringBuilder sb) {
            sb.append(this.queueName).append(", ").append(this.current.getMemory()).append(", ").append(this.current.getVirtualCores()).append(", ").append(this.pending.getMemory()).append(", ").append(this.pending.getVirtualCores()).append(", ").append(this.guaranteed.getMemory()).append(", ").append(this.guaranteed.getVirtualCores()).append(", ").append(this.idealAssigned.getMemory()).append(", ").append(this.idealAssigned.getVirtualCores()).append(", ").append(this.toBePreempted.getMemory()).append(", ").append(this.toBePreempted.getVirtualCores()).append(", ").append(this.actuallyPreempted.getMemory()).append(", ").append(this.actuallyPreempted.getVirtualCores());
        }
    }
}

