/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.MaprShellCommandExecutor;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;

public class ScramCredentialScriptUtil {
    private static final String HADOOP_HOME_PROPERTY = "hadoop.home.dir";
    private static final String YARN_HOME_PROPERTY = "yarn.home.dir";
    private static final String scramScript = "scramConfigure.sh";

    public static void checkAndCopyScramCreds(Configuration conf, String serviceName) {
        MaprShellCommandExecutor test = new MaprShellCommandExecutor();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", serviceName);
        params.put("path", conf.get("yarn.dir", YarnDefaultProperties.DEFAULT_YARN_DIR));
        try {
            test.execute(new String[]{ScramCredentialScriptUtil.getPathToHadoopHome() + "/bin/scramConfigure.sh"}, params, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getPathToHadoopHome() {
        String hadoopHome = System.getProperty(HADOOP_HOME_PROPERTY);
        if (hadoopHome == null && (hadoopHome = System.getProperty(YARN_HOME_PROPERTY)) == null) {
            return null;
        }
        return hadoopHome;
    }
}

