/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.tracing.TraceAdmin;
import org.junit.Assert;
import org.junit.Test;

public class TestTraceAdmin {
    private static final String NEWLINE = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runTraceCommand(TraceAdmin trace, String ... cmd) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream oldStdout = System.out;
        PrintStream oldStderr = System.err;
        System.setOut(ps);
        System.setErr(ps);
        int ret = -1;
        try {
            ret = trace.run(cmd);
        }
        finally {
            System.out.flush();
            System.setOut(oldStdout);
            System.setErr(oldStderr);
        }
        return "ret:" + ret + ", " + baos.toString();
    }

    private String getHostPortForNN(MiniDFSCluster cluster) {
        return "127.0.0.1:" + cluster.getNameNodePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDestroySpanReceiver() throws Exception {
        Configuration conf = new Configuration();
        conf = new Configuration();
        conf.set("hadoop.htrace.span.receiver.classes", "");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        TemporarySocketDirectory tempDir = new TemporarySocketDirectory();
        String tracePath = new File(tempDir.getDir(), "tracefile").getAbsolutePath();
        try {
            TraceAdmin trace = new TraceAdmin();
            trace.setConf(conf);
            Assert.assertEquals((Object)("ret:0, [no span receivers found]" + NEWLINE), (Object)this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, Added trace span receiver 1 with configuration local-file-span-receiver.path = " + tracePath + NEWLINE), (Object)this.runTraceCommand(trace, "-add", "-host", this.getHostPortForNN(cluster), "-class", "org.apache.htrace.core.LocalFileSpanReceiver", "-Cdfs.htrace.local-file-span-receiver.path=" + tracePath));
            String list = this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster));
            Assert.assertTrue((boolean)list.startsWith("ret:0"));
            Assert.assertTrue((boolean)list.contains("1   org.apache.htrace.core.LocalFileSpanReceiver"));
            Assert.assertEquals((Object)("ret:0, Removed trace span receiver 1" + NEWLINE), (Object)this.runTraceCommand(trace, "-remove", "1", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, [no span receivers found]" + NEWLINE), (Object)this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, Added trace span receiver 2 with configuration local-file-span-receiver.path = " + tracePath + NEWLINE), (Object)this.runTraceCommand(trace, "-add", "-host", this.getHostPortForNN(cluster), "-class", "LocalFileSpanReceiver", "-Clocal-file-span-receiver.path=" + tracePath));
            Assert.assertEquals((Object)("ret:0, Removed trace span receiver 2" + NEWLINE), (Object)this.runTraceCommand(trace, "-remove", "2", "-host", this.getHostPortForNN(cluster)));
        }
        finally {
            cluster.shutdown();
            tempDir.close();
        }
    }
}

