/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.StaticMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNetworkTopology {
    private static final Logger LOG = LoggerFactory.getLogger(TestNetworkTopology.class);
    private static final NetworkTopology cluster = new NetworkTopology();
    private DatanodeDescriptor[] dataNodes;

    @Before
    public void setupDatanodes() {
        this.dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("10.10.10.10", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("11.11.11.11", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("12.12.12.12", "/d3/r2"), DFSTestUtil.getDatanodeDescriptor("13.13.13.13", "/d3/r2"), DFSTestUtil.getDatanodeDescriptor("14.14.14.14", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("15.15.15.15", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("16.16.16.16", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("17.17.17.17", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("18.18.18.18", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("19.19.19.19", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("20.20.20.20", "/d4/r1")};
        for (int i = 0; i < this.dataNodes.length; ++i) {
            cluster.add((Node)this.dataNodes[i]);
        }
        this.dataNodes[9].setDecommissioned();
        this.dataNodes[10].setDecommissioned();
    }

    @Test
    public void testContains() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r4");
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assert.assertTrue((boolean)cluster.contains((Node)this.dataNodes[i]));
        }
        Assert.assertFalse((boolean)cluster.contains((Node)nodeNotInMap));
    }

    @Test
    public void testNumOfChildren() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfLeaves(), (long)this.dataNodes.length);
    }

    @Test
    public void testCreateInvalidTopology() throws Exception {
        NetworkTopology invalCluster = new NetworkTopology();
        DatanodeDescriptor[] invalDataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1")};
        invalCluster.add((Node)invalDataNodes[0]);
        invalCluster.add((Node)invalDataNodes[1]);
        try {
            invalCluster.add((Node)invalDataNodes[2]);
            Assert.fail((String)"expected InvalidTopologyException");
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Failed to add "));
            Assert.assertTrue((boolean)e.getMessage().contains("You cannot have a rack and a non-rack node at the same level of the network topology."));
        }
    }

    @Test
    public void testRacks() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfRacks(), (long)6L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[0], (Node)this.dataNodes[1]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[1], (Node)this.dataNodes[2]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[2], (Node)this.dataNodes[3]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[3], (Node)this.dataNodes[4]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[4], (Node)this.dataNodes[5]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[5], (Node)this.dataNodes[6]));
    }

    @Test
    public void testGetDistance() throws Exception {
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[0]), (long)0L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[1]), (long)2L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[3]), (long)4L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[6]), (long)6L);
    }

    @Test
    public void testSortByDistance() throws Exception {
        int i;
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{this.dataNodes[1], this.dataNodes[2], this.dataNodes[0]};
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assert.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[2] ? 1 : 0) != 0);
        DatanodeDescriptor[] dtestNodes = new DatanodeDescriptor[]{this.dataNodes[8], this.dataNodes[12], this.dataNodes[11], this.dataNodes[9], this.dataNodes[10]};
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[8], (Node[])dtestNodes, dtestNodes.length - 2);
        Assert.assertTrue((dtestNodes[0] == this.dataNodes[8] ? 1 : 0) != 0);
        Assert.assertTrue((dtestNodes[1] == this.dataNodes[11] ? 1 : 0) != 0);
        Assert.assertTrue((dtestNodes[2] == this.dataNodes[12] ? 1 : 0) != 0);
        Assert.assertTrue((dtestNodes[3] == this.dataNodes[9] ? 1 : 0) != 0);
        Assert.assertTrue((dtestNodes[4] == this.dataNodes[10] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[0];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assert.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[5];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[1];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assert.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[3];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assert.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[3];
        cluster.setRandomSeed(57005L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assert.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[5] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[3] ? 1 : 0) != 0);
        DatanodeDescriptor first = null;
        boolean foundRandom = false;
        for (i = 5; i <= 7; ++i) {
            testNodes[0] = this.dataNodes[5];
            testNodes[1] = this.dataNodes[6];
            testNodes[2] = this.dataNodes[7];
            cluster.sortByDistance((Node)this.dataNodes[i], (Node[])testNodes, testNodes.length);
            if (first == null) {
                first = testNodes[0];
                continue;
            }
            if (first == testNodes[0]) continue;
            foundRandom = true;
            break;
        }
        Assert.assertTrue((String)"Expected to find a different first location", (boolean)foundRandom);
        first = null;
        for (i = 1; i <= 4; ++i) {
            testNodes[0] = this.dataNodes[13];
            testNodes[1] = this.dataNodes[14];
            testNodes[2] = this.dataNodes[15];
            cluster.sortByDistance((Node)this.dataNodes[i], (Node[])testNodes, testNodes.length);
            if (first == null) {
                first = testNodes[0];
                continue;
            }
            if (first == testNodes[0]) continue;
            foundRandom = true;
            break;
        }
        Assert.assertTrue((String)"Expected to find a different first location", (boolean)foundRandom);
    }

    @Test
    public void testRemove() throws Exception {
        int i;
        for (i = 0; i < this.dataNodes.length; ++i) {
            cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < this.dataNodes.length; ++i) {
            Assert.assertFalse((boolean)cluster.contains((Node)this.dataNodes[i]));
        }
        Assert.assertEquals((long)0L, (long)cluster.getNumOfLeaves());
        for (i = 0; i < this.dataNodes.length; ++i) {
            cluster.add((Node)this.dataNodes[i]);
        }
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (DatanodeDescriptor dnd : this.dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    @Test
    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)this.dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (DatanodeDescriptor key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) > 0 || key == this.dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludedRack() {
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, "~/d2");
        for (int j = 0; j < this.dataNodes.length; ++j) {
            int freq = frequency.get(this.dataNodes[j]);
            if (this.dataNodes[j].getNetworkLocation().startsWith("/d2")) {
                Assert.assertEquals((long)0L, (long)freq);
                continue;
            }
            Assert.assertTrue((freq > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testInvalidNetworkTopologiesNotCachedInHdfs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            DatanodeInfo[] info;
            String[] racks = new String[]{"/a/b", "/c"};
            String[] hosts = new String[]{"foo1.example.com", "foo2.example.com"};
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).racks(racks).hosts(hosts).build();
            cluster.waitActive();
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            Assert.assertNotNull((Object)nn);
            while (true) {
                Assert.assertFalse(((info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length == 2 ? 1 : 0) != 0);
                if (info.length == 1) break;
                Thread.sleep(1000L);
            }
            int validIdx = info[0].getHostName().equals(hosts[0]) ? 0 : 1;
            int invalidIdx = validIdx == 1 ? 0 : 1;
            StaticMapping.addNodeToRack((String)hosts[invalidIdx], (String)racks[validIdx]);
            LOG.info("datanode " + validIdx + " came up with network location " + info[0].getNetworkLocation());
            cluster.restartDataNode(invalidIdx);
            Thread.sleep(5000L);
            while ((info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length != 2) {
                if (info.length == 0) {
                    LOG.info("got no valid DNs");
                } else if (info.length == 1) {
                    LOG.info("got one valid DN: " + info[0].getHostName() + " (at " + info[0].getNetworkLocation() + ")");
                }
                Thread.sleep(1000L);
            }
            Assert.assertEquals((Object)info[0].getNetworkLocation(), (Object)info[1].getNetworkLocation());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

