/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHdfsTestUtil {
    public static final Logger LOG = LoggerFactory.getLogger(WebHdfsTestUtil.class);

    public static Configuration createConf() {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        return conf;
    }

    public static WebHdfsFileSystem getWebHdfsFileSystem(Configuration conf, String scheme) throws IOException, URISyntaxException {
        String uri;
        if ("webhdfs".equals(scheme)) {
            uri = "webhdfs://" + conf.get("dfs.namenode.http-address");
        } else if ("swebhdfs".equals(scheme)) {
            uri = "swebhdfs://" + conf.get("dfs.namenode.https-address");
        } else {
            throw new IllegalArgumentException("unknown scheme:" + scheme);
        }
        return (WebHdfsFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)conf);
    }

    public static WebHdfsFileSystem getWebHdfsFileSystemAs(UserGroupInformation ugi, Configuration conf) throws IOException, InterruptedException {
        return WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, conf, "webhdfs");
    }

    public static WebHdfsFileSystem getWebHdfsFileSystemAs(UserGroupInformation ugi, final Configuration conf, String scheme) throws IOException, InterruptedException {
        return (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws Exception {
                return WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            }
        });
    }

    public static URL toUrl(WebHdfsFileSystem webhdfs, HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        URL url = webhdfs.toUrl(op, fspath, parameters);
        LOG.info("url=" + url);
        return url;
    }

    public static Map<?, ?> connectAndGetJson(HttpURLConnection conn, int expectedResponseCode) throws IOException {
        conn.connect();
        Assert.assertEquals((long)expectedResponseCode, (long)conn.getResponseCode());
        return WebHdfsFileSystem.jsonParse((HttpURLConnection)conn, (boolean)false);
    }
}

