/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetAddress;
import java.util.Random;
import org.apache.hadoop.hdfs.MiniMapRFSCluster;
import org.apache.hadoop.hdfs.NodeState;
import org.apache.hadoop.hdfs.RunCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapRNode {
    private static final Logger LOG = LoggerFactory.getLogger(MapRNode.class);
    public static final String ZOOKEEPER_HOME = "/opt/mapr/zookeeper/zookeeper-3.4.11";
    public static final String ZOOKEEPER_DATA = "/opt/mapr/zkdata";
    boolean isCldb;
    boolean isFileServer;
    boolean isZookeeper;
    int nodeId;
    int port;
    Process mfsPr;
    String logFile;
    String diskName;
    String hostnameFile;
    String hostIdFile;
    String localhost;
    boolean format;
    NodeState state;

    MapRNode() {
    }

    public void init(boolean isCldb, boolean isZookeeper, boolean isFileServer, int nodeId) {
        this.isCldb = isCldb;
        this.isZookeeper = isZookeeper;
        this.isFileServer = isFileServer;
        this.nodeId = nodeId;
        this.format = true;
        this.port = MiniMapRFSCluster.defaultMfsPort + nodeId;
        this.diskName = "/tmp/disk" + this.port + ".img";
        this.logFile = MiniMapRFSCluster.installDir + "/logs/mfs." + this.port + ".log";
        this.hostnameFile = MiniMapRFSCluster.installDir + "/hostname" + this.port;
        this.hostIdFile = MiniMapRFSCluster.installDir + "/hostid" + this.port;
        this.state = NodeState.STOPPED;
        try {
            this.localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[][] commands = new String[][]{{"/bin/sh", "-c", "dd bs=8192 seek=1048584 count=1 if=/dev/zero of=" + this.diskName}, {"/bin/sh", "-c", "echo host-" + this.port + " > " + this.hostnameFile}, {"/bin/sh", "-c", MiniMapRFSCluster.mruuidgen + " > " + this.hostIdFile}};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
        if (isCldb) {
            String[][] cldbCommands = new String[][]{{"/bin/sh", "-c", "/bin/hostname --fqdn > " + this.hostnameFile}, {"/bin/sh", "-c", "cp " + this.hostnameFile + " " + MiniMapRFSCluster.installDir + "/hostname"}, {"/bin/sh", "-c", "cp " + this.hostIdFile + " " + MiniMapRFSCluster.installDir + "/hostid"}, {"/bin/sh", "-c", "echo my.cluster.com " + this.localhost + ":" + MiniMapRFSCluster.cldbPort + " > " + MiniMapRFSCluster.maprClustersFile}};
            for (int i = 0; i < cldbCommands.length; ++i) {
                rc.init(cldbCommands[i], "", false, false);
                rc.Run();
            }
        }
    }

    public String GetName() {
        String name = Integer.toString(this.port);
        return name;
    }

    public NodeState State() {
        return this.state;
    }

    public void CleanUp() {
        this.StopCldb();
        this.CleanUpZookeeper();
        this.StopZookeeper();
        this.StopFileServer();
        String[] commands = new String[]{"rm " + this.diskName, "rm " + this.hostnameFile, "rm " + this.hostIdFile, "rm -rf /opt/mapr/zkdata"};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
    }

    public int Start() {
        this.StartZookeeper();
        if (this.format) {
            this.CleanUpZookeeper();
        }
        this.StartFileServer();
        if (this.format) {
            this.PrepareTheDisk();
        }
        this.MountTheDisk();
        this.ListSPs();
        this.StartCldb();
        this.format = false;
        this.state = NodeState.RUNNING;
        return 0;
    }

    void DecrementCldbVolMinReplica() {
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.maprCli + " volume modify -name mapr.cldb.internal -minreplication 1", "", false, false);
        rc.Run();
    }

    public int Stop() {
        this.DecrementCldbVolMinReplica();
        this.StopCldb();
        this.StopZookeeper();
        this.StopFileServer();
        return 0;
    }

    public int Kill() {
        this.DecrementCldbVolMinReplica();
        this.KillFileServer();
        this.StopCldb();
        this.StopZookeeper();
        return 0;
    }

    int ListSPs() {
        RunCommand rc = new RunCommand();
        rc.init("/opt/mapr/server/mrconfig -p " + this.port + " sp list", "", false, false);
        rc.Run();
        return 0;
    }

    public int MountTheDisk() {
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.testConfigPy + " -h " + this.localhost + " -p " + this.port + " -m single -d " + this.diskName, "", false, false);
        rc.Run();
        return 0;
    }

    int PrepareTheDisk() {
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.testConfigPy + " -h " + this.localhost + " -p " + this.port + " -P -s 8192 -d " + this.diskName, "", false, false);
        return rc.Run();
    }

    public int StartFileServer() {
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.mfsExe + " -e -p " + this.port + " -m 512 both -h " + this.hostnameFile + " -H " + this.hostIdFile + " -L " + this.logFile, "", true, false);
        rc.Run();
        this.mfsPr = rc.BGProcess();
        if (this.mfsPr != null) {
            LOG.info("mfsPr is non null");
        } else {
            LOG.info("mfsPr is null");
        }
        return 0;
    }

    public int StopFileServer() {
        return this.KillFileServer();
    }

    int KillFileServer() {
        if (this.mfsPr != null) {
            LOG.info("Killing mfs");
            this.mfsPr.destroy();
            this.mfsPr = null;
        }
        return 0;
    }

    int StartCldb() {
        if (!this.isCldb) {
            return 0;
        }
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.cldbInitScript + " start", "", false, false);
        return rc.Run();
    }

    int StopCldb() {
        if (!this.isCldb) {
            return 0;
        }
        RunCommand rc = new RunCommand();
        rc.init(MiniMapRFSCluster.cldbInitScript + " stop", "", false, false);
        return rc.Run();
    }

    int StartZookeeper() {
        if (!this.isZookeeper) {
            return 0;
        }
        String[] commands = new String[]{"/opt/mapr/zookeeper/zookeeper-3.4.11/bin/zkServer.sh start"};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
        return 0;
    }

    int CleanUpZookeeper() {
        if (!this.isZookeeper) {
            return 0;
        }
        String[] commands = new String[]{"/opt/mapr/zookeeper/zookeeper-3.4.11/bin/zkCli.sh -server localhost:5181 delete /datacenter/controlnodes/cldb/active/CLDBMaster", "/opt/mapr/zookeeper/zookeeper-3.4.11/bin/zkCli.sh -server localhost:5181 delete /datacenter/controlnodes/cldb/epoch/1/KvStoreContainerInfo"};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
        return 0;
    }

    int StopZookeeper() {
        if (!this.isZookeeper) {
            return 0;
        }
        String[] commands = new String[]{"/opt/mapr/zookeeper/zookeeper-3.4.11/bin/zkServer.sh stop"};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
        return 0;
    }

    public long getBlockNumber(String fid, long offset) throws Exception {
        this.Stop();
        RunCommand rc = new RunCommand();
        String[] cmd = new String[]{"/bin/sh", "-c", MiniMapRFSCluster.mfsdbFile + " " + this.diskName + " -c \"fid blocknum " + fid + "." + offset + "\""};
        rc.init(cmd, "", false, true);
        rc.Run();
        this.Start();
        return Long.parseLong(rc.OutPutStr());
    }

    boolean corruptBlock(long blockNum) throws Exception {
        this.Stop();
        Random random = new Random();
        String badString = "BADBAD";
        int rand = random.nextInt(MiniMapRFSCluster.blockSize / 2);
        boolean corrupted = false;
        RunCommand rc = new RunCommand();
        String[] cmd = new String[]{"/bin/sh", "-c", MiniMapRFSCluster.mfsdbFile + " " + this.diskName + " -c \"write " + blockNum + " " + rand + " " + badString + " string  \" "};
        rc.init(cmd, "", false, false);
        rc.Run();
        this.Start();
        return true;
    }
}

