/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobMonitor
implements Gridmix.Component<Statistics.JobStats> {
    public static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    private final Queue<Statistics.JobStats> mJobs;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private int numPollingThreads;
    private final BlockingQueue<Statistics.JobStats> runningJobs;
    private final long pollDelayMillis;
    private Statistics statistics;
    private boolean graceful = false;
    private boolean shutdown = false;

    public JobMonitor(int pollDelay, TimeUnit unit, Statistics statistics, int numPollingThreads) {
        this.numPollingThreads = numPollingThreads;
        this.runningJobs = new LinkedBlockingQueue<Statistics.JobStats>();
        this.mJobs = new LinkedList<Statistics.JobStats>();
        this.pollDelayMillis = TimeUnit.MILLISECONDS.convert(pollDelay, unit);
        this.statistics = statistics;
    }

    @Override
    public void add(Statistics.JobStats job) throws InterruptedException {
        this.runningJobs.put(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submissionFailed(Statistics.JobStats job) {
        String jobID = job.getJob().getConfiguration().get("gridmix.job.original-job-id");
        LOG.info("Job submission failed notification for job " + jobID);
        Statistics statistics = this.statistics;
        synchronized (statistics) {
            this.statistics.add(job);
        }
    }

    protected void onSuccess(Job job) {
        LOG.info(job.getJobName() + " (" + job.getJobID() + ") success");
    }

    protected void onFailure(Job job) {
        LOG.info(job.getJobName() + " (" + job.getJobID() + ") failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Statistics.JobStats> getRemainingJobs() {
        Queue<Statistics.JobStats> queue = this.mJobs;
        synchronized (queue) {
            return new ArrayList<Statistics.JobStats>(this.mJobs);
        }
    }

    @Override
    public void start() {
        for (int i = 0; i < this.numPollingThreads; ++i) {
            this.executor.execute(new MonitorThread(i));
        }
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.executor.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Queue<Statistics.JobStats> queue = this.mJobs;
        synchronized (queue) {
            this.graceful = false;
            this.shutdown = true;
        }
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Queue<Statistics.JobStats> queue = this.mJobs;
        synchronized (queue) {
            this.graceful = true;
            this.shutdown = true;
        }
        this.executor.shutdown();
    }

    private class MonitorThread
    extends Thread {
        public MonitorThread(int i) {
            super("GridmixJobMonitor-" + i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block30: while (true) {
                try {
                    while (true) {
                        boolean shutdown;
                        boolean graceful;
                        Queue<Statistics.JobStats> queue = JobMonitor.this.mJobs;
                        synchronized (queue) {
                            graceful = JobMonitor.this.graceful;
                            shutdown = JobMonitor.this.shutdown;
                            JobMonitor.this.runningJobs.drainTo(JobMonitor.this.mJobs);
                        }
                        if (shutdown) {
                            if (!graceful) {
                                while (!JobMonitor.this.runningJobs.isEmpty()) {
                                    queue = JobMonitor.this.mJobs;
                                    synchronized (queue) {
                                        JobMonitor.this.runningJobs.drainTo(JobMonitor.this.mJobs);
                                    }
                                }
                                break block30;
                            }
                            queue = JobMonitor.this.mJobs;
                            synchronized (queue) {
                                if (graceful && JobMonitor.this.mJobs.isEmpty()) {
                                    break block30;
                                }
                            }
                        }
                        Statistics.JobStats jobStats = null;
                        Queue<Statistics.JobStats> queue2 = JobMonitor.this.mJobs;
                        synchronized (queue2) {
                            jobStats = JobMonitor.this.mJobs.poll();
                        }
                        while (jobStats != null) {
                            block43: {
                                Job job = jobStats.getJob();
                                try {
                                    Object object;
                                    long start = System.currentTimeMillis();
                                    JobStatus status = job.getStatus();
                                    long end = System.currentTimeMillis();
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Status polling for job " + job.getJobID() + " took " + (end - start) + "ms.");
                                    }
                                    jobStats.updateJobStatus(status);
                                    if (status.isJobComplete()) {
                                        if (status.getState() == JobStatus.State.SUCCEEDED) {
                                            JobMonitor.this.onSuccess(job);
                                        } else {
                                            JobMonitor.this.onFailure(job);
                                        }
                                        object = JobMonitor.this.statistics;
                                        synchronized (object) {
                                            JobMonitor.this.statistics.add(jobStats);
                                            break block43;
                                        }
                                    }
                                    object = JobMonitor.this.mJobs;
                                    synchronized (object) {
                                        if (!JobMonitor.this.mJobs.offer(jobStats)) {
                                            LOG.error("Lost job " + (null == job.getJobName() ? "<unknown>" : job.getJobName()));
                                        }
                                        break;
                                    }
                                }
                                catch (IOException e) {
                                    if (e.getCause() instanceof ClosedByInterruptException) {
                                        Thread.currentThread().interrupt();
                                    }
                                    LOG.warn("Lost job " + (null == job.getJobName() ? "<unknown>" : job.getJobName()), (Throwable)e);
                                    Statistics statistics = JobMonitor.this.statistics;
                                    synchronized (statistics) {
                                        JobMonitor.this.statistics.add(jobStats);
                                    }
                                }
                            }
                            Queue<Statistics.JobStats> queue3 = JobMonitor.this.mJobs;
                            synchronized (queue3) {
                                jobStats = JobMonitor.this.mJobs.poll();
                            }
                        }
                        try {
                            TimeUnit.MILLISECONDS.sleep(JobMonitor.this.pollDelayMillis);
                            continue block30;
                        }
                        catch (InterruptedException e) {
                            shutdown = true;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Unexpected exception: ", e);
                    continue;
                }
                break;
            }
        }
    }
}

