/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

public class AzureLinkedStack<E> {
    private int count = 0;
    private AzureLinkedNode<E> top = null;

    public void push(E element) {
        AzureLinkedNode<E> newNode = new AzureLinkedNode<E>(element, this.top);
        this.top = newNode;
        ++this.count;
    }

    public E pop() throws Exception {
        if (this.isEmpty()) {
            throw new Exception("AzureStackEmpty");
        }
        E element = this.top.getElement();
        this.top = this.top.getNext();
        --this.count;
        return element;
    }

    public E peek() throws Exception {
        if (this.isEmpty()) {
            throw new Exception("AzureStackEmpty");
        }
        E element = this.top.getElement();
        return element;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        AzureLinkedNode<E> current = this.top;
        for (int i = 0; i < this.size(); ++i) {
            E element = current.getElement();
            sb.append(element.toString());
            current = current.getNext();
            if (this.size() - 1 <= i) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static class AzureLinkedNode<E> {
        private E element;
        private AzureLinkedNode<E> next;

        private AzureLinkedNode(E anElement) {
            this.element = anElement;
            this.next = null;
        }

        private AzureLinkedNode(E anElement, AzureLinkedNode<E> nextElement) {
            this.element = anElement;
            this.next = nextElement;
        }

        private E getElement() {
            return this.element;
        }

        private AzureLinkedNode<E> getNext() {
            return this.next;
        }
    }
}

