/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailTest
extends ClientBase {
    private CountDownLatch authFailed = new CountDownLatch(1);

    @Test
    public void testAuthFail() {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have gotten exception.");
        }
        catch (Exception e) {
            LOG.info("Got exception as expected: " + e);
        }
    }

    @Test
    public void testBadSaslAuthNotifiesWatch() throws Exception {
        try (TestableZooKeeper ignored = this.createClient(new MyWatcher(), this.hostPort);){
            this.authFailed.await();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        try {
            File tmpDir = SaslAuthFailTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test1\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslAuthFailTest.this.authFailed.countDown();
            } else {
                super.process(event);
            }
        }
    }
}

