/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.OSMXBean;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumBase
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumBase.class);
    private static final String LOCALADDR = "127.0.0.1";
    File s1dir;
    File s2dir;
    File s3dir;
    File s4dir;
    File s5dir;
    QuorumPeer s1;
    QuorumPeer s2;
    QuorumPeer s3;
    QuorumPeer s4;
    QuorumPeer s5;
    protected int port1;
    protected int port2;
    protected int port3;
    protected int port4;
    protected int port5;
    protected int portLE1;
    protected int portLE2;
    protected int portLE3;
    protected int portLE4;
    protected int portLE5;
    protected int portClient1;
    protected int portClient2;
    protected int portClient3;
    protected int portClient4;
    protected int portClient5;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = false;
    HashMap<Long, QuorumPeer.QuorumServer> peers = null;

    @Test
    public void testNull() {
    }

    @Override
    public void setUp() throws Exception {
        this.setUp(false);
    }

    protected void setUp(boolean withObservers) throws Exception {
        LOG.info("QuorumBase.setup " + this.getTestName());
        QuorumBase.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.port1 = PortAssignment.unique();
        this.port2 = PortAssignment.unique();
        this.port3 = PortAssignment.unique();
        this.port4 = PortAssignment.unique();
        this.port5 = PortAssignment.unique();
        this.portLE1 = PortAssignment.unique();
        this.portLE2 = PortAssignment.unique();
        this.portLE3 = PortAssignment.unique();
        this.portLE4 = PortAssignment.unique();
        this.portLE5 = PortAssignment.unique();
        this.portClient1 = PortAssignment.unique();
        this.portClient2 = PortAssignment.unique();
        this.portClient3 = PortAssignment.unique();
        this.portClient4 = PortAssignment.unique();
        this.portClient5 = PortAssignment.unique();
        this.hostPort = "127.0.0.1:" + this.portClient1 + ",127.0.0.1:" + this.portClient2 + ",127.0.0.1:" + this.portClient3 + ",127.0.0.1:" + this.portClient4 + ",127.0.0.1:" + this.portClient5;
        LOG.info("Ports are: " + this.hostPort);
        this.s1dir = ClientBase.createTmpDir();
        this.s2dir = ClientBase.createTmpDir();
        this.s3dir = ClientBase.createTmpDir();
        this.s4dir = ClientBase.createTmpDir();
        this.s5dir = ClientBase.createTmpDir();
        this.startServers(withObservers);
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            LOG.info("Initial fdcount is: " + osMbean.getOpenFileDescriptorCount());
        }
        LOG.info("Setup finished");
    }

    void startServers() throws Exception {
        this.startServers(false);
    }

    void startServers(boolean withObservers) throws Exception {
        int i;
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress(LOCALADDR, this.port1), new InetSocketAddress(LOCALADDR, this.portLE1), new InetSocketAddress(LOCALADDR, this.portClient1), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(LOCALADDR, this.port2), new InetSocketAddress(LOCALADDR, this.portLE2), new InetSocketAddress(LOCALADDR, this.portClient2), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress(LOCALADDR, this.port3), new InetSocketAddress(LOCALADDR, this.portLE3), new InetSocketAddress(LOCALADDR, this.portClient3), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(4L, new QuorumPeer.QuorumServer(4L, new InetSocketAddress(LOCALADDR, this.port4), new InetSocketAddress(LOCALADDR, this.portLE4), new InetSocketAddress(LOCALADDR, this.portClient4), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(5L, new QuorumPeer.QuorumServer(5L, new InetSocketAddress(LOCALADDR, this.port5), new InetSocketAddress(LOCALADDR, this.portLE5), new InetSocketAddress(LOCALADDR, this.portClient5), QuorumPeer.LearnerType.PARTICIPANT));
        if (withObservers) {
            ((QuorumPeer.QuorumServer)peers.get((Object)Long.valueOf((long)4L))).type = QuorumPeer.LearnerType.OBSERVER;
            ((QuorumPeer.QuorumServer)peers.get((Object)Long.valueOf((long)5L))).type = QuorumPeer.LearnerType.OBSERVER;
        }
        LOG.info("creating QuorumPeer 1 port " + this.portClient1);
        this.s1 = new QuorumPeer(peers, this.s1dir, this.s1dir, this.portClient1, 3, 1L, tickTime, initLimit, syncLimit);
        Assert.assertEquals((long)this.portClient1, (long)this.s1.getClientPort());
        LOG.info("creating QuorumPeer 2 port " + this.portClient2);
        this.s2 = new QuorumPeer(peers, this.s2dir, this.s2dir, this.portClient2, 3, 2L, tickTime, initLimit, syncLimit);
        Assert.assertEquals((long)this.portClient2, (long)this.s2.getClientPort());
        LOG.info("creating QuorumPeer 3 port " + this.portClient3);
        this.s3 = new QuorumPeer(peers, this.s3dir, this.s3dir, this.portClient3, 3, 3L, tickTime, initLimit, syncLimit);
        Assert.assertEquals((long)this.portClient3, (long)this.s3.getClientPort());
        LOG.info("creating QuorumPeer 4 port " + this.portClient4);
        this.s4 = new QuorumPeer(peers, this.s4dir, this.s4dir, this.portClient4, 3, 4L, tickTime, initLimit, syncLimit);
        Assert.assertEquals((long)this.portClient4, (long)this.s4.getClientPort());
        LOG.info("creating QuorumPeer 5 port " + this.portClient5);
        this.s5 = new QuorumPeer(peers, this.s5dir, this.s5dir, this.portClient5, 3, 5L, tickTime, initLimit, syncLimit);
        Assert.assertEquals((long)this.portClient5, (long)this.s5.getClientPort());
        if (withObservers) {
            this.s4.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
            this.s5.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        LOG.info("QuorumPeer 1 voting view: " + this.s1.getVotingView());
        LOG.info("QuorumPeer 2 voting view: " + this.s2.getVotingView());
        LOG.info("QuorumPeer 3 voting view: " + this.s3.getVotingView());
        LOG.info("QuorumPeer 4 voting view: " + this.s4.getVotingView());
        LOG.info("QuorumPeer 5 voting view: " + this.s5.getVotingView());
        this.s1.enableLocalSessions(this.localSessionsEnabled);
        this.s2.enableLocalSessions(this.localSessionsEnabled);
        this.s3.enableLocalSessions(this.localSessionsEnabled);
        this.s4.enableLocalSessions(this.localSessionsEnabled);
        this.s5.enableLocalSessions(this.localSessionsEnabled);
        this.s1.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        this.s2.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        this.s3.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        this.s4.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        this.s5.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        LOG.info("start QuorumPeer 1");
        this.s1.start();
        LOG.info("start QuorumPeer 2");
        this.s2.start();
        LOG.info("start QuorumPeer 3");
        this.s3.start();
        LOG.info("start QuorumPeer 4");
        this.s4.start();
        LOG.info("start QuorumPeer 5");
        this.s5.start();
        LOG.info("started QuorumPeer 5");
        LOG.info("Checking ports " + this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        JMXEnv.dump();
        LinkedHashSet<Object> ensureNames = new LinkedHashSet<Object>();
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("InMemoryDataTree");
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
        }
        for (i = 1; i <= 5; ++i) {
            for (int j = 1; j <= 5; ++j) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
            }
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i);
        }
        JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
    }

    public int getLeaderIndex() {
        if (this.s1.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 0;
        }
        if (this.s2.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 1;
        }
        if (this.s3.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 2;
        }
        if (this.s4.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 3;
        }
        if (this.s5.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 4;
        }
        return -1;
    }

    public String getPeersMatching(QuorumPeer.ServerState state) {
        StringBuilder hosts = new StringBuilder();
        for (QuorumPeer p : this.getPeerList()) {
            if (p.getPeerState() != state) continue;
            hosts.append(String.format("%s:%d,", LOCALADDR, p.getClientAddress().getPort()));
        }
        LOG.info("getPeersMatching ports are {}", (Object)hosts);
        return hosts.toString();
    }

    public ArrayList<QuorumPeer> getPeerList() {
        ArrayList<QuorumPeer> peers = new ArrayList<QuorumPeer>();
        peers.add(this.s1);
        peers.add(this.s2);
        peers.add(this.s3);
        peers.add(this.s4);
        peers.add(this.s5);
        return peers;
    }

    public void setupServers() throws IOException {
        this.setupServer(1);
        this.setupServer(2);
        this.setupServer(3);
        this.setupServer(4);
        this.setupServer(5);
    }

    public void setupServer(int i) throws IOException {
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        if (this.peers == null) {
            this.peers = new HashMap();
            this.peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress(LOCALADDR, this.port1), new InetSocketAddress(LOCALADDR, this.portLE1), new InetSocketAddress(LOCALADDR, this.portClient1), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(LOCALADDR, this.port2), new InetSocketAddress(LOCALADDR, this.portLE2), new InetSocketAddress(LOCALADDR, this.portClient2), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress(LOCALADDR, this.port3), new InetSocketAddress(LOCALADDR, this.portLE3), new InetSocketAddress(LOCALADDR, this.portClient3), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(4L, new QuorumPeer.QuorumServer(4L, new InetSocketAddress(LOCALADDR, this.port4), new InetSocketAddress(LOCALADDR, this.portLE4), new InetSocketAddress(LOCALADDR, this.portClient4), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(5L, new QuorumPeer.QuorumServer(5L, new InetSocketAddress(LOCALADDR, this.port5), new InetSocketAddress(LOCALADDR, this.portLE5), new InetSocketAddress(LOCALADDR, this.portClient5), QuorumPeer.LearnerType.PARTICIPANT));
        }
        switch (i) {
            case 1: {
                LOG.info("creating QuorumPeer 1 port " + this.portClient1);
                this.s1 = new QuorumPeer(this.peers, this.s1dir, this.s1dir, this.portClient1, 3, 1L, tickTime, initLimit, syncLimit);
                Assert.assertEquals((long)this.portClient1, (long)this.s1.getClientPort());
                break;
            }
            case 2: {
                LOG.info("creating QuorumPeer 2 port " + this.portClient2);
                this.s2 = new QuorumPeer(this.peers, this.s2dir, this.s2dir, this.portClient2, 3, 2L, tickTime, initLimit, syncLimit);
                Assert.assertEquals((long)this.portClient2, (long)this.s2.getClientPort());
                break;
            }
            case 3: {
                LOG.info("creating QuorumPeer 3 port " + this.portClient3);
                this.s3 = new QuorumPeer(this.peers, this.s3dir, this.s3dir, this.portClient3, 3, 3L, tickTime, initLimit, syncLimit);
                Assert.assertEquals((long)this.portClient3, (long)this.s3.getClientPort());
                break;
            }
            case 4: {
                LOG.info("creating QuorumPeer 4 port " + this.portClient4);
                this.s4 = new QuorumPeer(this.peers, this.s4dir, this.s4dir, this.portClient4, 3, 4L, tickTime, initLimit, syncLimit);
                Assert.assertEquals((long)this.portClient4, (long)this.s4.getClientPort());
                break;
            }
            case 5: {
                LOG.info("creating QuorumPeer 5 port " + this.portClient5);
                this.s5 = new QuorumPeer(this.peers, this.s5dir, this.s5dir, this.portClient5, 3, 5L, tickTime, initLimit, syncLimit);
                Assert.assertEquals((long)this.portClient5, (long)this.s5.getClientPort());
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            LOG.info("fdcount after test is: " + osMbean.getOpenFileDescriptorCount());
        }
        this.shutdownServers();
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is no longer accepting client connections");
        }
        JMXEnv.tearDown();
    }

    public void shutdownServers() {
        QuorumBase.shutdown(this.s1);
        QuorumBase.shutdown(this.s2);
        QuorumBase.shutdown(this.s3);
        QuorumBase.shutdown(this.s4);
        QuorumBase.shutdown(this.s5);
    }

    public static void shutdown(QuorumPeer qp) {
        if (qp == null) {
            return;
        }
        try {
            LOG.info("Shutting down quorum peer " + qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election " + qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown " + qp.getName());
            }
            LOG.info("Waiting for " + qp.getName() + " to exit thread");
            long readTimeout = qp.getTickTime() * qp.getInitLimit();
            long connectTimeout = qp.getTickTime() * qp.getSyncLimit();
            long maxTimeout = Math.max(readTimeout, connectTimeout);
            maxTimeout = Math.max(maxTimeout, (long)ClientBase.CONNECTION_TIMEOUT);
            qp.join(maxTimeout * 2L);
            if (qp.isAlive()) {
                Assert.fail((String)("QP failed to shutdown in " + maxTimeout * 2L + " seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: " + qp.getName(), (Throwable)e);
        }
    }

    @Override
    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(ClientBase.CountdownWatcher watcher, QuorumPeer.ServerState state) throws IOException, InterruptedException {
        return this.createClient(watcher, this.getPeersMatching(state));
    }
}

