/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetSocketAddress;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.ConnectStringParser;
import org.junit.Assert;
import org.junit.Test;

public class ConnectStringParserTest
extends ZKTestCase {
    @Test
    public void testSingleServerChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testMultipleServersChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1,10.10.10.2";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testParseServersWithoutPort() {
        String servers = "10.10.10.1,10.10.10.2";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"10.10.10.1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assert.assertEquals((Object)"10.10.10.2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
    }

    @Test
    public void testParseServersWithPort() {
        String servers = "10.10.10.1:112,10.10.10.2:110";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"10.10.10.1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assert.assertEquals((Object)"10.10.10.2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assert.assertEquals((long)112L, (long)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assert.assertEquals((long)110L, (long)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
    }

    private void assertChrootPath(String expected, ConnectStringParser parser) {
        Assert.assertEquals((Object)expected, (Object)parser.getChrootPath());
    }
}

