/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientSSLTest
extends QuorumPeerTestBase {
    private ClientX509Util clientX509Util;

    @Before
    public void setup() {
        this.clientX509Util = new ClientX509Util();
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty(this.clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(this.clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.clientX509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(this.clientX509Util.getSslTruststorePasswdProperty(), "testpass");
    }

    @After
    public void teardown() throws Exception {
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(this.clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        this.clientX509Util.close();
    }

    @Test
    public void testClientServerSSL() throws Exception {
        int i;
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        Integer[] secureClientPorts = new Integer[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            secureClientPorts[i2] = PortAssignment.unique();
            String server = String.format("server.%d=localhost:%d:%d:participant;localhost:%d", i2, PortAssignment.unique(), PortAssignment.unique(), clientPorts[i2]);
            sb.append(server + "\n");
        }
        String quorumCfg = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, quorumCfg, secureClientPorts[i], true);
            mt[i].start();
        }
        ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[0], 10000L);
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 5000L));
            ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + secureClientPorts[i], 5000);
            zk.create("/test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.delete("/test", -1);
            zk.close();
        }
        for (i = 0; i < mt.length; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testSecureStandaloneServer() throws Exception {
        Integer secureClientPort = PortAssignment.unique();
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, "", secureClientPort, false);
        mt.start();
        ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + secureClientPort, 5000);
        zk.create("/test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.delete("/test", -1);
        zk.close();
        mt.shutdown();
    }
}

