/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.Assert;
import org.junit.Test;

public class ReconfigRollingRestartCompatibilityTest
extends QuorumPeerTestBase {
    private static final String ZOO_CFG_BAK_FILE = "zoo.cfg.bak";
    Map<Integer, Integer> clientPorts = new HashMap<Integer, Integer>(5);
    Map<Integer, String> serverAddress = new HashMap<Integer, String>(5);

    private String generateNewQuorumConfig(int serverCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < serverCount; ++i) {
            this.clientPorts.put(i, PortAssignment.unique());
            String server = "server." + i + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + this.clientPorts.get(i);
            this.serverAddress.put(i, server);
            sb.append(server + "\n");
        }
        return sb.toString();
    }

    private String updateExistingQuorumConfig(List<Integer> sidsToAdd, List<Integer> sidsToRemove) {
        StringBuilder sb = new StringBuilder();
        for (Integer sid : sidsToAdd) {
            this.clientPorts.put(sid, PortAssignment.unique());
            this.serverAddress.put(sid, "server." + sid + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + this.clientPorts.get(sid));
        }
        for (Integer sid : sidsToRemove) {
            this.clientPorts.remove(sid);
            this.serverAddress.remove(sid);
        }
        for (String server : this.serverAddress.values()) {
            sb.append(server + "\n");
        }
        return sb.toString();
    }

    @Test(timeout=60000L)
    public void testNoLocalDynamicConfigAndBackupFiles() throws InterruptedException, IOException {
        int i;
        int serverCount = 3;
        String config = this.generateNewQuorumConfig(serverCount);
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[serverCount];
        String[] staticFileContent = new String[serverCount];
        for (i = 0; i < serverCount; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, (int)this.clientPorts.get(i), config, false);
            mt[i].start();
        }
        for (i = 0; i < serverCount; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts.get(i), ClientBase.CONNECTION_TIMEOUT));
            Assert.assertNull((String)"static file backup (zoo.cfg.bak) shouldn't exist!", (Object)mt[i].getFileByName(ZOO_CFG_BAK_FILE));
            Assert.assertNull((String)"dynamic configuration file (zoo.cfg.dynamic.*) shouldn't exist!", (Object)mt[i].getFileByName(mt[i].getQuorumPeer().getNextDynamicConfigFilename()));
            staticFileContent[i] = Files.readAllLines(mt[i].confFile.toPath(), StandardCharsets.UTF_8).toString();
            Assert.assertTrue((String)("static config file should contain server entry " + this.serverAddress.get(i)), (boolean)staticFileContent[i].contains(this.serverAddress.get(i)));
        }
        for (i = 0; i < serverCount; ++i) {
            mt[i].shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testRollingRestartWithoutMembershipChange() throws Exception {
        int i;
        int serverCount = 3;
        String config = this.generateNewQuorumConfig(serverCount);
        ArrayList<String> joiningServers = new ArrayList<String>();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[serverCount];
        for (i = 0; i < serverCount; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, (int)this.clientPorts.get(i), config, false);
            mt[i].start();
            joiningServers.add(this.serverAddress.get(i));
        }
        for (i = 0; i < serverCount; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts.get(i), ClientBase.CONNECTION_TIMEOUT));
        }
        for (i = 0; i < serverCount; ++i) {
            mt[i].shutdown();
            mt[i].start();
            this.verifyQuorumConfig(i, joiningServers, null);
            this.verifyQuorumMembers(mt[i]);
        }
        for (i = 0; i < serverCount; ++i) {
            mt[i].shutdown();
        }
    }

    @Test(timeout=90000L)
    public void testRollingRestartWithMembershipChange() throws Exception {
        int i;
        int i2;
        int serverCount = 3;
        String config = this.generateNewQuorumConfig(serverCount);
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[serverCount];
        ArrayList<String> joiningServers = new ArrayList<String>();
        for (i2 = 0; i2 < serverCount; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, (int)this.clientPorts.get(i2), config, false);
            mt[i2].start();
            joiningServers.add(this.serverAddress.get(i2));
        }
        for (i2 = 0; i2 < serverCount; ++i2) {
            Assert.assertTrue((String)("waiting for server " + i2 + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts.get(i2), ClientBase.CONNECTION_TIMEOUT));
        }
        for (i2 = 0; i2 < serverCount; ++i2) {
            this.verifyQuorumConfig(i2, joiningServers, null);
            this.verifyQuorumMembers(mt[i2]);
        }
        HashMap<Integer, String> oldServerAddress = new HashMap<Integer, String>(this.serverAddress);
        ArrayList<String> newServers = new ArrayList<String>(joiningServers);
        config = this.updateExistingQuorumConfig(Arrays.asList(3, 4), new ArrayList<Integer>());
        newServers.add(this.serverAddress.get(3));
        newServers.add(this.serverAddress.get(4));
        serverCount = this.serverAddress.size();
        Assert.assertEquals((String)"Server count should be 5 after config update.", (long)serverCount, (long)5L);
        mt = Arrays.copyOf(mt, mt.length + 2);
        for (int i3 = 3; i3 < 5; ++i3) {
            mt[i3] = new QuorumPeerTestBase.MainThread(i3, (int)this.clientPorts.get(i3), config, false);
            mt[i3].start();
            Assert.assertTrue((String)("waiting for server " + i3 + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts.get(i3), ClientBase.CONNECTION_TIMEOUT));
            this.verifyQuorumConfig(i3, newServers, null);
            this.verifyQuorumMembers(mt[i3]);
        }
        HashSet<String> expectedConfigs = new HashSet<String>();
        for (String conf : oldServerAddress.values()) {
            expectedConfigs.add(conf.substring(conf.indexOf(61) + 1));
        }
        for (i = 0; i < 3; ++i) {
            this.verifyQuorumConfig(i, joiningServers, null);
            this.verifyQuorumMembers(mt[i], expectedConfigs);
        }
        for (i = 0; i < serverCount; ++i) {
            mt[i].shutdown();
        }
    }

    private void verifyQuorumConfig(int sid, List<String> joiningServers, List<String> leavingServers) throws Exception {
        ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + this.clientPorts.get(sid));
        ReconfigTest.testNormalOperation(zk, zk);
        ReconfigTest.testServerHasConfig(zk, joiningServers, leavingServers);
        zk.close();
    }

    private void verifyQuorumMembers(QuorumPeerTestBase.MainThread mt) {
        HashSet<String> expectedConfigs = new HashSet<String>();
        for (String config : this.serverAddress.values()) {
            expectedConfigs.add(config.substring(config.indexOf(61) + 1));
        }
        this.verifyQuorumMembers(mt, expectedConfigs);
    }

    private void verifyQuorumMembers(QuorumPeerTestBase.MainThread mt, Set<String> expectedConfigs) {
        Map members = mt.getQuorumPeer().getQuorumVerifier().getAllMembers();
        Assert.assertTrue((String)"Quorum member should not change.", (members.size() == expectedConfigs.size() ? 1 : 0) != 0);
        for (QuorumPeer.QuorumServer qs : members.values()) {
            String actualConfig = qs.toString();
            Assert.assertTrue((String)("Unexpected config " + actualConfig + " found!"), (boolean)expectedConfigs.contains(actualConfig));
        }
    }
}

