/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.Assert;
import org.junit.Test;

public class QuorumServerTest
extends ZKTestCase {
    @Test
    public void testToString() throws QuorumPeerConfig.ConfigException {
        String config = "127.0.0.1:1234:1236:participant;0.0.0.0:1237";
        String expected = "127.0.0.1:1234:1236:participant;0.0.0.0:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Use IP address", (Object)expected, (Object)qs.toString());
        config = "127.0.0.1:1234:1236;0.0.0.0:1237";
        expected = "127.0.0.1:1234:1236:participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Type unspecified", (Object)expected, (Object)qs.toString());
        config = "127.0.0.1:1234:1236:observer;0.0.0.0:1237";
        expected = "127.0.0.1:1234:1236:observer;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Observer type", (Object)expected, (Object)qs.toString());
        config = "127.0.0.1:1234:1236:participant;1237";
        expected = "127.0.0.1:1234:1236:participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Client address unspecified", (Object)expected, (Object)qs.toString());
        config = "127.0.0.1:1234:1236:participant;1.2.3.4:1237";
        expected = "127.0.0.1:1234:1236:participant;1.2.3.4:1237";
        qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Client address specified", (Object)expected, (Object)qs.toString());
        config = "example.com:1234:1236:participant;1237";
        expected = "example.com:1234:1236:participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((String)"Use hostname", (Object)expected, (Object)qs.toString());
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInServerConfig() throws QuorumPeerConfig.ConfigException {
        String config = "[::1]:1234:1236:participant";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((Object)"[0:0:0:0:0:0:0:1]:1234:1236:participant", (Object)qs.toString());
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInClientConfig() throws QuorumPeerConfig.ConfigException {
        String config = "127.0.0.1:1234:1236:participant;[::1]:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((Object)"127.0.0.1:1234:1236:participant;[0:0:0:0:0:0:0:1]:1237", (Object)qs.toString());
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void unbalancedIpv6LiteralsInServerConfigFailToBeParsed() throws QuorumPeerConfig.ConfigException {
        new QuorumPeer.QuorumServer(0L, "[::1:1234:1236:participant");
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void unbalancedIpv6LiteralsInClientConfigFailToBeParsed() throws QuorumPeerConfig.ConfigException {
        new QuorumPeer.QuorumServer(0L, "127.0.0.1:1234:1236:participant;[::1:1237");
    }
}

