/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FLETestUtils;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLELostMessageTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLELostMessageTest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    QuorumCnxManager cnxManager;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
    }

    @After
    public void tearDown() throws Exception {
        this.cnxManager.halt();
    }

    @Test
    public void testLostMessage() throws Exception {
        LOG.info("TestLE: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(clientport), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[1], this.tmpdir[1], this.port[1], 3, 1L, 1000, 2, 2);
        peer.startLeaderElection();
        FLETestUtils.LEThread thread = new FLETestUtils.LEThread(peer, 1);
        thread.start();
        this.mockServer();
        thread.join(5000L);
        if (thread.isAlive()) {
            Assert.fail((String)"Threads didn't join");
        }
    }

    void mockServer() throws InterruptedException, IOException {
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 1000, 2, 2);
        this.cnxManager = peer.createCnxnManager();
        this.cnxManager.listener.start();
        this.cnxManager.toSend(Long.valueOf(1L), FLETestUtils.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 0L, 0L, 0L));
        this.cnxManager.recvQueue.take();
        this.cnxManager.toSend(Long.valueOf(1L), FLETestUtils.createMsg(QuorumPeer.ServerState.FOLLOWING.ordinal(), 1L, 0L, 0L));
    }
}

