/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitProcessorTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(CommitProcessorTest.class);
    private AtomicInteger processedReadRequests = new AtomicInteger(0);
    private AtomicInteger processedWriteRequests = new AtomicInteger(0);
    TestZooKeeperServer zks;
    File tmpDir;
    ArrayList<TestClientThread> testClients = new ArrayList();
    volatile boolean fail = false;

    public void setUp(int numCommitThreads, int numClientThreads) throws Exception {
        System.setProperty("zookeeper.commitProcessor.numWorkerThreads", Integer.toString(numCommitThreads));
        System.setProperty("zookeeper.admin.enableServer", "false");
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        this.zks = new TestZooKeeperServer(this.tmpDir, this.tmpDir, 4000);
        this.zks.startup();
        for (int i = 0; i < numClientThreads; ++i) {
            TestClientThread client = new TestClientThread();
            this.testClients.add(client);
            client.start();
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        for (TestClientThread client : this.testClients) {
            client.interrupt();
            client.join();
        }
        this.zks.shutdown();
        if (this.tmpDir != null) {
            Assert.assertTrue((String)("delete " + this.tmpDir.toString()), (boolean)ClientBase.recursiveDelete(this.tmpDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoCommitWorkers() throws Exception {
        this.setUp(0, 10);
        CommitProcessorTest commitProcessorTest = this;
        synchronized (commitProcessorTest) {
            this.wait(5000L);
        }
        this.checkProcessedRequest();
        Assert.assertFalse((boolean)this.fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneCommitWorker() throws Exception {
        this.setUp(1, 10);
        CommitProcessorTest commitProcessorTest = this;
        synchronized (commitProcessorTest) {
            this.wait(5000L);
        }
        this.checkProcessedRequest();
        Assert.assertFalse((boolean)this.fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManyCommitWorkers() throws Exception {
        this.setUp(10, 10);
        CommitProcessorTest commitProcessorTest = this;
        synchronized (commitProcessorTest) {
            this.wait(5000L);
        }
        this.checkProcessedRequest();
        Assert.assertFalse((boolean)this.fail);
    }

    private void checkProcessedRequest() {
        Assert.assertTrue((String)"No read requests processed", (this.processedReadRequests.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No write requests processed", (this.processedWriteRequests.get() > 0 ? 1 : 0) != 0);
    }

    private synchronized void failTest(String reason) {
        this.fail = true;
        this.notifyAll();
        Assert.fail((String)reason);
    }

    private class ValidateProcessor
    implements RequestProcessor {
        Random rand = new Random(Thread.currentThread().getId());
        RequestProcessor nextProcessor;
        CommitProcessor commitProcessor;
        AtomicLong expectedZxid = new AtomicLong(1L);
        ConcurrentHashMap<Long, AtomicInteger> cxidMap = new ConcurrentHashMap();
        AtomicInteger outstandingReadRequests = new AtomicInteger(0);
        AtomicInteger outstandingWriteRequests = new AtomicInteger(0);

        public ValidateProcessor(RequestProcessor nextProcessor) {
            this.nextProcessor = nextProcessor;
        }

        public void setCommitProcessor(CommitProcessor commitProcessor) {
            this.commitProcessor = commitProcessor;
        }

        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            boolean isWriteRequest = this.commitProcessor.needCommit(request);
            if (isWriteRequest) {
                this.outstandingWriteRequests.incrementAndGet();
                this.validateWriteRequestVariant(request);
                LOG.debug("Starting write request zxid=" + request.zxid);
            } else {
                LOG.debug("Starting read request cxid=" + request.cxid + " for session 0x" + Long.toHexString(request.sessionId));
                this.outstandingReadRequests.incrementAndGet();
                this.validateReadRequestVariant(request);
            }
            try {
                Thread.sleep(10 + this.rand.nextInt(290));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextProcessor.processRequest(request);
            if (isWriteRequest) {
                this.outstandingWriteRequests.decrementAndGet();
                LOG.debug("Done write request zxid=" + request.zxid);
                CommitProcessorTest.this.processedWriteRequests.incrementAndGet();
            } else {
                this.outstandingReadRequests.decrementAndGet();
                LOG.debug("Done read request cxid=" + request.cxid + " for session 0x" + Long.toHexString(request.sessionId));
                CommitProcessorTest.this.processedReadRequests.incrementAndGet();
            }
            this.validateRequest(request);
        }

        private void validateWriteRequestVariant(Request request) {
            int writeRequests;
            long zxid = request.getHdr().getZxid();
            int readRequests = this.outstandingReadRequests.get();
            if (readRequests != 0) {
                CommitProcessorTest.this.failTest("There are " + readRequests + " outstanding read requests while issuing a write request zxid=" + zxid);
            }
            if ((writeRequests = this.outstandingWriteRequests.get()) > 1) {
                CommitProcessorTest.this.failTest("There are " + writeRequests + " outstanding write requests while issuing a write request zxid=" + zxid + " (expected one)");
            }
        }

        private void validateReadRequestVariant(Request request) {
            int writeRequests = this.outstandingWriteRequests.get();
            if (writeRequests != 0) {
                CommitProcessorTest.this.failTest("There are " + writeRequests + " outstanding write requests while issuing a read request cxid=" + request.cxid + " for session 0x" + Long.toHexString(request.sessionId));
            }
        }

        private void validateRequest(Request request) {
            AtomicInteger sessionCxid;
            long zxid;
            LOG.info("Got request " + request);
            if (request.getHdr() != null && !this.expectedZxid.compareAndSet(zxid = request.getHdr().getZxid(), zxid + 1L)) {
                CommitProcessorTest.this.failTest("Write request, expected_zxid=" + this.expectedZxid.get() + "; req_zxid=" + zxid);
            }
            if ((sessionCxid = this.cxidMap.get(request.sessionId)) == null) {
                sessionCxid = new AtomicInteger(request.cxid + 1);
                AtomicInteger existingSessionCxid = this.cxidMap.putIfAbsent(request.sessionId, sessionCxid);
                if (existingSessionCxid != null) {
                    CommitProcessorTest.this.failTest("Race condition adding cxid=" + request.cxid + " for session 0x" + Long.toHexString(request.sessionId) + " with other_cxid=" + existingSessionCxid.get());
                }
            } else if (!sessionCxid.compareAndSet(request.cxid, request.cxid + 1)) {
                CommitProcessorTest.this.failTest("Expected_cxid=" + sessionCxid.get() + "; req_cxid=" + request.cxid);
            }
        }

        public void shutdown() {
        }
    }

    private class MockProposalRequestProcessor
    extends Thread
    implements RequestProcessor {
        private final CommitProcessor commitProcessor;
        private final LinkedBlockingQueue<Request> proposals = new LinkedBlockingQueue();

        public MockProposalRequestProcessor(CommitProcessor commitProcessor) {
            this.commitProcessor = commitProcessor;
        }

        @Override
        public void run() {
            Random rand = new Random(Thread.currentThread().getId());
            try {
                while (true) {
                    Request request = this.proposals.take();
                    Thread.sleep(10 + rand.nextInt(190));
                    this.commitProcessor.commit(request);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            this.commitProcessor.processRequest(request);
            if (request.getHdr() != null) {
                this.proposals.add(request);
            }
        }

        public void shutdown() {
        }
    }

    private class TestZooKeeperServer
    extends ZooKeeperServer {
        PrepRequestProcessor firstProcessor;
        CommitProcessor commitProcessor;

        public TestZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
            super(snapDir, logDir, tickTime);
        }

        public SessionTracker getSessionTracker() {
            return this.sessionTracker;
        }

        protected void setupRequestProcessors() {
            FinalRequestProcessor finalProcessor = new FinalRequestProcessor((ZooKeeperServer)CommitProcessorTest.this.zks);
            ValidateProcessor validateProcessor = new ValidateProcessor((RequestProcessor)finalProcessor);
            this.commitProcessor = new CommitProcessor((RequestProcessor)validateProcessor, "1", true, this.getZooKeeperServerListener());
            validateProcessor.setCommitProcessor(this.commitProcessor);
            this.commitProcessor.start();
            MockProposalRequestProcessor proposalProcessor = new MockProposalRequestProcessor(this.commitProcessor);
            proposalProcessor.start();
            this.firstProcessor = new PrepRequestProcessor((ZooKeeperServer)CommitProcessorTest.this.zks, (RequestProcessor)proposalProcessor);
            this.firstProcessor.start();
        }
    }

    private class TestClientThread
    extends Thread {
        long sessionId;
        int cxid;
        int nodeId;

        public TestClientThread() {
            this.sessionId = CommitProcessorTest.this.zks.getSessionTracker().createSession(5000);
        }

        public void sendWriteRequest() throws Exception {
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
            CreateRequest createReq = new CreateRequest("/session" + Long.toHexString(this.sessionId) + "-" + ++this.nodeId, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 1);
            createReq.serialize((OutputArchive)boa, "request");
            ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
            Request req = new Request(null, this.sessionId, ++this.cxid, 1, bb, new ArrayList());
            CommitProcessorTest.this.zks.firstProcessor.processRequest(req);
        }

        public void sendReadRequest() throws Exception {
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
            GetDataRequest getDataRequest = new GetDataRequest("/session" + Long.toHexString(this.sessionId) + "-" + this.nodeId, false);
            getDataRequest.serialize((OutputArchive)boa, "request");
            ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
            Request req = new Request(null, this.sessionId, ++this.cxid, 4, bb, new ArrayList());
            CommitProcessorTest.this.zks.firstProcessor.processRequest(req);
        }

        @Override
        public void run() {
            Random rand = new Random(Thread.currentThread().getId());
            try {
                this.sendWriteRequest();
                for (int i = 0; i < 1000; ++i) {
                    if (rand.nextInt(100) < 25) {
                        this.sendWriteRequest();
                        continue;
                    }
                    this.sendReadRequest();
                }
            }
            catch (Exception e) {
                LOG.error("Uncaught exception in test: ", (Throwable)e);
            }
        }
    }
}

