/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.jute.Record;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.TestUtils;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileTxnSnapLogTest {
    private File tmpDir;
    private File logDir;
    private File snapDir;
    private File logVersionDir;
    private File snapVersionDir;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createEmptyTestDir();
        this.logDir = new File(this.tmpDir, "logdir");
        this.snapDir = new File(this.tmpDir, "snapdir");
    }

    @After
    public void tearDown() throws Exception {
        if (this.tmpDir != null) {
            TestUtils.deleteFileRecursively(this.tmpDir);
        }
        this.tmpDir = null;
        this.logDir = null;
        this.snapDir = null;
        this.logVersionDir = null;
        this.snapVersionDir = null;
    }

    private File createVersionDir(File parentDir) {
        File versionDir = new File(parentDir, "version-2");
        versionDir.mkdirs();
        return versionDir;
    }

    private void createLogFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeLogName((long)zxid));
        file.createNewFile();
    }

    private void createSnapshotFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeSnapshotName((long)zxid));
        file.createNewFile();
    }

    private void twoDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.snapVersionDir = this.createVersionDir(this.snapDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.snapVersionDir, 1L);
        this.createSnapshotFile(this.snapVersionDir, 2L);
    }

    private void singleDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.logVersionDir, 1L);
        this.createSnapshotFile(this.logVersionDir, 2L);
    }

    private FileTxnSnapLog createFileTxnSnapLogWithNoAutoCreateDataDir(File logDir, File snapDir) throws IOException {
        return this.createFileTxnSnapLogWithAutoCreateDataDir(logDir, snapDir, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileTxnSnapLog createFileTxnSnapLogWithAutoCreateDataDir(File logDir, File snapDir, String autoCreateValue) throws IOException {
        FileTxnSnapLog fileTxnSnapLog;
        String priorAutocreateDirValue = System.getProperty("zookeeper.datadir.autocreate");
        System.setProperty("zookeeper.datadir.autocreate", autoCreateValue);
        try {
            fileTxnSnapLog = new FileTxnSnapLog(logDir, snapDir);
        }
        finally {
            if (priorAutocreateDirValue == null) {
                System.clearProperty("zookeeper.datadir.autocreate");
            } else {
                System.setProperty("zookeeper.datadir.autocreate", priorAutocreateDirValue);
            }
        }
        return fileTxnSnapLog;
    }

    @Test
    public void testWithAutoCreateDataDir() throws IOException {
        Assert.assertFalse((String)"log directory already exists", (boolean)this.logDir.exists());
        Assert.assertFalse((String)"snapshot directory already exists", (boolean)this.snapDir.exists());
        FileTxnSnapLog fileTxnSnapLog = this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "true");
        Assert.assertTrue((boolean)this.logDir.exists());
        Assert.assertTrue((boolean)this.snapDir.exists());
        Assert.assertTrue((boolean)fileTxnSnapLog.getDataDir().exists());
        Assert.assertTrue((boolean)fileTxnSnapLog.getSnapDir().exists());
    }

    @Test(expected=FileTxnSnapLog.DatadirException.class)
    public void testWithoutAutoCreateDataDir() throws Exception {
        Assert.assertFalse((String)"log directory already exists", (boolean)this.logDir.exists());
        Assert.assertFalse((String)"snapshot directory already exists", (boolean)this.snapDir.exists());
        try {
            this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "false");
        }
        catch (FileTxnSnapLog.DatadirException e) {
            Assert.assertFalse((boolean)this.logDir.exists());
            Assert.assertFalse((boolean)this.snapDir.exists());
            throw e;
        }
        Assert.fail((String)"Expected exception from FileTxnSnapLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTxnLogSyncElapsedTime() throws IOException {
        FileTxnSnapLog fileTxnSnapLog = this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "true");
        TxnHeader hdr = new TxnHeader(1L, 1, 1L, 1L, 5);
        SetDataTxn txn = new SetDataTxn("/foo", new byte[0], 1);
        Request req = new Request(0L, 0, 0, hdr, (Record)txn, 0L);
        try {
            fileTxnSnapLog.append(req);
            fileTxnSnapLog.commit();
            long syncElapsedTime = fileTxnSnapLog.getTxnLogElapsedSyncTime();
            Assert.assertNotEquals((String)"Did not update syncElapsedTime!", (long)-1L, (long)syncElapsedTime);
        }
        finally {
            fileTxnSnapLog.close();
        }
    }

    @Test
    public void testDirCheckWithCorrectFiles() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        try {
            this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException | FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw ContentCheckException.");
        }
    }

    @Test
    public void testDirCheckWithSingleDirSetup() throws IOException {
        this.singleDirSetupWithCorrectFiles();
        try {
            this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.logDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException | FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw ContentCheckException.");
        }
    }

    @Test(expected=FileTxnSnapLog.LogDirContentCheckException.class)
    public void testDirCheckWithSnapFilesInLogDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createSnapshotFile(this.logVersionDir, 3L);
        this.createSnapshotFile(this.logVersionDir, 4L);
        this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
    }

    @Test(expected=FileTxnSnapLog.SnapDirContentCheckException.class)
    public void testDirCheckWithLogFilesInSnapDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createLogFile(this.snapVersionDir, 3L);
        this.createLogFile(this.snapVersionDir, 4L);
        this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
    }
}

