/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.common.PathTrie;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTreeTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(DataTreeTest.class);
    private DataTree dt;

    @Before
    public void setUp() throws Exception {
        this.dt = new DataTree();
    }

    @After
    public void tearDown() throws Exception {
        this.dt = null;
    }

    @Test(timeout=60000L)
    public void testDumpEphemerals() throws Exception {
        int count = 1000;
        long session = 1000L;
        long zxid = 2000L;
        final DataTree dataTree = new DataTree();
        LOG.info("Create {} zkclient sessions and its ephemeral nodes", (Object)count);
        this.createEphemeralNode(session, dataTree, count);
        final AtomicBoolean exceptionDuringDumpEphemerals = new AtomicBoolean(false);
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                PrintWriter pwriter = new PrintWriter(new StringWriter());
                try {
                    while (running.get()) {
                        dataTree.dumpEphemerals(pwriter);
                    }
                }
                catch (Exception e) {
                    LOG.error("Received exception while dumpEphemerals!", (Throwable)e);
                    exceptionDuringDumpEphemerals.set(true);
                }
            }
        };
        thread.start();
        LOG.debug("Killing {} zkclient sessions and its ephemeral nodes", (Object)count);
        this.killZkClientSession(session, zxid, dataTree, count);
        running.set(false);
        thread.join();
        Assert.assertFalse((String)"Should have got exception while dumpEphemerals!", (boolean)exceptionDuringDumpEphemerals.get());
    }

    private void killZkClientSession(long session, long zxid, DataTree dataTree, int count) {
        for (int i = 0; i < count; ++i) {
            dataTree.killSession(session + (long)i, zxid);
        }
    }

    private void createEphemeralNode(long session, DataTree dataTree, int count) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        for (int i = 0; i < count; ++i) {
            dataTree.createNode("/test" + i, new byte[0], null, session + (long)i, dataTree.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        }
    }

    @Test(timeout=60000L)
    public void testRootWatchTriggered() throws Exception {
        class MyWatcher
        implements Watcher {
            boolean fired = false;

            MyWatcher() {
            }

            public void process(WatchedEvent event) {
                if (event.getPath().equals("/")) {
                    this.fired = true;
                }
            }
        }
        MyWatcher watcher = new MyWatcher();
        this.dt.getChildren("/", new Stat(), (Watcher)watcher);
        this.dt.createNode("/xyz", new byte[0], null, 0L, this.dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        Assert.assertFalse((String)"Root node watch not triggered", (!watcher.fired ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testIncrementCversion() throws Exception {
        this.dt.createNode("/test", new byte[0], null, 0L, this.dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        DataNode zk = this.dt.getNode("/test");
        int prevCversion = zk.stat.getCversion();
        long prevPzxid = zk.stat.getPzxid();
        this.dt.setCversionPzxid("/test/", prevCversion + 1, prevPzxid + 1L);
        int newCversion = zk.stat.getCversion();
        long newPzxid = zk.stat.getPzxid();
        Assert.assertTrue((String)("<cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"), (newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0);
    }

    @Test
    public void testPzxidUpdatedWhenDeletingNonExistNode() throws Exception {
        DataNode root = this.dt.getNode("/");
        long currentPzxid = root.stat.getPzxid();
        long zxid = currentPzxid + 1L;
        try {
            this.dt.deleteNode("/testPzxidUpdatedWhenDeletingNonExistNode", zxid);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        root = this.dt.getNode("/");
        currentPzxid = root.stat.getPzxid();
        Assert.assertEquals((long)currentPzxid, (long)zxid);
        long prevPzxid = currentPzxid;
        zxid = prevPzxid - 1L;
        try {
            this.dt.deleteNode("/testPzxidUpdatedWhenDeletingNonExistNode", zxid);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        root = this.dt.getNode("/");
        currentPzxid = root.stat.getPzxid();
        Assert.assertEquals((long)currentPzxid, (long)prevPzxid);
    }

    @Test(timeout=60000L)
    public void testPathTrieClearOnDeserialize() throws Exception {
        DataTree dserTree = new DataTree();
        dserTree.createNode("/bug", new byte[20], null, -1L, 1, 1L, 1L);
        dserTree.createNode("/zookeeper/quota/bug", null, null, -1L, 1, 1L, 1L);
        dserTree.createNode(Quotas.quotaPath((String)"/bug"), new byte[20], null, -1L, 1, 1L, 1L);
        dserTree.createNode(Quotas.statPath((String)"/bug"), new byte[20], null, -1L, 1, 1L, 1L);
        DataTree tree = new DataTree();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
        tree.serialize((OutputArchive)oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)bais);
        dserTree.deserialize((InputArchive)ia, "test");
        Field pfield = DataTree.class.getDeclaredField("pTrie");
        pfield.setAccessible(true);
        PathTrie pTrie = (PathTrie)pfield.get(dserTree);
        Assert.assertEquals((String)"/bug is still in pTrie", (Object)"", (Object)pTrie.findMaxPrefix("/bug"));
    }

    @Test(timeout=60000L)
    public void testSerializeDoesntLockDataNodeWhileWriting() throws Exception {
        DataTree tree = new DataTree();
        tree.createNode("/marker", new byte[]{42}, null, -1L, 1, 1L, 1L);
        final DataNode markerNode = tree.getNode("/marker");
        final AtomicBoolean ranTestCase = new AtomicBoolean();
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        BinaryOutputArchive oa = new BinaryOutputArchive(out){

            public void writeRecord(Record r, String tag) throws IOException {
                if (r instanceof DataNode) {
                    DataNode node = (DataNode)r;
                    if (node.data.length == 1 && node.data[0] == 42) {
                        final Semaphore semaphore = new Semaphore(0);
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                DataNode dataNode = markerNode;
                                synchronized (dataNode) {
                                    semaphore.release();
                                }
                            }
                        }).start();
                        try {
                            boolean acquired = semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                            Assert.assertTrue((String)"Couldn't acquire a lock on the DataNode while we were calling tree.serialize", (boolean)acquired);
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e1);
                        }
                        ranTestCase.set(true);
                    }
                }
                super.writeRecord(r, tag);
            }
        };
        tree.serialize((OutputArchive)oa, "test");
        Assert.assertTrue((String)"Didn't find the expected node", (boolean)ranTestCase.get());
    }

    @Test(timeout=60000L)
    public void testReconfigACLClearOnDeserialize() throws Exception {
        DataTree tree = new DataTree();
        tree.deleteNode("/zookeeper/config", 1L);
        tree.getReferenceCountedAclCache().aclIndex = 0L;
        Assert.assertEquals((String)"expected to have 1 acl in acl cache map", (long)0L, (long)tree.aclCacheSize());
        tree.createNode("/bug", new byte[20], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, -1L, 1, 1L, 1L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
        tree.serialize((OutputArchive)oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)bais);
        tree.deserialize((InputArchive)ia, "test");
        Assert.assertEquals((String)"expected to have 1 acl in acl cache map", (long)1L, (long)tree.aclCacheSize());
        Assert.assertEquals((String)"expected to have the same acl", (Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)tree.getACL("/bug", new Stat()));
        tree.addConfigNode();
        Assert.assertEquals((String)"expected to have 2 acl in acl cache map", (long)2L, (long)tree.aclCacheSize());
        Assert.assertEquals((String)"expected to have the same acl", (Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)tree.getACL("/bug", new Stat()));
    }
}

