/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import org.apache.zookeeper.JUnit4ZKTestRunner;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4ZKTestRunner.class)
public class ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ZKTestCase.class);
    private String testName;
    @Rule
    public TestWatcher watchman = new TestWatcher(){

        public void starting(Description method) {
            System.setProperty("zookeeper.admin.enableServer", "false");
            System.setProperty("zookeeper.4lw.commands.whitelist", "*");
            ZKTestCase.this.testName = method.getMethodName();
            LOG.info("STARTING " + ZKTestCase.this.testName);
        }

        public void finished(Description method) {
            LOG.info("FINISHED " + ZKTestCase.this.testName);
        }

        public void succeeded(Description method) {
            LOG.info("SUCCEEDED " + ZKTestCase.this.testName);
        }

        public void failed(Throwable e, Description method) {
            LOG.info("FAILED " + ZKTestCase.this.testName, e);
        }
    };

    protected String getTestName() {
        return this.testName;
    }
}

